/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sms.impl;

import com.vmware.vim.binding.cis.cm.fault.ComponentManagerFault;
import com.vmware.vim.binding.sms.AboutInfo;
import com.vmware.vim.binding.sms.ReplicationGroupFilter;
import com.vmware.vim.binding.sms.StorageManager;
import com.vmware.vim.binding.sms.provider.Provider;
import com.vmware.vim.binding.sms.provider.ProviderInfo;
import com.vmware.vim.binding.sms.provider.VasaProviderInfo;
import com.vmware.vim.binding.sms.storage.StorageArray;
import com.vmware.vim.binding.sms.storage.StorageContainer;
import com.vmware.vim.binding.sms.storage.StorageContainerResult;
import com.vmware.vim.binding.sms.storage.StorageContainerSpec;
import com.vmware.vim.binding.sms.storage.replication.GroupErrorResult;
import com.vmware.vim.binding.sms.storage.replication.GroupOperationResult;
import com.vmware.vim.binding.sms.storage.replication.QueryReplicationGroupSuccessResult;
import com.vmware.vim.binding.sms.storage.replication.SourceGroupInfo;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.VvolDatastoreInfo;
import com.vmware.vim.binding.vim.vm.replication.ReplicationGroupId;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vsphere.client.common.sms.spec.SourceGroupQuerySpec;
import com.vmware.vsphere.client.sms.CertificateDetailsInfo;
import com.vmware.vsphere.client.sms.SmsService;
import com.vmware.vsphere.client.sms.StorageContainerInfo;
import com.vmware.vsphere.client.sms.StorageProviderInfo;
import com.vmware.vsphere.client.sms.StorageProviderSystemInfo;
import com.vmware.vsphere.client.sms.impl.LocationLookupException;
import com.vmware.vsphere.client.sms.impl.SmsServiceFactory;
import com.vmware.vsphere.client.sms.impl.SmsServiceUnableToConnectException;
import com.vmware.vsphere.client.sms.util.SmsSessionUtil;
import com.vmware.vsphere.client.sms.util.SmsUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SmsPropertyProvider
implements PropertyProviderBean {
    public static final String DATASTORE_TYPE = "Datastore";
    public static final String DATACENTER_TYPE = "Datacenter";
    public static final String DATACENTER_RELATION = "dc";
    public static final String DATASTORE_RELATION = "datastore";
    public static final String DATASTORE_TYPE_PROPERTY = "summary.type";
    public static final String DATASTORE_INFO_PROPERTY = "info";
    public static final String DATASTORE_HOST_PROPERTY = "hostMount";
    public static final String DATASTORE_TYPE_VVOL = "VVOL";
    private static final String DEVICE_GROUP_ID_AUTO_MARKER = "ffffffff-ffff-ffff-ffff-ffffffffffff";
    private final SmsServiceFactory _smsServiceFactory;
    private final DataService _dataService;
    private static final Log _logger = LogFactory.getLog(SmsPropertyProvider.class);

    public SmsPropertyProvider(SmsServiceFactory smsServiceFactory, DataService dataService) {
        this._smsServiceFactory = smsServiceFactory;
        this._dataService = dataService;
    }

    @type(value="Folder")
    public AboutInfo getSmsAboutInfo(ManagedObjectReference rootVcFolder) throws Exception {
        try {
            SmsService smsService = SmsSessionUtil.getService(rootVcFolder.getServerGuid(), this._smsServiceFactory);
            BlockingFuture future = new BlockingFuture();
            smsService.getServiceInstace().queryAboutInfo((Future)future);
            return (AboutInfo)future.get();
        }
        catch (ExecutionException ex) {
            _logger.error((Object)"Failed to retrieve SmsAboutInfo: ", (Throwable)ex);
            throw SmsUtil.handleSmsError(ex);
        }
    }

    @type(value="Folder")
    public SourceGroupInfo[] getReplicationGroupSourceGroupInfo(ManagedObjectReference moRef, SourceGroupQuerySpec spec) throws Exception {
        ArrayList<SourceGroupInfo> groupInfos = new ArrayList<SourceGroupInfo>();
        ArrayList<ReplicationGroupId> nonAutoReplicationGroupIds = new ArrayList<ReplicationGroupId>();
        for (ReplicationGroupId id : spec.replicationGroupIds) {
            if (this.isAutoReplicationGroupId(id)) {
                SourceGroupInfo groupInfo = this.createGroupInfoForAutoRgId(id);
                groupInfos.add(groupInfo);
                continue;
            }
            nonAutoReplicationGroupIds.add(id);
        }
        if (nonAutoReplicationGroupIds.isEmpty()) {
            return groupInfos.toArray(new SourceGroupInfo[groupInfos.size()]);
        }
        try {
            SmsService smsService = SmsSessionUtil.getService(moRef.getServerGuid(), this._smsServiceFactory);
            StorageManager storageManager = smsService.getStorageManager();
            ReplicationGroupFilter filter = new ReplicationGroupFilter();
            filter.groupId = nonAutoReplicationGroupIds.toArray(new ReplicationGroupId[0]);
            GroupOperationResult[] results = storageManager.queryReplicationGroupInfo(filter);
            if (results == null) {
                return null;
            }
            for (GroupOperationResult result : results) {
                if (result instanceof QueryReplicationGroupSuccessResult) {
                    QueryReplicationGroupSuccessResult successResult = (QueryReplicationGroupSuccessResult)result;
                    if (!(successResult.rgInfo instanceof SourceGroupInfo)) continue;
                    groupInfos.add((SourceGroupInfo)successResult.rgInfo);
                    continue;
                }
                if (!(result instanceof GroupErrorResult)) continue;
                GroupErrorResult errorResult = (GroupErrorResult)result;
                if (errorResult.error == null) continue;
                for (Exception error : errorResult.error) {
                    _logger.error((Object)"Failed to query replication group info:", (Throwable)error);
                }
            }
            return groupInfos.toArray(new SourceGroupInfo[groupInfos.size()]);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed to retrieve SourceGroupInfo-s: ", (Throwable)ex);
            throw SmsUtil.handleSmsError(ex);
        }
    }

    @type(value="Folder")
    public StorageProviderInfo[] getStorageProviders(ManagedObjectReference rootVcFolder) throws Exception {
        try {
            StorageProviderInfo[] result = new StorageProviderInfo[]{};
            SmsService smsService = SmsSessionUtil.getService(rootVcFolder.getServerGuid(), this._smsServiceFactory);
            StorageManager storageManager = smsService.getStorageManager();
            BlockingFuture future = new BlockingFuture();
            storageManager.queryProvider((Future)future);
            ManagedObjectReference[] providers = (ManagedObjectReference[])future.get();
            if (providers != null && providers.length > 0) {
                result = new StorageProviderInfo[providers.length];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = new StorageProviderInfo();
                    result[i].provider = providers[i];
                    Provider provider = (Provider)smsService.getManagedObject(providers[i]);
                    BlockingFuture providerInfoFuture = new BlockingFuture();
                    provider.queryProviderInfo((Future)providerInfoFuture);
                    result[i].providerInfo = (ProviderInfo)providerInfoFuture.get();
                }
            }
            return result;
        }
        catch (ExecutionException ex) {
            _logger.error((Object)"Failed to retrieve StorageProviders: ", (Throwable)ex);
            throw SmsUtil.handleSmsError(ex);
        }
    }

    @type(value="Folder")
    public StorageProviderSystemInfo[] getStorageProviderSystems(ManagedObjectReference rootVcFolder) throws Exception {
        try {
            StorageProviderSystemInfo[] result;
            SmsService smsService = SmsSessionUtil.getService(rootVcFolder.getServerGuid(), this._smsServiceFactory);
            StorageManager storageManager = smsService.getStorageManager();
            BlockingFuture queryArrayFuture = new BlockingFuture();
            storageManager.queryArray(null, (Future)queryArrayFuture);
            StorageArray[] storageArrays = (StorageArray[])queryArrayFuture.get();
            HashMap<String, StorageProviderSystemInfo> storageSystemMap = new HashMap<String, StorageProviderSystemInfo>();
            if (storageArrays == null) {
                result = new StorageProviderSystemInfo[1];
            } else {
                result = new StorageProviderSystemInfo[storageArrays.length + 1];
                for (int i = 0; i < storageArrays.length; ++i) {
                    result[i] = new StorageProviderSystemInfo();
                    result[i].storageProviderInfoList = new ArrayList();
                    result[i].storageArray = storageArrays[i];
                    if (storageArrays[i].uuid == null || storageArrays[i].uuid.isEmpty()) continue;
                    storageSystemMap.put(storageArrays[i].uuid, result[i]);
                }
            }
            StorageProviderSystemInfo orphanSystemInfo = new StorageProviderSystemInfo();
            orphanSystemInfo.storageProviderInfoList = new ArrayList();
            result[result.length - 1] = orphanSystemInfo;
            BlockingFuture future = new BlockingFuture();
            storageManager.queryProvider((Future)future);
            ManagedObjectReference[] providers = (ManagedObjectReference[])future.get();
            if (providers != null && providers.length > 0) {
                for (int i = 0; i < providers.length; ++i) {
                    Provider provider = (Provider)smsService.getManagedObject(providers[i]);
                    BlockingFuture providerInfoFuture = new BlockingFuture();
                    provider.queryProviderInfo((Future)providerInfoFuture);
                    ProviderInfo providerInfo = (ProviderInfo)providerInfoFuture.get();
                    if (providerInfo instanceof VasaProviderInfo) {
                        VasaProviderInfo vpInfo = (VasaProviderInfo)providerInfo;
                        CertificateDetailsInfo certInfo = SmsUtil.extractCertificateDetails(vpInfo.certificate);
                        if (vpInfo.relatedStorageArray == null || vpInfo.relatedStorageArray.length == 0) {
                            this.addStorageProviderInfo(orphanSystemInfo, SmsPropertyProvider.newStorageProviderInfo(providers[i], providerInfo, certInfo, null), vpInfo.status);
                            continue;
                        }
                        HashSet<StorageProviderInfo> addedSpInfoSet = new HashSet<StorageProviderInfo>();
                        for (VasaProviderInfo.RelatedStorageArray rsa : vpInfo.relatedStorageArray) {
                            StorageProviderSystemInfo systemInfo = (StorageProviderSystemInfo)((Object)storageSystemMap.get(rsa.arrayId));
                            Boolean isActive = this.isLegacyVasaProvider(vpInfo) ? null : Boolean.valueOf(rsa.active);
                            StorageProviderInfo current = SmsPropertyProvider.newStorageProviderInfo(providers[i], providerInfo, certInfo, isActive);
                            if (systemInfo != null) {
                                this.addStorageProviderInfo(systemInfo, current, vpInfo.status);
                                addedSpInfoSet.add(current);
                                continue;
                            }
                            if (addedSpInfoSet.contains((Object)current)) continue;
                            this.addStorageProviderInfo(orphanSystemInfo, current, vpInfo.status);
                        }
                        continue;
                    }
                    this.addStorageProviderInfo(orphanSystemInfo, SmsPropertyProvider.newStorageProviderInfo(providers[i], providerInfo, null, null), null);
                }
            }
            return result;
        }
        catch (ExecutionException ex) {
            _logger.error((Object)"Failed to retrieve StorageProviders: ", (Throwable)ex);
            throw SmsUtil.handleSmsError(ex);
        }
    }

    private static final StorageProviderInfo newStorageProviderInfo(ManagedObjectReference providerReference, ProviderInfo providerInfo, CertificateDetailsInfo certDetailsInfo, Boolean isActive) {
        StorageProviderInfo result = new StorageProviderInfo();
        result.provider = providerReference;
        result.providerInfo = providerInfo;
        result.certificateDetailsInfo = certDetailsInfo;
        result.isActive = isActive;
        return result;
    }

    @type(value="Folder,Datacenter,ClusterComputeResource,HostSystem")
    public StorageContainerInfo[] getStorageContainersInfo(ManagedObjectReference moRef) throws Exception {
        ValidationUtil.paramsNotNull((Object[])new Object[]{moRef});
        try {
            StorageManager storageManager = this.getStorageManager(moRef);
            if (storageManager == null) {
                _logger.error((Object)"failed to retrieve storage manager");
                return new StorageContainerInfo[0];
            }
            StorageContainerResult storageContainerResult = this.getStorageContainer(storageManager, null);
            if (storageContainerResult == null) {
                _logger.error((Object)"failed to retrieve storage containers");
                return new StorageContainerInfo[0];
            }
            StorageContainer[] storageContainers = storageContainerResult.storageContainer;
            if (storageContainers == null) {
                return new StorageContainerInfo[0];
            }
            StorageContainerInfo[] storageContainerInfos = this.getAvailableStorageContainers(moRef, storageContainers);
            ProviderInfo[] providerInfos = storageContainerResult.providerInfo;
            this.populateStorageProviders(storageContainerInfos, providerInfos);
            StorageArray[] storageArrays = this.getStorageArray(storageManager, null);
            this.populateStorageArrays(storageContainerInfos, storageArrays);
            return storageContainerInfos;
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
            throw exception;
        }
    }

    private StorageContainerInfo[] getAvailableStorageContainers(ManagedObjectReference moRef, StorageContainer[] storageContainers) throws Exception {
        StorageContainerInfo[] emptyResult = new StorageContainerInfo[]{};
        Object[] containerUuids = this.extractContainerUuids(storageContainers);
        if (ArrayUtil.isNullOrEmpty((Object[])containerUuids)) {
            return emptyResult;
        }
        Map<String, Pair<VvolDatastoreInfo, Datastore.HostMount[]>> datastorePropertyMap = this.getDatastoreProperties(moRef, (String[])containerUuids);
        LinkedList<StorageContainerInfo> storageContainerInfos = new LinkedList<StorageContainerInfo>();
        for (StorageContainer storageContainer : storageContainers) {
            VvolDatastoreInfo datastoreInfo = null;
            Datastore.HostMount[] hostMountArray = null;
            StorageContainerInfo storageContainerInfo = new StorageContainerInfo();
            boolean containerInUse = false;
            String containerUuid = storageContainer.uuid;
            Pair<VvolDatastoreInfo, Datastore.HostMount[]> existingDatastoreData = datastorePropertyMap.get(containerUuid);
            if (existingDatastoreData != null) {
                datastoreInfo = (VvolDatastoreInfo)existingDatastoreData.first;
                hostMountArray = (Datastore.HostMount[])existingDatastoreData.second;
                if (hostMountArray != null) {
                    if (moRef.getType().equals(HostSystem.class.getSimpleName())) {
                        for (Datastore.HostMount hostMount : hostMountArray) {
                            if (!hostMount.key.equals((Object)moRef)) continue;
                            containerInUse = true;
                            break;
                        }
                    } else {
                        storageContainerInfo.hosts = this.getHostsReferences(hostMountArray);
                    }
                }
            }
            if (containerInUse) continue;
            storageContainerInfo.storageContainer = storageContainer;
            storageContainerInfo.datastoreInfo = datastoreInfo;
            storageContainerInfos.add(storageContainerInfo);
        }
        return storageContainerInfos.toArray(emptyResult);
    }

    private ManagedObjectReference[] getHostsReferences(Datastore.HostMount[] hostMountArray) throws Exception {
        ManagedObjectReference[] hostRefs = new ManagedObjectReference[hostMountArray.length];
        for (int i = 0; i < hostMountArray.length; ++i) {
            hostRefs[i] = hostMountArray[i].key;
        }
        return hostRefs;
    }

    private Map<String, Pair<VvolDatastoreInfo, Datastore.HostMount[]>> getDatastoreProperties(ManagedObjectReference moRef, String[] containerUuids) throws Exception {
        Constraint relationConstraint;
        HashMap<String, Pair<VvolDatastoreInfo, Datastore.HostMount[]>> datastorePropertyMap = new HashMap<String, Pair<VvolDatastoreInfo, Datastore.HostMount[]>>();
        String[] properties = new String[]{DATASTORE_INFO_PROPERTY, DATASTORE_HOST_PROPERTY};
        if (moRef.getType().equals(Datacenter.class.getSimpleName())) {
            relationConstraint = QueryUtil.createConstraintForRelationship((Object)moRef, (String)DATASTORE_RELATION, (String)DATASTORE_TYPE);
        } else {
            Constraint datacenterConstraint = QueryUtil.createConstraintForRelationship((Object)moRef, (String)DATACENTER_RELATION, (String)DATACENTER_TYPE);
            relationConstraint = QueryUtil.createRelationalConstraint((String)DATASTORE_RELATION, (Constraint)datacenterConstraint, (Boolean)true, (String)DATASTORE_TYPE);
        }
        PropertyConstraint propertyConstraint = QueryUtil.createPropertyConstraint((String)DATASTORE_TYPE, (String)DATASTORE_TYPE_PROPERTY, (Comparator)Comparator.EQUALS, (Object)DATASTORE_TYPE_VVOL);
        Constraint searchConstraint = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{relationConstraint, propertyConstraint}, (Conjoiner)Conjoiner.AND);
        ResultSet datastoreResultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)QueryUtil.buildQuerySpec((Constraint)searchConstraint, (String[])properties));
        if (datastoreResultSet == null || datastoreResultSet.items == null) {
            return datastorePropertyMap;
        }
        for (ResultItem resultItem : datastoreResultSet.items) {
            VvolDatastoreInfo datastoreInfo = null;
            Datastore.HostMount[] hostMountArray = null;
            for (PropertyValue propertyValue : resultItem.properties) {
                if (propertyValue.propertyName.equals(DATASTORE_INFO_PROPERTY)) {
                    datastoreInfo = (VvolDatastoreInfo)propertyValue.value;
                    continue;
                }
                if (!propertyValue.propertyName.equals(DATASTORE_HOST_PROPERTY)) continue;
                hostMountArray = (Datastore.HostMount[])propertyValue.value;
            }
            if (datastoreInfo == null || datastoreInfo.vvolDS == null) {
                _logger.warn((Object)("Can't get VVOL datastores info for object:" + moRef));
                continue;
            }
            datastorePropertyMap.put(datastoreInfo.vvolDS.scId, (Pair<VvolDatastoreInfo, Datastore.HostMount[]>)new Pair((Object)datastoreInfo, hostMountArray));
        }
        return datastorePropertyMap;
    }

    private String[] extractContainerUuids(StorageContainer[] storageContainers) {
        if (ArrayUtil.isNullOrEmpty((Object[])storageContainers)) {
            return new String[0];
        }
        String[] containerUuids = new String[storageContainers.length];
        for (int i = 0; i < storageContainers.length; ++i) {
            containerUuids[i] = storageContainers[i].uuid;
        }
        return containerUuids;
    }

    private void populateStorageProviders(StorageContainerInfo[] storageContainerInfos, ProviderInfo[] providerInfos) {
        if (providerInfos == null) {
            return;
        }
        for (StorageContainerInfo storageContainerInfo : storageContainerInfos) {
            this.populateStorageProvidersForContainer(storageContainerInfo, providerInfos);
        }
    }

    private void populateStorageProvidersForContainer(StorageContainerInfo storageContainerInfo, ProviderInfo[] providerInfos) {
        StorageContainer storageContainer = storageContainerInfo.storageContainer;
        if (storageContainer == null) {
            return;
        }
        LinkedList<ProviderInfo> containerProviders = new LinkedList<ProviderInfo>();
        block0: for (ProviderInfo providerInfo : providerInfos) {
            for (String providerId : storageContainer.providerId) {
                if (!providerId.equals(providerInfo.uid)) continue;
                containerProviders.add(providerInfo);
                continue block0;
            }
        }
        storageContainerInfo.providerInfo = containerProviders.toArray(new ProviderInfo[0]);
    }

    private void populateStorageArrays(StorageContainerInfo[] storageContainerInfos, StorageArray[] storageArrays) {
        if (storageArrays == null) {
            return;
        }
        for (StorageContainerInfo storageContainerInfo : storageContainerInfos) {
            this.populateStorageArraysForContainer(storageContainerInfo, storageArrays);
        }
    }

    private void populateStorageArraysForContainer(StorageContainerInfo storageContainerInfo, StorageArray[] storageArrays) {
        StorageContainer storageContainer = storageContainerInfo.storageContainer;
        if (storageContainer == null) {
            return;
        }
        LinkedList<StorageArray> containerArrays = new LinkedList<StorageArray>();
        block0: for (StorageArray storageArray : storageArrays) {
            for (String arrayId : storageContainer.arrayId) {
                if (!arrayId.equals(storageArray.uuid)) continue;
                containerArrays.add(storageArray);
                continue block0;
            }
        }
        storageContainerInfo.storageArray = containerArrays.toArray(new StorageArray[0]);
    }

    @type(value="Datastore")
    public StorageContainerInfo getVvolDatastoreStorageContainerInfo(ManagedObjectReference datastoreRef) throws Exception {
        ValidationUtil.paramsNotNull((Object[])new Object[]{datastoreRef});
        try {
            String vvolUuid = this.getVvolDatastoreUuid(datastoreRef);
            if (vvolUuid == null) {
                _logger.error((Object)"failed to retrieve VVOL UUID");
                return null;
            }
            StorageManager storageManager = this.getStorageManager(datastoreRef);
            if (storageManager == null) {
                _logger.error((Object)"failed to retrieve storage manager");
                return null;
            }
            StorageContainerResult containerResult = this.getStorageContainer(storageManager, new String[]{vvolUuid});
            if (containerResult == null || ArrayUtil.isNullOrEmpty((Object[])containerResult.providerInfo) || ArrayUtil.isNullOrEmpty((Object[])containerResult.storageContainer)) {
                _logger.warn((Object)"nonexistent or empty container result");
                return null;
            }
            StorageContainer container = containerResult.storageContainer[0];
            ProviderInfo[] providerInfos = containerResult.providerInfo;
            StorageArray[] storageArrays = this.getStorageArray(storageManager, container.providerId);
            StorageContainerInfo storageContainerInfo = new StorageContainerInfo();
            storageContainerInfo.storageContainer = container;
            this.populateStorageProvidersForContainer(storageContainerInfo, providerInfos);
            this.populateStorageArraysForContainer(storageContainerInfo, storageArrays);
            return storageContainerInfo;
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
            throw exception;
        }
    }

    private String getVvolDatastoreUuid(ManagedObjectReference datastoreRef) {
        if (datastoreRef == null) {
            return null;
        }
        try {
            VvolDatastoreInfo datastoreInfo = (VvolDatastoreInfo)QueryUtil.getProperty((DataService)this._dataService, (Object)datastoreRef, (String)DATASTORE_INFO_PROPERTY);
            return datastoreInfo.vvolDS.scId;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private StorageContainerResult getStorageContainer(StorageManager storageManager, String[] datastoreUuid) throws Exception {
        ValidationUtil.paramsNotNull((Object[])new Object[]{storageManager});
        StorageContainerSpec storageContainerSpec = null;
        if (datastoreUuid != null) {
            storageContainerSpec = new StorageContainerSpec();
            storageContainerSpec.containerId = datastoreUuid;
        }
        BlockingFuture storageContainerResultFuture = new BlockingFuture();
        storageManager.queryStorageContainer(storageContainerSpec, (Future)storageContainerResultFuture);
        return (StorageContainerResult)storageContainerResultFuture.get();
    }

    private StorageArray[] getStorageArray(StorageManager storageManager, String[] providerId) throws Exception {
        ValidationUtil.paramsNotNull((Object[])new Object[]{storageManager});
        BlockingFuture storageArrayFuture = new BlockingFuture();
        storageManager.queryArray(providerId, (Future)storageArrayFuture);
        return (StorageArray[])storageArrayFuture.get();
    }

    private void addStorageProviderInfo(StorageProviderSystemInfo systemInfo, StorageProviderInfo spInfo, String status) {
        systemInfo.storageProviderInfoList.add(spInfo);
        if (VasaProviderInfo.VasaProviderStatus.online.toString().equals(status)) {
            ++systemInfo.numOnlineStorageProviders;
        }
    }

    private boolean isLegacyVasaProvider(VasaProviderInfo providerInfo) {
        float version;
        boolean isLegacyProvider = true;
        if (providerInfo != null && (double)(version = Float.valueOf(providerInfo.vasaVersion.trim()).floatValue()) > 1.0) {
            isLegacyProvider = false;
        }
        return isLegacyProvider;
    }

    private boolean isAutoReplicationGroupId(ReplicationGroupId id) {
        if (id == null) {
            return false;
        }
        return id.deviceGroupId != null && DEVICE_GROUP_ID_AUTO_MARKER.equals(id.deviceGroupId.id);
    }

    private SourceGroupInfo createGroupInfoForAutoRgId(ReplicationGroupId groupId) {
        SourceGroupInfo groupInfo = new SourceGroupInfo();
        groupInfo.groupId = groupId;
        groupInfo.name = SmsUtil.getLocalizedString("replicationGroup.autoReplicationGroupName");
        groupInfo.description = SmsUtil.getLocalizedString("replicationGroup.autoReplicationGroupDescription");
        return groupInfo;
    }

    private StorageManager getStorageManager(ManagedObjectReference moRef) throws SmsServiceUnableToConnectException, LocationLookupException, ComponentManagerFault {
        return SmsSessionUtil.getService(moRef.getServerGuid(), this._smsServiceFactory).getStorageManager();
    }
}

