/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sms.impl;

import com.vmware.vim.binding.cis.cm.SearchCriteria;
import com.vmware.vim.binding.cis.cm.ServiceEndPoint;
import com.vmware.vim.binding.cis.cm.ServiceInfo;
import com.vmware.vim.binding.cis.cm.ServiceType;
import com.vmware.vim.binding.cis.cm.fault.ComponentManagerFault;
import com.vmware.vim.binding.cis.cm.site.Folder;
import com.vmware.vim.binding.impl.cis.cm.SearchCriteriaImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceTypeImpl;
import com.vmware.vim.binding.sms.ServiceInstance;
import com.vmware.vim.binding.sms.StorageManager;
import com.vmware.vim.binding.sms.version.versions;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.ext.RequestContextProvider;
import com.vmware.vim.vmomi.client.ext.ResultInterceptor;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.client.http.impl.HttpConfigurationImpl;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vise.vim.cm.ComponentManagerService;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.mks.util.SslThumbprintVerifier;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.commons.vmomi.request.DelegatingRequestContextProvider;
import com.vmware.vise.vim.commons.vmomi.request.ManagedObjectContextHandler;
import com.vmware.vise.vim.commons.vmomi.request.OpIdContextHandler;
import com.vmware.vise.vim.commons.vmomi.response.ResultInterceptorImpl;
import com.vmware.vsphere.client.context.VcSessionCookieContextProvider;
import com.vmware.vsphere.client.sms.SmsService;
import com.vmware.vsphere.client.sms.impl.LocationLookupException;
import com.vmware.vsphere.client.sms.impl.SmsServiceImpl;
import com.vmware.vsphere.client.sms.impl.SmsServiceUnableToConnectException;
import com.vmware.vsphere.client.sms.util.SmsServiceLocationLookup;
import java.net.URI;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;

public class SmsServiceFactory {
    private static final String SERVICE_INSTANCE_MO_REF_TYPE = "SmsServiceInstance";
    private static final String SERVICE_INSTANCE_MO_REF_ID = "ServiceInstance";
    private Class<?> _versionClass;
    private String _vmodlPackage;
    private ThreadPoolExecutor _threadPoolExecutor;
    private KeystoreService _keystoreService;
    private ComponentManagerService _cmService;

    public void setVersionClass(Class<?> versionClass) {
        this._versionClass = versionClass;
    }

    public void setVmodlPackage(String vmodlPackage) {
        this._vmodlPackage = vmodlPackage;
    }

    public void setThreadPoolExecutor(ThreadPoolExecutor executor) {
        this._threadPoolExecutor = executor;
    }

    public void setKeystoreService(KeystoreService keystoreService) {
        this._keystoreService = keystoreService;
    }

    public void setComponentManagerService(ComponentManagerService cmService) {
        this._cmService = cmService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        ClassLoader bundleClassLoader = StorageManager.class.getClassLoader();
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(bundleClassLoader);
            VmodlContext.initContext((String[])new String[]{this._vmodlPackage});
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
    }

    public SmsService connectSmsService(VcService vcService) throws LocationLookupException, SmsServiceUnableToConnectException, ComponentManagerFault {
        HttpConfigurationImpl httpConfiguration = new HttpConfigurationImpl();
        if (this._keystoreService != null && VcServiceUtil.is2014VcOrLater((String)vcService.getServiceGuid()) && SmsServiceFactory.isVcFromStartupLinkedVcGroup(vcService.getServiceGuid())) {
            httpConfiguration.setTrustStore(this._keystoreService.getKeyStore());
        } else {
            SslThumbprintVerifier sslThumbprintVerifier = new SslThumbprintVerifier();
            sslThumbprintVerifier.setThumbprint(vcService.getThumbprint());
            httpConfiguration.setThumbprintVerifier((ThumbprintVerifier)sslThumbprintVerifier);
        }
        HttpClientConfiguration httpClientConfiguration = HttpClientConfiguration.Factory.newInstance();
        httpClientConfiguration.setExecutor((Executor)this._threadPoolExecutor);
        httpClientConfiguration.setHttpConfiguration((HttpConfiguration)httpConfiguration);
        String sessionCookie = vcService.getConnectionInfo().getSessionCookie();
        VcSessionCookieContextProvider cookieProvider = new VcSessionCookieContextProvider(sessionCookie);
        DelegatingRequestContextProvider contextProvider = new DelegatingRequestContextProvider(new ManagedObjectContextHandler[]{cookieProvider, new OpIdContextHandler()});
        httpClientConfiguration.setRequestContextProvider((RequestContextProvider)contextProvider);
        httpClientConfiguration.setResultInterceptor((ResultInterceptor)new ResultInterceptorImpl());
        Client client = VcServiceUtil.isVc61OrLater((String)vcService.getServiceGuid()) ? Client.Factory.createClient((URI)this.lookupSmsURI(vcService), (Class)versions.SMS_VERSION_NEWEST, (ClientConfiguration)httpClientConfiguration) : Client.Factory.createClient((URI)this.lookupSmsURI(vcService), this._versionClass, (ClientConfiguration)httpClientConfiguration);
        ManagedObjectReference serviceMoRef = new ManagedObjectReference(SERVICE_INSTANCE_MO_REF_TYPE, SERVICE_INSTANCE_MO_REF_ID);
        ServiceInstance service = (ServiceInstance)client.createStub(ServiceInstance.class, serviceMoRef);
        return new SmsServiceImpl(client, service);
    }

    private static boolean isVcFromStartupLinkedVcGroup(String vcServiceGuid) {
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        if (linkedVcGroupRegistry == null) {
            return false;
        }
        LinkedVcGroup[] startupGroups = linkedVcGroupRegistry.getUtils().getStartupLinkedVcGroups();
        if (startupGroups == null) {
            return false;
        }
        for (LinkedVcGroup vcGroup : startupGroups) {
            if (vcGroup.getVcService(vcServiceGuid) == null) continue;
            return true;
        }
        return false;
    }

    private URI lookupSmsURI(VcService vcService) throws ComponentManagerFault, LocationLookupException {
        if (VcServiceUtil.is2014VcOrLater((String)vcService.getServiceGuid()) && SmsServiceFactory.isVcFromStartupLinkedVcGroup(vcService.getServiceGuid())) {
            ServiceInfo vcServiceInfo = this._cmService.getService(vcService.getServiceGuid());
            Folder vcFolder = vcServiceInfo.getFolder();
            ServiceTypeImpl serviceType = new ServiceTypeImpl("com.vmware.vim.sms", "sms");
            SearchCriteriaImpl searchCriteria = new SearchCriteriaImpl((ServiceType)serviceType, vcFolder, null, null, null);
            ServiceInfo result = this._cmService.search((SearchCriteria)searchCriteria)[0];
            ServiceEndPoint[] endpoints = result.getServiceEndPoints();
            for (int i = 0; i < endpoints.length; ++i) {
                if (!"com.vmware.vim.sms".equals(endpoints[i].getEndPointType().getTypeId())) continue;
                return endpoints[i].getUrl();
            }
            return null;
        }
        return SmsServiceLocationLookup.getSmsServiceLocation(vcService);
    }
}

