/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sms.impl;

import com.vmware.vim.binding.sms.ServiceInstance;
import com.vmware.vim.binding.sms.StorageManager;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vsphere.client.sms.SmsService;
import com.vmware.vsphere.client.sms.impl.SmsServiceUnableToConnectException;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SmsServiceImpl
implements SmsService {
    private static final Log _logger = LogFactory.getLog(SmsServiceImpl.class);
    private Client _vmomiClient;
    private ServiceInstance _serviceInstance;
    private VmodlTypeMap _typeMap;
    private StorageManager _storageManager;

    public SmsServiceImpl(Client vmomiClient, ServiceInstance serviceInstance) {
        this._vmomiClient = vmomiClient;
        this._serviceInstance = serviceInstance;
        this._typeMap = VmodlTypeMap.Factory.getTypeMap();
    }

    @Override
    public ServiceInstance getServiceInstace() {
        return this._serviceInstance;
    }

    @Override
    public StorageManager getStorageManager() throws SmsServiceUnableToConnectException {
        if (this._storageManager == null) {
            BlockingFuture future = new BlockingFuture();
            this._serviceInstance.queryStorageManager((Future)future);
            try {
                this._storageManager = (StorageManager)this.getManagedObject((ManagedObjectReference)future.get());
            }
            catch (ExecutionException e) {
                throw new SmsServiceUnableToConnectException(e);
            }
            catch (InterruptedException e) {
                throw new SmsServiceUnableToConnectException(e);
            }
        }
        return this._storageManager;
    }

    @Override
    public <T extends ManagedObject> T getManagedObject(ManagedObjectReference moRef) {
        VmodlType vmodlType = this._typeMap.getVmodlType(moRef.getType());
        Class typeClass = vmodlType.getTypeClass();
        ManagedObject result = this._vmomiClient.createStub(typeClass, moRef);
        return (T)result;
    }

    @Override
    public void logout() {
        try {
            if (this._vmomiClient != null) {
                this._vmomiClient.shutdown();
            }
        }
        catch (Exception ex) {
            _logger.error((Object)("Failed to shutdown vlsi client: " + ex.getMessage()));
        }
    }
}

