/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sms.util;

import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.sms.impl.LocationLookupException;
import com.vmware.vsphere.client.sms.util.SmsUtil;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SmsServiceLocationLookup {
    private static final Log _logger = LogFactory.getLog(SmsServiceLocationLookup.class);
    private static final String SMS_SERVICE_SUBDIR = "/sms/sdk";

    public static URI getSmsServiceLocation(VcService vcService) throws LocationLookupException {
        String vcServiceUrl = vcService.getServiceUrl();
        if (StringUtil.isNullOrEmpty((String)vcServiceUrl)) {
            _logger.error((Object)"getSmsServiceLocation: Failed to retrieve the VC URL.");
            throw new LocationLookupException(SmsUtil.getLocalizedString("error.FailedToRetrieveVcServiceUrl"));
        }
        try {
            URL vcUrl = new URL(vcServiceUrl);
            URL smsUrl = new URL(vcUrl.getProtocol(), vcUrl.getHost(), vcUrl.getPort(), SMS_SERVICE_SUBDIR);
            return smsUrl.toURI();
        }
        catch (URISyntaxException e) {
            _logger.error((Object)e);
            throw new LocationLookupException(e);
        }
        catch (MalformedURLException e) {
            _logger.error((Object)e);
            throw new LocationLookupException(e);
        }
    }
}

