/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sms.util;

import com.vmware.vim.binding.cis.cm.fault.ComponentManagerFault;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.commons.vcservice.VcServiceConnectionInfo;
import com.vmware.vsphere.client.sms.SmsService;
import com.vmware.vsphere.client.sms.impl.LocationLookupException;
import com.vmware.vsphere.client.sms.impl.SmsServiceFactory;
import com.vmware.vsphere.client.sms.impl.SmsServiceUnableToConnectException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;

public class SmsSessionUtil
extends SessionUtil {
    private static final String SMS_SERVICE_MAP = "com.vmware.vsphere.client.sms.util.SMS_SERVICE_MAP";
    private static final String SMS_SYNC_OBJ_KEY = "com.vmware.vsphere.client.sms.util.SMS_SYNC_OBJ_KEY";

    public static SmsService getService(String serviceGuid, SmsServiceFactory serviceFactory) throws LocationLookupException, SmsServiceUnableToConnectException, ComponentManagerFault {
        return SmsSessionUtil.getService(serviceGuid, null, serviceFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SmsService getService(String serviceGuid, HttpSession session, SmsServiceFactory serviceFactory) throws LocationLookupException, SmsServiceUnableToConnectException, ComponentManagerFault {
        Object syncObject;
        VcService vcService = VimSessionUtil.getService((String)serviceGuid, (HttpSession)session);
        String smsServiceKey = SmsSessionUtil.getSmsServiceKey(vcService);
        if (smsServiceKey == null) {
            return null;
        }
        Map<String, SmsService> serviceMap = null;
        Object object = syncObject = SmsSessionUtil.getSyncObject((String)SMS_SYNC_OBJ_KEY, (HttpSession)session);
        synchronized (object) {
            serviceMap = SmsSessionUtil.getSmsServiceMap(session);
            if (serviceMap.containsKey(smsServiceKey)) {
                return serviceMap.get(smsServiceKey);
            }
        }
        SmsService smsService = serviceFactory.connectSmsService(vcService);
        Object object2 = syncObject;
        synchronized (object2) {
            serviceMap.put(smsServiceKey, smsService);
        }
        return smsService;
    }

    private static String getSmsServiceKey(VcService vcService) {
        if (vcService == null) {
            return null;
        }
        VcServiceConnectionInfo connectionInfo = vcService.getConnectionInfo();
        if (connectionInfo == null) {
            return null;
        }
        return vcService.getServiceGuid() + ":" + connectionInfo.getSessionCookie();
    }

    public static void logoutAllSmsServices(String clientId) {
        Map serviceMap = (Map)SessionUtil.getData((String)SMS_SERVICE_MAP, (String)clientId);
        if (serviceMap == null || serviceMap.isEmpty()) {
            return;
        }
        for (SmsService smsService : serviceMap.values()) {
            smsService.logout();
        }
    }

    private static Map<String, SmsService> getSmsServiceMap(HttpSession session) {
        HashMap serviceMap = (HashMap)SmsSessionUtil.getData((String)SMS_SERVICE_MAP);
        if (serviceMap == null) {
            serviceMap = new HashMap();
            SmsSessionUtil.setData((String)SMS_SERVICE_MAP, serviceMap);
        }
        return serviceMap;
    }
}

