/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.blueprint.blueprint.reflect.internal.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.factory.support.ManagedProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedManagedProperties
extends ManagedProperties {
    private final Map<Object, Object> orderedStorage = new LinkedHashMap<Object, Object>();

    public void clear() {
        this.orderedStorage.clear();
    }

    public boolean containsKey(Object key) {
        return this.orderedStorage.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.orderedStorage.containsValue(value);
    }

    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.orderedStorage.entrySet();
    }

    public boolean equals(Object o) {
        return this.orderedStorage.equals(o);
    }

    public Object get(Object key) {
        return this.orderedStorage.get(key);
    }

    public int hashCode() {
        return this.orderedStorage.hashCode();
    }

    public boolean isEmpty() {
        return this.orderedStorage.isEmpty();
    }

    public Set<Object> keySet() {
        return this.orderedStorage.keySet();
    }

    public Object put(Object key, Object value) {
        return this.orderedStorage.put(key, value);
    }

    public void putAll(Map<? extends Object, ? extends Object> t) {
        this.orderedStorage.putAll(t);
    }

    public Object remove(Object key) {
        return this.orderedStorage.remove(key);
    }

    public int size() {
        return this.orderedStorage.size();
    }

    public Collection<Object> values() {
        return this.orderedStorage.values();
    }

    public String getProperty(String key, String defaultValue) {
        String val = this.getProperty(key);
        return val == null ? defaultValue : val;
    }

    public String getProperty(String key) {
        Object val = this.orderedStorage.get(key);
        return val instanceof String ? (String)val : null;
    }

    public Enumeration<?> propertyNames() {
        return new ArrayEnumeration<String>(this.filter(this.orderedStorage.keySet(), String.class));
    }

    public synchronized Object setProperty(String key, String value) {
        return this.orderedStorage.put(key, value);
    }

    public synchronized boolean contains(Object value) {
        return this.orderedStorage.containsKey(value);
    }

    public synchronized Enumeration<Object> elements() {
        return new ArrayEnumeration<Object>(this.filter(this.orderedStorage.values(), Object.class));
    }

    public synchronized Enumeration<Object> keys() {
        return new ArrayEnumeration<Object>(this.filter(this.orderedStorage.keySet(), Object.class));
    }

    public synchronized String toString() {
        return this.orderedStorage.toString();
    }

    public Object merge(Object parent) {
        if (!this.isMergeEnabled()) {
            throw new IllegalStateException("Not allowed to merge when the 'mergeEnabled' property is set to 'false'");
        }
        if (parent == null) {
            return this;
        }
        if (!(parent instanceof Properties)) {
            throw new IllegalArgumentException("Cannot merge with object of type [" + parent.getClass() + "]");
        }
        OrderedManagedProperties merged = new OrderedManagedProperties();
        ((Properties)((Object)merged)).putAll((Map<?, ?>)((Properties)parent));
        ((Properties)((Object)merged)).putAll((Map<?, ?>)((Object)this));
        return merged;
    }

    private <T> T[] filter(Collection<?> collection, Class<T> type) {
        ArrayList list = new ArrayList();
        for (Object member : collection) {
            if (!type.isInstance(member)) continue;
            list.add(member);
        }
        return list.toArray(new Object[list.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayEnumeration<E>
    implements Enumeration<E> {
        private final E[] array;
        private int counter = 0;

        ArrayEnumeration(E[] array) {
            this.array = array;
        }

        @Override
        public boolean hasMoreElements() {
            return this.counter < this.array.length;
        }

        @Override
        public E nextElement() {
            if (this.hasMoreElements()) {
                return this.array[this.counter++];
            }
            throw new NoSuchElementException();
        }
    }
}

