/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.blueprint.service.importer.support.internal.aop;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.gemini.blueprint.util.OsgiServiceReferenceUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

class ReferenceHolder {
    private static final Log LOGGER = LogFactory.getLog(ReferenceHolder.class);
    private final ServiceReference reference;
    private final BundleContext bundleContext;
    private final long id;
    private final int ranking;
    private volatile Object service;

    public ReferenceHolder(ServiceReference reference, BundleContext bundleContext) {
        this.reference = reference;
        this.bundleContext = bundleContext;
        this.id = OsgiServiceReferenceUtils.getServiceId(reference);
        this.ranking = OsgiServiceReferenceUtils.getServiceRanking(reference);
    }

    public Object getService() {
        if (this.service != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Returning cached instance of " + this.reference));
            }
            return this.service;
        }
        if (this.reference != null) {
            this.service = this.bundleContext.getService(this.reference);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Returning instance of " + this.reference + " " + this.service));
            }
            return this.service;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Returning null.");
        }
        return null;
    }

    public long getId() {
        return this.id;
    }

    public int getRanking() {
        return this.ranking;
    }

    public ServiceReference getReference() {
        return this.reference;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ReferenceHolder) {
            return ((ReferenceHolder)obj).id == this.id;
        }
        if (obj instanceof ServiceReference) {
            return this.id == OsgiServiceReferenceUtils.getServiceId(this.reference);
        }
        return false;
    }

    public boolean isWorseThen(ServiceReference ref) {
        long otherId;
        int otherRanking = OsgiServiceReferenceUtils.getServiceRanking(ref);
        if (otherRanking > this.ranking) {
            return true;
        }
        return otherRanking == this.ranking && (otherId = OsgiServiceReferenceUtils.getServiceId(ref)) < this.id;
    }
}

