/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.impl;

import com.vmware.vim.binding.sso.admin.AuthenticationAccountInfo;
import com.vmware.vim.binding.sso.admin.CertificateManager;
import com.vmware.vim.binding.sso.admin.ConfigurationManagementService;
import com.vmware.vim.binding.sso.admin.Domain;
import com.vmware.vim.binding.sso.admin.ExternalDomainSchemaDetails;
import com.vmware.vim.binding.sso.admin.IdentitySource;
import com.vmware.vim.binding.sso.admin.IdentitySourceManagementService;
import com.vmware.vim.binding.sso.admin.IdentitySources;
import com.vmware.vim.binding.sso.admin.LdapIdentitySource;
import com.vmware.vim.binding.sso.admin.LdapIdentitySourceDetails;
import com.vmware.vim.binding.sso.admin.fault.ADIDSAlreadyExistFault;
import com.vmware.vim.binding.sso.admin.fault.DirectoryServiceConnectionFault;
import com.vmware.vim.binding.sso.fault.InvalidCredentials;
import com.vmware.vim.binding.sso.fault.NoPermission;
import com.vmware.vim.binding.sso.fault.NotAuthenticated;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.security.CertificateUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.security.certificates.X509Spec;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vise.vim.security.sso.exception.SsoServiceException;
import com.vmware.vsphere.client.sso.admin.DomainManagementService;
import com.vmware.vsphere.client.sso.admin.exception.BackendExceptionTransformer;
import com.vmware.vsphere.client.sso.admin.impl.AdminServiceBase;
import com.vmware.vsphere.client.sso.admin.model.AuthenticationSpec;
import com.vmware.vsphere.client.sso.admin.model.DomainSpec;
import com.vmware.vsphere.client.sso.admin.model.ExternalDomainSpec;
import com.vmware.vsphere.client.sso.admin.model.LocalOSDomainSpec;
import com.vmware.vsphere.client.sso.admin.model.NativeAdDomainSpec;
import com.vmware.vsphere.client.sso.admin.model.X509UsageSpec;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.util.encoders.Base64;

public class IdentitySourceDomainManagementService
extends AdminServiceBase
implements DomainManagementService {
    private static final String X_509_CERTIFICATE = "X.509";
    private static final Log _logger = LogFactory.getLog(IdentitySourceDomainManagementService.class);
    public static final String UNKNOWN_DOMAIN = "?";
    private static final String AUTHENTICATION_TYPE_PASSWORD = LdapIdentitySource.AuthenticationType.password.toString();
    private static final String LDAPS_REGEX = "[lL][dD][aA][pP][sS]";

    public IdentitySourceDomainManagementService(SsoService ssoService, SsoServiceManager ssoServiceManager, BackendExceptionTransformer backendExceptionTransformer) {
        super(ssoService, ssoServiceManager, backendExceptionTransformer);
    }

    public IdentitySourceDomainManagementService(SsoService ssoService, SsoServiceManager ssoServiceManager, Boolean bl, BackendExceptionTransformer backendExceptionTransformer) {
        super(ssoService, ssoServiceManager, bl, backendExceptionTransformer);
    }

    public IdentitySourceDomainManagementService(SsoAdminService ssoAdminService) {
        super(ssoAdminService);
    }

    @Override
    public List<DomainSpec> getIdentitySources(boolean bl) throws Exception {
        try {
            LdapIdentitySource[] ldapIdentitySourceArray;
            Object object;
            IdentitySources identitySources = this.getIdentitySourcesInternal();
            LinkedList<DomainSpec> linkedList = new LinkedList<DomainSpec>();
            IdentitySource identitySource = identitySources.getSystem();
            if (identitySource != null && identitySource.getName() != null) {
                object = new DomainSpec();
                object.domainName = identitySource.getName();
                linkedList.add((DomainSpec)object);
            }
            if ((object = identitySources.getLocalOS()) != null && object.getName() != null) {
                ldapIdentitySourceArray = new LocalOSDomainSpec();
                ldapIdentitySourceArray.domainName = object.getName();
                linkedList.add((DomainSpec)ldapIdentitySourceArray);
            }
            if (identitySources.getNativeAD() != null) {
                ldapIdentitySourceArray = new NativeAdDomainSpec();
                ldapIdentitySourceArray.friendlyName = identitySources.getNativeAD().getName();
                ldapIdentitySourceArray.domainName = identitySources.getNativeAD().getName();
                ldapIdentitySourceArray.domainAlias = this.findAliasFor(identitySources.getNativeAD());
                AuthenticationAccountInfo authenticationAccountInfo = this.getManagementService().getActiveDirectoryAuthnAccountInfo();
                ldapIdentitySourceArray.useMachineAccount = authenticationAccountInfo.isUseMachineAccount();
                ldapIdentitySourceArray.servicePrincipalName = authenticationAccountInfo.getSpn();
                ldapIdentitySourceArray.authenticationSpec = new AuthenticationSpec();
                ldapIdentitySourceArray.authenticationSpec.username = authenticationAccountInfo.getUserName();
                linkedList.add((DomainSpec)ldapIdentitySourceArray);
            }
            if (identitySources.getLdaps() != null) {
                for (LdapIdentitySource ldapIdentitySource : identitySources.getLdaps()) {
                    ExternalDomainSpec externalDomainSpec = IdentitySourceDomainManagementService.createLdapSpec(ldapIdentitySource);
                    linkedList.add(externalDomainSpec);
                }
            }
            if (bl) {
                this.updateDefaultDomainInfo(linkedList);
            }
            return linkedList;
        }
        catch (Exception exception) {
            _logger.error((Object)("Error retrieving domains : " + exception.getMessage()), (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    private String findAliasFor(IdentitySource identitySource) {
        String string = identitySource.getName();
        for (Domain domain : identitySource.domains) {
            if (!string.equals(domain.getName())) continue;
            return domain.getAlias();
        }
        return string;
    }

    public List<DomainSpec> getDomains() throws Exception {
        try {
            Domain[] domainArray;
            IdentitySources identitySources = this.getIdentitySourcesInternal();
            LinkedList<DomainSpec> linkedList = new LinkedList<DomainSpec>();
            IdentitySource identitySource = identitySources.getSystem();
            if (identitySource != null && identitySource.getName() != null) {
                domainArray = identitySource.domains;
                int n = domainArray.length;
                for (int i = 0; i < n; ++i) {
                    Domain domain = domainArray[i];
                    if (StringUtil.isNullOrEmpty((String)domain.getName())) continue;
                    DomainSpec domainSpec = new DomainSpec();
                    domainSpec.domainName = domain.getName();
                    linkedList.add(domainSpec);
                }
            }
            if ((domainArray = identitySources.getLocalOS()) != null && domainArray.getName() != null) {
                LocalOSDomainSpec localOSDomainSpec = new LocalOSDomainSpec();
                localOSDomainSpec.domainName = domainArray.getName();
                linkedList.add(localOSDomainSpec);
            }
            if (identitySources.getNativeAD() != null) {
                IdentitySource identitySource2 = identitySources.getNativeAD();
                for (Object object : identitySource2.domains) {
                    NativeAdDomainSpec nativeAdDomainSpec = new NativeAdDomainSpec();
                    nativeAdDomainSpec.domainName = object.getName();
                    linkedList.add(nativeAdDomainSpec);
                }
            }
            if (identitySources.getLdaps() != null) {
                for (LdapIdentitySource ldapIdentitySource : identitySources.getLdaps()) {
                    Object object;
                    object = new ExternalDomainSpec();
                    object.domainName = ldapIdentitySource.getName();
                    linkedList.add((DomainSpec)object);
                }
            }
            return linkedList;
        }
        catch (Exception exception) {
            _logger.error((Object)("Error retrieving domains : " + exception.getMessage()), (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    private void updateDefaultDomainInfo(List<DomainSpec> list) throws Exception {
        List<String> list2 = this.getDefaultDomains();
        for (DomainSpec domainSpec : list) {
            domainSpec.isDefault = list2.contains(domainSpec.domainName);
        }
    }

    private IdentitySources getIdentitySourcesInternal() throws NotAuthenticated, InvalidCredentials, SsoServiceException, ADIDSAlreadyExistFault {
        IdentitySources identitySources = null;
        try {
            identitySources = this.getManagementService().get();
        }
        catch (NoPermission noPermission) {
            String string = this.getManagementService().getSystemDomainName();
            identitySources = new IdentitySources();
            identitySources.system = new IdentitySource(string, new Domain[]{new Domain(string, string)});
        }
        return identitySources;
    }

    @Override
    public void registerLdapDomain(ExternalDomainSpec externalDomainSpec) throws Exception {
        if (externalDomainSpec == null) {
            throw new IllegalArgumentException("domainSpec");
        }
        try {
            String string;
            LdapIdentitySourceDetails ldapIdentitySourceDetails = this.createLdapIdsDetails(externalDomainSpec);
            IdentitySourceManagementService.AuthenticationCredentials authenticationCredentials = null;
            if (externalDomainSpec.authenticationSpec != null) {
                authenticationCredentials = this.createAuthenticationCredentails(externalDomainSpec.authenticationSpec);
            }
            if ((string = externalDomainSpec.domainAlias) != null && string.trim().isEmpty()) {
                string = null;
            }
            this.getManagementService().registerLdap(externalDomainSpec.serverType, externalDomainSpec.domainName, string, ldapIdentitySourceDetails, externalDomainSpec.authenticationSpec.authenticationType, authenticationCredentials);
        }
        catch (Exception exception) {
            _logger.error((Object)("Error adding LDAP domains : " + exception.getMessage()), (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    public String[] getExternalDomainsCertificates() throws InvalidCredentials, SsoServiceException {
        HttpSession httpSession = SessionUtil.getHttpSession();
        SsoAdminService ssoAdminService = this.getAdminService(httpSession);
        ManagedObjectReference managedObjectReference = this.getManagementService().getSslCertificateManager();
        CertificateManager certificateManager = (CertificateManager)ssoAdminService.getManagedObject(CertificateManager.class, managedObjectReference);
        String[] stringArray = certificateManager.getAllCertificates();
        return stringArray;
    }

    @Override
    public void probeConnectivity(String string, AuthenticationSpec authenticationSpec) throws Exception {
        if (authenticationSpec == null) {
            throw new IllegalArgumentException("authSpec");
        }
        try {
            IdentitySourceManagementService.AuthenticationCredentials authenticationCredentials = this.createAuthenticationCredentails(authenticationSpec);
            this.getManagementService().probeConnectivity(new URI(string), authenticationSpec.authenticationType, authenticationCredentials);
        }
        catch (Exception exception) {
            _logger.error((Object)("Error probing connectivity : " + exception.getMessage()), (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    @Override
    public void removeDomain(String string) throws Exception {
        try {
            this.getManagementService().delete(string);
        }
        catch (Exception exception) {
            _logger.error((Object)("Error removing domain:" + exception.getMessage()), (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    @Override
    public void updateActiveDirectoryDomain(NativeAdDomainSpec nativeAdDomainSpec) throws Exception {
        if (nativeAdDomainSpec == null) {
            throw new IllegalArgumentException("The provided NativeAdDomainSpec could not be null");
        }
        try {
            IdentitySourceManagementService identitySourceManagementService = this.getManagementService();
            String string = nativeAdDomainSpec.domainName;
            boolean bl = nativeAdDomainSpec.useMachineAccount;
            String string2 = "";
            String string3 = "";
            String string4 = null;
            if (!bl) {
                string2 = nativeAdDomainSpec.authenticationSpec.username;
                string3 = nativeAdDomainSpec.authenticationSpec.password;
                string4 = nativeAdDomainSpec.servicePrincipalName;
            }
            IdentitySourceManagementService.AuthenticationCredentials authenticationCredentials = new IdentitySourceManagementService.AuthenticationCredentials(string2, string3, Boolean.valueOf(bl), string4);
            identitySourceManagementService.updateActiveDirectory(string, authenticationCredentials, new ExternalDomainSchemaDetails());
        }
        catch (Exception exception) {
            _logger.error((Object)("Error updating native AD domain: " + exception.getMessage()), (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    @Override
    public void updateExternalDomain(ExternalDomainSpec externalDomainSpec) throws Exception {
        if (externalDomainSpec == null) {
            throw new IllegalArgumentException("domainSpec");
        }
        try {
            LdapIdentitySourceDetails ldapIdentitySourceDetails;
            IdentitySourceManagementService identitySourceManagementService = this.getManagementService();
            if (externalDomainSpec.authenticationSpec != null) {
                ldapIdentitySourceDetails = this.createAuthenticationCredentails(externalDomainSpec.authenticationSpec);
                identitySourceManagementService.updateLdapAuthnType(externalDomainSpec.domainName, externalDomainSpec.authenticationSpec.authenticationType, (IdentitySourceManagementService.AuthenticationCredentials)ldapIdentitySourceDetails);
            }
            ldapIdentitySourceDetails = this.createLdapIdsDetails(externalDomainSpec);
            identitySourceManagementService.updateLdap(externalDomainSpec.domainName, ldapIdentitySourceDetails);
        }
        catch (Exception exception) {
            _logger.error((Object)("Error updating LDAP domain: " + exception.getMessage()), (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    @Override
    public void addExternalDomainCertificate(String string) throws Exception {
        if (string == null) {
            throw new IllegalArgumentException("certificate");
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            CertificateFactory certificateFactory = CertificateFactory.getInstance(X_509_CERTIFICATE);
            Certificate certificate = certificateFactory.generateCertificate(byteArrayInputStream);
            String string2 = new String(Base64.encode((byte[])certificate.getEncoded()));
            HttpSession httpSession = SessionUtil.getHttpSession();
            SsoAdminService ssoAdminService = this.getAdminService(httpSession);
            ManagedObjectReference managedObjectReference = this.getManagementService().getSslCertificateManager();
            CertificateManager certificateManager = (CertificateManager)ssoAdminService.getManagedObject(CertificateManager.class, managedObjectReference);
            certificateManager.addCertificate(string2);
        }
        catch (Exception exception) {
            _logger.error((Object)("Error adding LDAP certificate : " + exception.getMessage()), (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    public boolean removeExternalDomainCertificate(String string) throws Exception {
        _logger.debug((Object)("removeExternalDomainCertificate: " + string));
        try {
            HttpSession httpSession = SessionUtil.getHttpSession();
            SsoAdminService ssoAdminService = this.getAdminService(httpSession);
            ManagedObjectReference managedObjectReference = this.getManagementService().getSslCertificateManager();
            CertificateManager certificateManager = (CertificateManager)ssoAdminService.getManagedObject(CertificateManager.class, managedObjectReference);
            boolean bl = certificateManager.deleteCertificate(string);
            _logger.debug((Object)("removeExternalDomainCertificate result = " + (bl ? "true" : "false")));
            return bl;
        }
        catch (Exception exception) {
            _logger.error((Object)("Error removing LDAP certificate : " + exception.getMessage()), (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    @Override
    public List<String> getDefaultDomains() throws Exception {
        try {
            String[] stringArray = this.getManagementService().getDefaultDomains();
            if (stringArray != null) {
                return Arrays.asList(stringArray);
            }
            return Collections.emptyList();
        }
        catch (Exception exception) {
            _logger.error((Object)("Error getting default domains : " + exception.getMessage()), (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    @Override
    public void setDefaultDomains(String[] stringArray) throws Exception {
        try {
            this.getManagementService().setDefaultDomains(stringArray);
        }
        catch (Exception exception) {
            _logger.error((Object)("Error setting default domain : " + exception.getMessage()), (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    @Override
    public void registerLocalOSDomain(String string) throws Exception {
        try {
            this.getManagementService().registerLocalOS(string);
        }
        catch (Exception exception) {
            _logger.error((Object)("Error registering local domain : " + exception.getMessage()), (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    @Override
    public void registerNativeAd(NativeAdDomainSpec nativeAdDomainSpec) throws Exception {
        String string = nativeAdDomainSpec.domainName;
        boolean bl = nativeAdDomainSpec.useMachineAccount;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (!bl) {
            string2 = nativeAdDomainSpec.authenticationSpec.username;
            string3 = nativeAdDomainSpec.authenticationSpec.password;
            string4 = nativeAdDomainSpec.servicePrincipalName;
        }
        IdentitySourceManagementService.AuthenticationCredentials authenticationCredentials = new IdentitySourceManagementService.AuthenticationCredentials(string2, string3, Boolean.valueOf(bl), string4);
        try {
            this.getManagementService().registerActiveDirectory(string, authenticationCredentials, new ExternalDomainSchemaDetails());
        }
        catch (Exception exception) {
            _logger.error((Object)("Error registering local domain : " + exception.getMessage()), (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    public Map<String, String> getExternalDomainsCertificateUsage(X509UsageSpec[] x509UsageSpecArray) throws SsoServiceException, NotAuthenticated, NoPermission, InvalidCredentials, ADIDSAlreadyExistFault {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        IdentitySources identitySources = this.getManagementService().get();
        if (ArrayUtil.isNullOrEmpty((Object[])identitySources.ldaps)) {
            return hashMap;
        }
        X509Certificate[] x509CertificateArray = this.getExternalDomainCertificates(x509UsageSpecArray);
        String string = null;
        for (LdapIdentitySource ldapIdentitySource : identitySources.ldaps) {
            URI uRI = ldapIdentitySource.getDetails().getPrimaryUrl();
            String string2 = uRI.getScheme();
            if (!string2.matches(LDAPS_REGEX)) continue;
            try {
                X509Certificate[] x509CertificateArray2;
                String string3 = uRI.getHost();
                int n = uRI.getPort();
                ConfigurationManagementService.CertificateChain certificateChain = this.getManagementService().getSslIdentity(string3, n);
                for (X509Certificate x509Certificate : x509CertificateArray2 = this.findValidatingCertificates(x509CertificateArray, certificateChain.certificates)) {
                    String string4 = CertificateUtil.getThumbprint((Certificate)x509Certificate);
                    hashMap.put(string4, ldapIdentitySource.getName());
                }
            }
            catch (Exception exception) {
                string = exception.getLocalizedMessage();
                _logger.warn((Object)("Error getting LDAP domain certificate usage:" + exception.getMessage()));
            }
        }
        if (StringUtil.isNullOrEmpty(string)) {
            return hashMap;
        }
        for (X509UsageSpec x509UsageSpec : x509UsageSpecArray) {
            if (hashMap.containsKey(x509UsageSpec.thumbprint)) continue;
            hashMap.put(x509UsageSpec.thumbprint, UNKNOWN_DOMAIN);
        }
        hashMap.put("error", string);
        return hashMap;
    }

    public ConfigurationManagementService.CertificateChain getSslIdentity(URI uRI) throws NotAuthenticated, NoPermission, InvalidCredentials, DirectoryServiceConnectionFault, SsoServiceException {
        return this.getManagementService().getSslIdentity(uRI.getHost(), uRI.getPort());
    }

    public Set<String> getSystemDomains() throws Exception {
        HashSet<String> hashSet = new HashSet<String>();
        try {
            Domain[] domainArray;
            IdentitySources identitySources = this.getIdentitySourcesInternal();
            IdentitySource identitySource = identitySources.getSystem();
            for (Domain domain : domainArray = identitySource.getDomains()) {
                String string = domain.getName();
                String string2 = domain.getAlias();
                if (!StringUtil.isNullOrEmpty((String)string)) {
                    hashSet.add(string);
                }
                if (StringUtil.isNullOrEmpty((String)string2)) continue;
                hashSet.add(string2);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)("Error retrieving system domains : " + exception.getMessage()), (Throwable)exception);
            throw this.transformBackendException(exception);
        }
        return hashSet;
    }

    private X509Certificate[] findValidatingCertificates(X509Certificate[] x509CertificateArray, String[] stringArray) throws UnsupportedEncodingException, CertificateException, NoSuchAlgorithmException {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        for (String string : stringArray) {
            X509Certificate x509Certificate = (X509Certificate)CertificateUtil.generateCertificate((String)string);
            for (X509Certificate x509Certificate2 : x509CertificateArray) {
                if (x509Certificate.equals(x509Certificate2)) {
                    arrayList.add(x509Certificate2);
                    continue;
                }
                try {
                    x509Certificate.verify(x509Certificate2.getPublicKey());
                    arrayList.add(x509Certificate2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return (X509Certificate[])ArrayUtil.toArray(arrayList, X509Certificate.class);
    }

    private static ExternalDomainSpec createLdapSpec(LdapIdentitySource ldapIdentitySource) {
        ExternalDomainSpec externalDomainSpec = new ExternalDomainSpec();
        externalDomainSpec.serverType = ldapIdentitySource.getType();
        externalDomainSpec.domainName = ldapIdentitySource.getName();
        externalDomainSpec.domainAlias = ldapIdentitySource.getDomains()[0].getAlias();
        if (ldapIdentitySource.details != null) {
            externalDomainSpec.friendlyName = ldapIdentitySource.getDetails().getFriendlyName();
            externalDomainSpec.userBaseDn = ldapIdentitySource.getDetails().getUserBaseDn();
            externalDomainSpec.groupBaseDn = ldapIdentitySource.getDetails().getGroupBaseDn();
            externalDomainSpec.searchTimeoutSeconds = ldapIdentitySource.getDetails().getSearchTimeoutSeconds();
            if (ldapIdentitySource.getDetails().getPrimaryUrl() != null) {
                externalDomainSpec.primaryUrl = ldapIdentitySource.getDetails().getPrimaryUrl().toString();
            }
            if (ldapIdentitySource.getDetails().getFailoverUrl() != null) {
                externalDomainSpec.failoverUrl = ldapIdentitySource.getDetails().getFailoverUrl().toString();
            }
        }
        if (ldapIdentitySource.authenticationDetails != null) {
            externalDomainSpec.authenticationSpec = IdentitySourceDomainManagementService.createAuthenticationSpec(ldapIdentitySource.getAuthenticationDetails());
        }
        if (ldapIdentitySource.details.certificates != null) {
            externalDomainSpec.certificates = IdentitySourceDomainManagementService.convertCertificates(ldapIdentitySource.details.certificates);
        }
        return externalDomainSpec;
    }

    private static List<X509Spec> convertCertificates(String[] stringArray) {
        ArrayList<X509Spec> arrayList = new ArrayList<X509Spec>();
        for (String string : stringArray) {
            try {
                X509Certificate x509Certificate = CertificateUtil.decodeCertificate((String)string);
                X509Spec x509Spec = new X509Spec(x509Certificate);
                arrayList.add(x509Spec);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                _logger.warn((Object)"Unable to decode certificate returned from server", (Throwable)unsupportedEncodingException);
            }
        }
        return arrayList;
    }

    private static AuthenticationSpec createAuthenticationSpec(LdapIdentitySource.AuthenticationDetails authenticationDetails) {
        AuthenticationSpec authenticationSpec = new AuthenticationSpec();
        authenticationSpec.authenticationType = authenticationDetails.getAuthenticationType();
        authenticationSpec.username = authenticationDetails.getUsername();
        return authenticationSpec;
    }

    private LdapIdentitySourceDetails createLdapIdsDetails(ExternalDomainSpec externalDomainSpec) throws URISyntaxException {
        String string = externalDomainSpec.userBaseDn;
        String string2 = externalDomainSpec.groupBaseDn;
        if (string != null && string.trim().isEmpty()) {
            string = null;
        }
        if (string2 != null && string2.trim().isEmpty()) {
            string2 = null;
        }
        URI uRI = null;
        URI uRI2 = null;
        if (this.isNotEmpty(externalDomainSpec.primaryUrl)) {
            uRI = new URI(externalDomainSpec.primaryUrl);
        }
        if (this.isNotEmpty(externalDomainSpec.failoverUrl)) {
            uRI2 = new URI(externalDomainSpec.failoverUrl);
        }
        List<X509Spec> list = externalDomainSpec.certificates;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null && !list.isEmpty()) {
            for (X509Spec x509Spec : list) {
                String string3 = CertificateUtil.trimCertificateMarkers((String)x509Spec.certificateAsString);
                arrayList.add(string3);
            }
        }
        return new LdapIdentitySourceDetails(externalDomainSpec.friendlyName, string, string2, uRI, uRI2, externalDomainSpec.searchTimeoutSeconds, Boolean.valueOf(externalDomainSpec.siteAffinityEnabled), arrayList.toArray(new String[arrayList.size()]));
    }

    private boolean isNotEmpty(String string) {
        return string != null && !string.trim().isEmpty();
    }

    private IdentitySourceManagementService.AuthenticationCredentials createAuthenticationCredentails(AuthenticationSpec authenticationSpec) {
        if (!AUTHENTICATION_TYPE_PASSWORD.equals(authenticationSpec.authenticationType)) {
            return null;
        }
        String string = authenticationSpec.username;
        String string2 = authenticationSpec.password;
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        return new IdentitySourceManagementService.AuthenticationCredentials(string, string2, Boolean.valueOf(false), "placeholder");
    }

    private X509Certificate[] getExternalDomainCertificates(X509UsageSpec[] x509UsageSpecArray) {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        try {
            String[] stringArray;
            for (String string : stringArray = this.getExternalDomainsCertificates()) {
                X509Certificate x509Certificate = CertificateUtil.decodeCertificate((String)string);
                String string2 = CertificateUtil.getThumbprint((Certificate)x509Certificate);
                if (!this.hasMatchingCertificate(x509UsageSpecArray, string2)) continue;
                arrayList.add(x509Certificate);
            }
        }
        catch (Exception exception) {
            _logger.warn((Object)("Cannot construct IdS X509Certificate objects:" + exception.getMessage()));
        }
        return (X509Certificate[])ArrayUtil.toArray(arrayList, X509Certificate.class);
    }

    private boolean hasMatchingCertificate(X509UsageSpec[] x509UsageSpecArray, String string) {
        for (X509UsageSpec x509UsageSpec : x509UsageSpecArray) {
            if (!string.equalsIgnoreCase(x509UsageSpec.thumbprint)) continue;
            return true;
        }
        return false;
    }

    private IdentitySourceManagementService getManagementService() throws SsoServiceException {
        HttpSession httpSession = SessionUtil.getHttpSession();
        SsoAdminService ssoAdminService = this.getAdminService(httpSession);
        return ssoAdminService.getIdentitySourceManagementService();
    }
}

