/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.impl;

import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.security.CertificateUtil;
import com.vmware.vsphere.client.sso.admin.util.SsoAdminUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PemKeyStoreSpi
extends KeyStoreSpi {
    private static final Log _logger = LogFactory.getLog(PemKeyStoreSpi.class);
    private static final String BEGIN_CERT_MARKER = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERT_MARKER = "-----END CERTIFICATE-----";
    private static final String BEGIN_ENCR_PK_MARKER = "-----BEGIN ENCRYPTED PRIVATE KEY-----";
    private static final String END_ENCR_PK_MARKER = "-----END ENCRYPTED PRIVATE KEY-----";
    private static final String BEGIN_PK_MARKER = "-----BEGIN PRIVATE KEY-----";
    private static final String END_PK_MARKER = "-----END PRIVATE KEY-----";
    private static final String BEGIN_RSA_PK_MARKER = "-----BEGIN RSA PRIVATE KEY-----";
    private static final String END_RSA_PK_MARKER = "-----END RSA PRIVATE KEY-----";
    private static final String UTF_8 = "UTF-8";
    private static final String RSA_KEY = "RSA";
    private static final String DEFAULT_CHAIN_ALIAS = "Chain";
    private Vector<String> _aliases = new Vector();
    private List<Section> _sections = new ArrayList<Section>();

    @Override
    public Enumeration<String> engineAliases() {
        return this._aliases.elements();
    }

    @Override
    public boolean engineContainsAlias(String string) {
        return this._aliases.size() == 1 && this._aliases.firstElement().equals(string);
    }

    @Override
    public void engineDeleteEntry(String string) throws KeyStoreException {
        throw new ProviderException("engineDeleteEntry not supported");
    }

    @Override
    public Certificate engineGetCertificate(String string) {
        throw new ProviderException("engineGetCertificate not supported");
    }

    @Override
    public String engineGetCertificateAlias(Certificate certificate) {
        throw new ProviderException("engineGetCertificateAlias not supported");
    }

    @Override
    public Certificate[] engineGetCertificateChain(String string) {
        if (this._aliases.size() != 1 || !this._aliases.firstElement().equals(string)) {
            return null;
        }
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        for (Section section : this._sections) {
            if (!section.type.equals(END_CERT_MARKER)) continue;
            arrayList.add(section.certificate);
        }
        return (Certificate[])ArrayUtil.toArrayOrNull(arrayList, Certificate.class);
    }

    @Override
    public Date engineGetCreationDate(String string) {
        throw new ProviderException("engineGetCreationDate not supported");
    }

    @Override
    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        Key key = null;
        for (Section section : this._sections) {
            if (section.type.equals(END_ENCR_PK_MARKER)) {
                key = this.engineGetKeyEncrypted(section, cArray);
                break;
            }
            if (!section.type.equals(END_RSA_PK_MARKER) && !section.type.equals(END_PK_MARKER)) continue;
            key = this.engineGetKeyUnencrypted(section);
            break;
        }
        return key;
    }

    @Override
    public boolean engineIsCertificateEntry(String string) {
        boolean bl = this.engineIsKeyEntry(string);
        return !bl;
    }

    @Override
    public boolean engineIsKeyEntry(String string) {
        if (this._aliases.size() != 1 || !this._aliases.firstElement().equals(string)) {
            return false;
        }
        for (Section section : this._sections) {
            if (!section.type.equals(END_ENCR_PK_MARKER) && !section.type.equals(END_RSA_PK_MARKER) && !section.type.equals(END_PK_MARKER)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        boolean bl = false;
        StringBuffer stringBuffer = null;
        while (bufferedReader.ready()) {
            String string = bufferedReader.readLine();
            if (string.startsWith(BEGIN_CERT_MARKER) || string.startsWith(BEGIN_ENCR_PK_MARKER) || string.startsWith(BEGIN_PK_MARKER) || string.startsWith(BEGIN_RSA_PK_MARKER)) {
                bl = true;
                stringBuffer = new StringBuffer();
                continue;
            }
            if (string.startsWith(END_CERT_MARKER) || string.startsWith(END_ENCR_PK_MARKER) || string.startsWith(END_PK_MARKER) || string.startsWith(END_RSA_PK_MARKER)) {
                bl = false;
                Section section = this.createNewSection(string, stringBuffer.toString());
                this._sections.add(section);
                continue;
            }
            if (!bl) continue;
            stringBuffer.append(string);
        }
        if (this._sections.size() > 0) {
            this._aliases.add(DEFAULT_CHAIN_ALIAS);
        }
    }

    private Section createNewSection(String string, String string2) throws UnsupportedEncodingException {
        Section section = new Section();
        section.type = string;
        section.data = string2;
        section.derData = Base64.decodeBase64((byte[])section.data.getBytes(UTF_8));
        if (section.type.equals(END_CERT_MARKER)) {
            section.certificate = CertificateUtil.decodeCertificate((byte[])section.derData);
        }
        return section;
    }

    @Override
    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        throw new ProviderException("engineSetCertificateEntry not supported");
    }

    @Override
    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new ProviderException("engineSetKeyEntry not supported");
    }

    @Override
    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new ProviderException("engineSetKeyEntry not supported");
    }

    @Override
    public int engineSize() {
        return this._sections.size();
    }

    @Override
    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new ProviderException("engineSetKeyEntry not supported");
    }

    private Key engineGetKeyUnencrypted(Section section) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        try {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(section.derData);
            KeyFactory keyFactory = KeyFactory.getInstance(RSA_KEY);
            PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            return privateKey;
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            _logger.warn((Object)("Failed to construct the private key:" + invalidKeySpecException.getMessage()));
            throw new NoSuchAlgorithmException(invalidKeySpecException.getLocalizedMessage(), invalidKeySpecException);
        }
    }

    private Key engineGetKeyEncrypted(Section section, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (cArray == null || cArray == null) {
            throw new UnrecoverableKeyException(SsoAdminUtil.getString("sso.admin.exception.noPassword", new String[0]));
        }
        try {
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(section.derData);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(encryptedPrivateKeyInfo.getAlgName());
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
            SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = encryptedPrivateKeyInfo.getKeySpec(secretKey);
            KeyFactory keyFactory = KeyFactory.getInstance(RSA_KEY);
            PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            return privateKey;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            _logger.error((Object)("NoSuchAlgorithmException:" + noSuchAlgorithmException.getLocalizedMessage()));
            String string = SsoAdminUtil.getString("sso.admin.exception.noAlgorithm", noSuchAlgorithmException.getLocalizedMessage());
            throw new NoSuchAlgorithmException(string, noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            _logger.error((Object)("IOException:" + iOException.getLocalizedMessage()));
            throw new NoSuchAlgorithmException(iOException.getLocalizedMessage(), iOException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            _logger.error((Object)("InvalidKeySpecException:" + invalidKeySpecException.getLocalizedMessage()));
            throw new NoSuchAlgorithmException(invalidKeySpecException.getLocalizedMessage(), invalidKeySpecException);
        }
        catch (InvalidKeyException invalidKeyException) {
            _logger.error((Object)("InvalidKeyException:" + invalidKeyException.getLocalizedMessage()));
            throw new NoSuchAlgorithmException(invalidKeyException.getLocalizedMessage(), invalidKeyException);
        }
    }

    private static class Section {
        String type;
        String data;
        byte[] derData;
        X509Certificate certificate;

        private Section() {
        }
    }
}

