/*
 * Decompiled with CFR 0.152.
 */
package AuthZ.util;

import com.vmware.cis.authz.PermissionDefinitions;
import com.vmware.cis.authz.PrivilegeDefinitions;
import com.vmware.cis.authz.RoleDefinitions;
import com.vmware.cis.authz.StructDefinitions;
import com.vmware.vapi.bindings.type.StructType;
import java.util.Map;
import org.apache.commons.lang.Validate;

public final class StructTypeUtil {
    public static void populateCanonicalNameToStructTypeMap(Map<String, StructType> map) {
        Validate.notNull(map);
        StructTypeUtil.add(map, "com.vmware.cis.authz.principal", StructDefinitions.principal);
        StructTypeUtil.add(map, "com.vmware.cis.authz.permission.info", PermissionDefinitions.info);
        StructTypeUtil.add(map, "com.vmware.cis.authz.permission.create_spec", PermissionDefinitions.createSpec);
        StructTypeUtil.add(map, "com.vmware.cis.authz.permission.update_spec", PermissionDefinitions.updateSpec);
        StructTypeUtil.add(map, "com.vmware.cis.authz.permission.query_spec", PermissionDefinitions.querySpec);
        StructTypeUtil.add(map, "com.vmware.cis.authz.privilege.info", PrivilegeDefinitions.info);
        StructTypeUtil.add(map, "com.vmware.cis.authz.privilege.create_spec", PrivilegeDefinitions.createSpec);
        StructTypeUtil.add(map, "com.vmware.cis.authz.privilege.update_spec", PrivilegeDefinitions.updateSpec);
        StructTypeUtil.add(map, "com.vmware.cis.authz.privilege.query_spec", PrivilegeDefinitions.querySpec);
        StructTypeUtil.add(map, "com.vmware.cis.authz.privilege.batch_query_spec", PrivilegeDefinitions.batchQuerySpec);
        StructTypeUtil.add(map, "com.vmware.cis.authz.role.info", RoleDefinitions.info);
        StructTypeUtil.add(map, "com.vmware.cis.authz.role.create_spec", RoleDefinitions.createSpec);
        StructTypeUtil.add(map, "com.vmware.cis.authz.role.update_spec", RoleDefinitions.updateSpec);
    }

    private static void add(Map<String, StructType> map, String string, StructType structType) {
        if (map.containsKey(string)) {
            throw new IllegalArgumentException("Two structures with the same canonical name detected: " + string + ". Unable to populate the map.");
        }
        map.put(string, structType);
    }
}

