/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.authz;

import com.vmware.cis.authz.PermissionDefinitions;
import com.vmware.cis.authz.PermissionProvider;
import com.vmware.cis.authz.PermissionTypes;
import com.vmware.vapi.bindings.server.AsyncContext;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.internal.bindings.server.impl.AsyncContextImpl;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.Validate;

public class PermissionApiInterface
extends ApiInterfaceSkeleton {
    private PermissionProvider impl;

    public PermissionApiInterface() {
        this((Class<? extends PermissionProvider>)null);
    }

    public PermissionApiInterface(Class<? extends PermissionProvider> clazz) {
        this((PermissionProvider)PermissionApiInterface.createImplInstance(clazz, (String)"com.vmware.cis.authz.impl.PermissionImpl", PermissionProvider.class));
    }

    public PermissionApiInterface(PermissionProvider permissionProvider) {
        super("com.vmware.cis.authz.permission");
        Validate.notNull((Object)permissionProvider);
        this.impl = permissionProvider;
        this.registerMethod((ApiMethod)new CreateApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new UpdateApiMethod());
        this.registerMethod((ApiMethod)new DeleteApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new QueryApiMethod());
        this.registerMethod((ApiMethod)new ListDetailApiMethod());
        this.registerMethod((ApiMethod)new QueryDetailApiMethod());
    }

    private class QueryDetailApiMethod
    extends ApiMethodSkeleton {
        public QueryDetailApiMethod() {
            super(PermissionApiInterface.this.getIdentifier(), "query_detail", PermissionDefinitions.__queryDetailInput, PermissionDefinitions.__queryDetailOutput, PermissionApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, PermissionDefinitions.__queryDetailInput, PermissionApiInterface.this.getTypeConverter());
            PermissionTypes.QuerySpec querySpec = (PermissionTypes.QuerySpec)structValueExtractor.valueForField("query_spec");
            PermissionApiInterface.this.impl.queryDetail(querySpec, (AsyncContext<List<PermissionTypes.Info>>)new AsyncContextImpl(PermissionApiInterface.this.getTypeConverter(), PermissionDefinitions.__queryDetailOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class ListDetailApiMethod
    extends ApiMethodSkeleton {
        public ListDetailApiMethod() {
            super(PermissionApiInterface.this.getIdentifier(), "list_detail", PermissionDefinitions.__listDetailInput, PermissionDefinitions.__listDetailOutput, PermissionApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            new StructValueExtractor(structValue, PermissionDefinitions.__listDetailInput, PermissionApiInterface.this.getTypeConverter());
            PermissionApiInterface.this.impl.listDetail((AsyncContext<List<PermissionTypes.Info>>)new AsyncContextImpl(PermissionApiInterface.this.getTypeConverter(), PermissionDefinitions.__listDetailOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class QueryApiMethod
    extends ApiMethodSkeleton {
        public QueryApiMethod() {
            super(PermissionApiInterface.this.getIdentifier(), "query", PermissionDefinitions.__queryInput, PermissionDefinitions.__queryOutput, PermissionApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, PermissionDefinitions.__queryInput, PermissionApiInterface.this.getTypeConverter());
            PermissionTypes.QuerySpec querySpec = (PermissionTypes.QuerySpec)structValueExtractor.valueForField("query_spec");
            PermissionApiInterface.this.impl.query(querySpec, (AsyncContext<List<String>>)new AsyncContextImpl(PermissionApiInterface.this.getTypeConverter(), PermissionDefinitions.__queryOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(PermissionApiInterface.this.getIdentifier(), "list", PermissionDefinitions.__listInput, PermissionDefinitions.__listOutput, PermissionApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            new StructValueExtractor(structValue, PermissionDefinitions.__listInput, PermissionApiInterface.this.getTypeConverter());
            PermissionApiInterface.this.impl.list((AsyncContext<List<String>>)new AsyncContextImpl(PermissionApiInterface.this.getTypeConverter(), PermissionDefinitions.__listOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class DeleteApiMethod
    extends ApiMethodSkeleton {
        public DeleteApiMethod() {
            super(PermissionApiInterface.this.getIdentifier(), "delete", PermissionDefinitions.__deleteInput, PermissionDefinitions.__deleteOutput, PermissionApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, PermissionDefinitions.__deleteInput, PermissionApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("id");
            PermissionApiInterface.this.impl.delete(string, (AsyncContext<Void>)new AsyncContextImpl(PermissionApiInterface.this.getTypeConverter(), PermissionDefinitions.__deleteOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class UpdateApiMethod
    extends ApiMethodSkeleton {
        public UpdateApiMethod() {
            super(PermissionApiInterface.this.getIdentifier(), "update", PermissionDefinitions.__updateInput, PermissionDefinitions.__updateOutput, PermissionApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, PermissionDefinitions.__updateInput, PermissionApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("id");
            PermissionTypes.UpdateSpec updateSpec = (PermissionTypes.UpdateSpec)structValueExtractor.valueForField("update_spec");
            PermissionApiInterface.this.impl.update(string, updateSpec, (AsyncContext<Void>)new AsyncContextImpl(PermissionApiInterface.this.getTypeConverter(), PermissionDefinitions.__updateOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(PermissionApiInterface.this.getIdentifier(), "get", PermissionDefinitions.__getInput, PermissionDefinitions.__getOutput, PermissionApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, PermissionDefinitions.__getInput, PermissionApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("id");
            PermissionApiInterface.this.impl.get(string, (AsyncContext<PermissionTypes.Info>)new AsyncContextImpl(PermissionApiInterface.this.getTypeConverter(), PermissionDefinitions.__getOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class CreateApiMethod
    extends ApiMethodSkeleton {
        public CreateApiMethod() {
            super(PermissionApiInterface.this.getIdentifier(), "create", PermissionDefinitions.__createInput, PermissionDefinitions.__createOutput, PermissionApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, PermissionDefinitions.__createInput, PermissionApiInterface.this.getTypeConverter());
            PermissionTypes.CreateSpec createSpec = (PermissionTypes.CreateSpec)structValueExtractor.valueForField("create_spec");
            PermissionApiInterface.this.impl.create(createSpec, (AsyncContext<String>)new AsyncContextImpl(PermissionApiInterface.this.getTypeConverter(), PermissionDefinitions.__createOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }
}

