/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.authz;

import com.vmware.cis.authz.RoleDefinitions;
import com.vmware.cis.authz.RoleProvider;
import com.vmware.cis.authz.RoleTypes;
import com.vmware.vapi.bindings.server.AsyncContext;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.internal.bindings.server.impl.AsyncContextImpl;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.Validate;

public class RoleApiInterface
extends ApiInterfaceSkeleton {
    private RoleProvider impl;

    public RoleApiInterface() {
        this((Class<? extends RoleProvider>)null);
    }

    public RoleApiInterface(Class<? extends RoleProvider> clazz) {
        this((RoleProvider)RoleApiInterface.createImplInstance(clazz, (String)"com.vmware.cis.authz.impl.RoleImpl", RoleProvider.class));
    }

    public RoleApiInterface(RoleProvider roleProvider) {
        super("com.vmware.cis.authz.role");
        Validate.notNull((Object)roleProvider);
        this.impl = roleProvider;
        this.registerMethod((ApiMethod)new CreateApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new UpdateApiMethod());
        this.registerMethod((ApiMethod)new DeleteApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(RoleApiInterface.this.getIdentifier(), "list", RoleDefinitions.__listInput, RoleDefinitions.__listOutput, RoleApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            new StructValueExtractor(structValue, RoleDefinitions.__listInput, RoleApiInterface.this.getTypeConverter());
            RoleApiInterface.this.impl.list((AsyncContext<List<String>>)new AsyncContextImpl(RoleApiInterface.this.getTypeConverter(), RoleDefinitions.__listOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class DeleteApiMethod
    extends ApiMethodSkeleton {
        public DeleteApiMethod() {
            super(RoleApiInterface.this.getIdentifier(), "delete", RoleDefinitions.__deleteInput, RoleDefinitions.__deleteOutput, RoleApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unsupported;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, RoleDefinitions.__deleteInput, RoleApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("id");
            RoleApiInterface.this.impl.delete(string, (AsyncContext<Void>)new AsyncContextImpl(RoleApiInterface.this.getTypeConverter(), RoleDefinitions.__deleteOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class UpdateApiMethod
    extends ApiMethodSkeleton {
        public UpdateApiMethod() {
            super(RoleApiInterface.this.getIdentifier(), "update", RoleDefinitions.__updateInput, RoleDefinitions.__updateOutput, RoleApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unsupported;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.alreadyExists;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, RoleDefinitions.__updateInput, RoleApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("id");
            RoleTypes.UpdateSpec updateSpec = (RoleTypes.UpdateSpec)structValueExtractor.valueForField("update_spec");
            RoleApiInterface.this.impl.update(string, updateSpec, (AsyncContext<Void>)new AsyncContextImpl(RoleApiInterface.this.getTypeConverter(), RoleDefinitions.__updateOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(RoleApiInterface.this.getIdentifier(), "get", RoleDefinitions.__getInput, RoleDefinitions.__getOutput, RoleApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, RoleDefinitions.__getInput, RoleApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("id");
            RoleApiInterface.this.impl.get(string, (AsyncContext<RoleTypes.Info>)new AsyncContextImpl(RoleApiInterface.this.getTypeConverter(), RoleDefinitions.__getOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class CreateApiMethod
    extends ApiMethodSkeleton {
        public CreateApiMethod() {
            super(RoleApiInterface.this.getIdentifier(), "create", RoleDefinitions.__createInput, RoleDefinitions.__createOutput, RoleApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.alreadyExists;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, RoleDefinitions.__createInput, RoleApiInterface.this.getTypeConverter());
            RoleTypes.CreateSpec createSpec = (RoleTypes.CreateSpec)structValueExtractor.valueForField("create_spec");
            RoleApiInterface.this.impl.create(createSpec, (AsyncContext<String>)new AsyncContextImpl(RoleApiInterface.this.getTypeConverter(), RoleDefinitions.__createOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }
}

