/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.common.sso;

import com.vmware.vim.sso.admin.client.AdminClient;
import com.vmware.vim.sso.admin.client.AdminClientFactory;
import com.vmware.vim.sso.admin.client.ClientConfiguration;
import com.vmware.vim.sso.admin.client.vmomi.VmomiClientConfiguration;
import com.vmware.vim.sso.admin.client.vmomi.VmomiClientFactory;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import java.net.URI;
import java.security.KeyStore;
import java.security.PrivateKey;

public class AdminClientUtil {
    public static AdminClient createAdminClient(SamlToken samlToken, PrivateKey hokKey, URI serverUri, KeyStore trustStore, String trustStorePassword, ThumbprintVerifier thumbprintVerifier) {
        VmomiClientConfiguration.Builder builder = new VmomiClientConfiguration.Builder(serverUri, VmomiClientConfiguration.Version.Version2);
        builder.setSslConfiguration(new VmomiClientConfiguration.SslConfiguration(thumbprintVerifier, trustStore, trustStorePassword));
        VmomiClientConfiguration config = builder.createConfig();
        AdminClientFactory factory = VmomiClientFactory.createAdminClientFactory((VmomiClientConfiguration)config);
        ClientConfiguration.AuthenticationData authData = null;
        if (samlToken != null) {
            authData = hokKey != null ? new ClientConfiguration.AuthenticationData(samlToken, hokKey) : new ClientConfiguration.AuthenticationData(samlToken);
        }
        ClientConfiguration clientConfig = authData != null ? new ClientConfiguration(authData) : new ClientConfiguration();
        return factory.createAdminClient(clientConfig);
    }

    public static AdminClient createAdminClientAnonymous(URI serverUri, KeyStore trustStore, String trustStorePassword, ThumbprintVerifier thumbprintVerifier) {
        return AdminClientUtil.createAdminClient(null, null, serverUri, trustStore, trustStorePassword, thumbprintVerifier);
    }
}

