/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.common.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CipherHelper {
    private static final String RSA_KEY_ALGORITHM = "RSA";
    private static final String CHARSET = "UTF-8";
    private static final CharsetEncoder sENCODER = Charset.forName("UTF-8").newEncoder();
    private static final CharsetDecoder sDECODER = Charset.forName("UTF-8").newDecoder();

    public static void addDefaultProvider() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static String encryptToBase64(Certificate cert, char[] plaintext) throws CipherHelperException {
        try {
            Cipher cipher = Cipher.getInstance(RSA_KEY_ALGORITHM);
            cipher.init(1, cert);
            byte[] encrypted = CipherHelper.applyCipher(cipher, sENCODER.encode(CharBuffer.wrap(plaintext)));
            return Base64.encodeBase64String((byte[])encrypted);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CipherHelperException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new CipherHelperException(e);
        }
        catch (InvalidKeyException e) {
            throw new CipherHelperException(e);
        }
        catch (CharacterCodingException e) {
            throw new CipherHelperException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new CipherHelperException(e);
        }
        catch (BadPaddingException e) {
            throw new CipherHelperException(e);
        }
        catch (ShortBufferException e) {
            throw new CipherHelperException(e);
        }
    }

    public static char[] decryptFromBase64(Key privateKey, String encrypted) throws CipherHelperException {
        try {
            Cipher cipher = Cipher.getInstance(RSA_KEY_ALGORITHM);
            cipher.init(2, privateKey);
            byte[] bytes = Base64.decodeBase64((String)encrypted);
            byte[] decrypted = CipherHelper.applyCipher(cipher, ByteBuffer.wrap(bytes));
            CharBuffer charBuffer = sDECODER.decode(ByteBuffer.wrap(decrypted));
            char[] chars = new char[charBuffer.remaining()];
            charBuffer.get(chars);
            return chars;
        }
        catch (InvalidKeyException e) {
            throw new CipherHelperException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CipherHelperException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new CipherHelperException(e);
        }
        catch (CharacterCodingException e) {
            throw new CipherHelperException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new CipherHelperException(e);
        }
        catch (BadPaddingException e) {
            throw new CipherHelperException(e);
        }
        catch (ShortBufferException e) {
            throw new CipherHelperException(e);
        }
    }

    private static byte[] applyCipher(Cipher cipher, ByteBuffer inBuffer) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        ByteBuffer outBuffer = ByteBuffer.allocate(cipher.getOutputSize(inBuffer.remaining()));
        cipher.doFinal(inBuffer, outBuffer);
        outBuffer.flip();
        byte[] outBytes = new byte[outBuffer.remaining()];
        outBuffer.get(outBytes);
        return outBytes;
    }

    public static class CipherHelperException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private CipherHelperException(Exception cause) {
            super(cause);
        }
    }
}

