/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.common;

import com.vmware.vise.util.Pair;
import com.vmware.vise.util.StringUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;

public class PathTemplate {
    private static final Pattern VARIABLE_NAME_PATTERN = Pattern.compile("\\{(.+?)\\}");
    private static final String STRICT_VALUE_REGEX = "([^\\.]+)";
    private static final String LENIENT_VALUE_REGEX = "(.+)";
    private static final String ASTERISK = "*";
    private final List<String> _variableNames;
    private final Pattern _regexPattern;
    private final String _pathTemplate;

    public PathTemplate(String string) {
        this(string, true);
    }

    public PathTemplate(String string, boolean bl) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            throw new IllegalArgumentException("Invalid path template: " + string);
        }
        this._pathTemplate = string;
        ParseResult parseResult = this.parseTemplate(string, bl);
        this._regexPattern = parseResult._regexPattern != null ? Pattern.compile(parseResult._regexPattern) : null;
        this._variableNames = parseResult._variableNames;
    }

    public String getTemplate() {
        return this._pathTemplate;
    }

    public final List<String> getVariableNames() {
        return Collections.unmodifiableList(this._variableNames);
    }

    public boolean matches(String string) {
        if (string == null) {
            return false;
        }
        if (this._regexPattern == null) {
            return true;
        }
        Matcher matcher = this._regexPattern.matcher(string);
        return matcher.matches();
    }

    public Map<String, Pair<String, Integer>> matchWithPosition(String string) {
        Assert.notNull((Object)string, (String)"'expr' must not be null");
        if (this._regexPattern == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Pair<String, Integer>> linkedHashMap = new LinkedHashMap<String, Pair<String, Integer>>(this._variableNames.size());
        Matcher matcher = this._regexPattern.matcher(string);
        if (matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                String string2 = this._variableNames.get(i - 1);
                String string3 = matcher.group(i);
                Pair pair = new Pair((Object)string3, (Object)matcher.start(i), true);
                linkedHashMap.put(string2, (Pair<String, Integer>)pair);
            }
        }
        return linkedHashMap;
    }

    public Map<String, String> match(String string) {
        Assert.notNull((Object)string, (String)"'expr' must not be null");
        if (this._regexPattern == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(this._variableNames.size());
        Matcher matcher = this._regexPattern.matcher(string);
        if (matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                String string2 = this._variableNames.get(i - 1);
                String string3 = matcher.group(i);
                linkedHashMap.put(string2, string3);
            }
        }
        return linkedHashMap;
    }

    public String toString() {
        return this._pathTemplate;
    }

    private ParseResult parseTemplate(String string, boolean bl) {
        Assert.hasText((String)string, (String)"'pathTemplate' must not be null");
        if (bl && ASTERISK.equals(string)) {
            return new ParseResult(null, Collections.emptyList());
        }
        Matcher matcher = VARIABLE_NAME_PATTERN.matcher(string);
        StringBuilder stringBuilder = new StringBuilder();
        LinkedList<String> linkedList = new LinkedList<String>();
        int n = 0;
        while (matcher.find()) {
            String string2 = matcher.group(1);
            boolean bl2 = string2.endsWith(ASTERISK);
            stringBuilder.append(this.quote(string, n, matcher.start()));
            stringBuilder.append(bl2 ? LENIENT_VALUE_REGEX : STRICT_VALUE_REGEX);
            if (bl2) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            linkedList.add(string2);
            n = matcher.end();
        }
        stringBuilder.append(this.quote(string, n, string.length()));
        return new ParseResult(stringBuilder.toString(), linkedList);
    }

    private String quote(String string, int n, int n2) {
        if (n == n2) {
            return "";
        }
        String string2 = string.substring(n, n2);
        return Pattern.quote(string2);
    }

    public static boolean containsVariables(String string) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            return false;
        }
        Matcher matcher = VARIABLE_NAME_PATTERN.matcher(string);
        return matcher.find();
    }

    public static boolean isTemplate(String string) {
        return PathTemplate.isTemplate(string, true);
    }

    public static boolean isTemplate(String string, boolean bl) {
        return bl && ASTERISK.equals(string) || PathTemplate.containsVariables(string);
    }

    public static boolean matches(String string, String string2) {
        PathTemplate pathTemplate = new PathTemplate(string);
        return pathTemplate.matches(string2);
    }

    private static class ParseResult {
        private final List<String> _variableNames;
        private final String _regexPattern;

        public ParseResult(String string, List<String> list) {
            this._regexPattern = string;
            this._variableNames = list;
        }
    }
}

