/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.commands.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.commands.DataModel;
import com.vmware.vise.data.query.commands.impl.DataModelMetadata;
import com.vmware.vise.data.query.commands.impl.FieldMetadata;
import com.vmware.vise.data.query.commands.impl.RelationshipMetadata;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DataModelMetadataParser<T extends DataModel> {
    public static final String DIRECT_PROPS = "";
    private DataModelMetadata<T> _dataModelMetadata;
    private PropertyMap _propertyMap;

    public void parse(Class<T> clazz, Constraint constraint, Map<String, Object> map) {
        this._dataModelMetadata = new DataModelMetadata<T>(clazz);
        this._propertyMap = new PropertyMap(constraint, map);
        this.enumerateDataModelProperties(this._dataModelMetadata);
    }

    public Set<String> getAllProperties() {
        return this._propertyMap.getAllProperties();
    }

    public Constraint getCompositeConstraint() {
        return this._propertyMap.getCompositeConstraint();
    }

    public Constraint getConstraintForRelationship(String string) {
        return this._propertyMap.getConstraintForRelationship(string);
    }

    public int getRelationshipCount() {
        return this._propertyMap.getRelationshipCount();
    }

    public DataModelMetadata<T> getDataModelMetadata() {
        return this._dataModelMetadata;
    }

    public Map<String, Object> getParameters() {
        return this._propertyMap.getParameters();
    }

    public Map<String, Object> getParametersForRelationship(String string) {
        return this._propertyMap.getParametersForRelationship(string);
    }

    public Set<String> getRelationshipProperties(String string) {
        return this._propertyMap.getRelationshipProperties(string);
    }

    public void removeRelationship(String string) {
        this._propertyMap.removeRelationship(string);
    }

    private void enumerateDataModelProperties(DataModelMetadata<T> dataModelMetadata) {
        this.enumerateDataModelProperties(DIRECT_PROPS, dataModelMetadata);
    }

    private void enumerateDataModelProperties(String string, DataModelMetadata<T> dataModelMetadata) {
        List<FieldMetadata> list = dataModelMetadata.getFieldMatadata();
        for (FieldMetadata fieldMetadata : list) {
            Object object;
            String string2 = string;
            if (fieldMetadata.getRelationships() != null) {
                object = fieldMetadata.getRelationships();
                int n = ((RelationshipMetadata[])object).length;
                for (int i = 0; i < n; ++i) {
                    RelationshipMetadata relationshipMetadata = object[i];
                    string2 = this._propertyMap.addRelationship(string2, relationshipMetadata);
                }
            }
            if (!StringUtil.isNullOrEmpty((String)(object = fieldMetadata.getPropertyName()))) {
                this._propertyMap.addProperty(string2, (String)object);
            }
            if (fieldMetadata.getNestedModel() == null) continue;
            this.enumerateDataModelProperties(string2, fieldMetadata.getNestedModel());
        }
    }

    class PropertyMapItem {
        private final Constraint constraint;
        private final Set<String> properties;

        private PropertyMapItem(Constraint constraint) {
            this.constraint = constraint;
            this.properties = new HashSet<String>();
        }
    }

    final class PropertyMap {
        private int _count;
        private final Map<String, Object> _parameters;
        private final Map<String, PropertyMapItem> _propertiesByRelationship = new HashMap<String, PropertyMapItem>();

        private PropertyMap(Constraint constraint, Map<String, Object> map) {
            this._propertiesByRelationship.put(DataModelMetadataParser.DIRECT_PROPS, new PropertyMapItem(constraint));
            this._count = 1;
            this._parameters = map;
        }

        private void addParametersForRelationship(String string, Map<String, Object> map) {
            PropertyMapItem propertyMapItem = this._propertiesByRelationship.get(string);
            if (propertyMapItem == null) {
                return;
            }
            for (String string2 : propertyMapItem.properties) {
                String string3 = this.joinRelations(string, string2);
                if (this._parameters.get(string3) == null) continue;
                map.put(string2, this._parameters.get(string3));
            }
        }

        private void addProperty(String string, String string2) {
            this._propertiesByRelationship.get(string).properties.add(string2);
        }

        private String addRelationship(String string, RelationshipMetadata relationshipMetadata) {
            String string2 = this.joinRelations(string, relationshipMetadata.getRelation());
            PropertyMapItem propertyMapItem = this._propertiesByRelationship.get(string2);
            if (propertyMapItem == null) {
                PropertyMapItem propertyMapItem2 = this._propertiesByRelationship.get(string);
                propertyMapItem = new PropertyMapItem(this.createChildConstraint(propertyMapItem2.constraint, relationshipMetadata));
                this._propertiesByRelationship.put(string2, propertyMapItem);
                ++this._count;
            }
            this.addProperty(string, relationshipMetadata.getRelation());
            return string2;
        }

        private Constraint createChildConstraint(Constraint constraint, RelationshipMetadata relationshipMetadata) {
            return QueryUtil.createRelationalConstraint(relationshipMetadata.getRelation(), constraint, true, relationshipMetadata.getTargetType());
        }

        private Set<String> getAllProperties() {
            HashSet<String> hashSet = new HashSet<String>();
            for (PropertyMapItem propertyMapItem : this._propertiesByRelationship.values()) {
                hashSet.addAll(propertyMapItem.properties);
            }
            return hashSet;
        }

        private Constraint getCompositeConstraint() {
            if (this._count == 0) {
                return null;
            }
            ArrayList<Constraint> arrayList = new ArrayList<Constraint>(this._count);
            for (PropertyMapItem propertyMapItem : this._propertiesByRelationship.values()) {
                arrayList.add(propertyMapItem.constraint);
            }
            return arrayList.size() > 1 ? QueryUtil.createCompositeConstraint(arrayList.toArray(new Constraint[0]), Conjoiner.OR) : (Constraint)arrayList.get(0);
        }

        private Constraint getConstraintForRelationship(String string) {
            return this._propertiesByRelationship.get(string).constraint;
        }

        private int getRelationshipCount() {
            return this._count;
        }

        private Map<String, Object> getParameters() {
            if (this._parameters == null) {
                return null;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (String string : this._propertiesByRelationship.keySet()) {
                this.addParametersForRelationship(string, hashMap);
            }
            return hashMap;
        }

        private Map<String, Object> getParametersForRelationship(String string) {
            if (this._parameters == null) {
                return null;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            this.addParametersForRelationship(string, hashMap);
            return hashMap;
        }

        private Set<String> getRelationshipProperties(String string) {
            return this._propertiesByRelationship.get(string).properties;
        }

        private String joinRelations(String string, String string2) {
            String string3 = string;
            if (string3 != DataModelMetadataParser.DIRECT_PROPS) {
                string3 = string3 + ".";
            }
            string3 = string3 + string2;
            return string3;
        }

        private void removeRelationship(String string) {
            this._propertiesByRelationship.remove(string);
            --this._count;
        }
    }
}

