/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.commands.impl;

import com.vmware.vise.data.query.commands.DataModel;
import java.lang.reflect.Field;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class ReflectionUtil {
    private static Log _logger = LogFactory.getLog(ReflectionUtil.class);

    private ReflectionUtil() {
    }

    static <T extends DataModel> T instantiateDataObject(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("classDef cannot be passed as null");
        }
        try {
            DataModel dataModel = (DataModel)clazz.newInstance();
            return (T)dataModel;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException("Unable to create reflective instance of: " + clazz.getSimpleName() + "\n " + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalStateException("Unable to create reflective instance of: " + clazz.getSimpleName() + "\n " + instantiationException.toString());
        }
    }

    static <T extends DataModel> void setField(T t, Field field, Object object) {
        if (t == null) {
            throw new IllegalArgumentException("dataModelInstance cannot be null");
        }
        if (field == null) {
            throw new IllegalArgumentException("field cannot be passed as null");
        }
        if (object == null) {
            _logger.warn((Object)("Setting null value on field:" + field.getName()));
        }
        try {
            field.set(t, object);
        }
        catch (IllegalAccessException illegalAccessException) {
            Class<?> clazz = t.getClass();
            throw new IllegalStateException("Can't reflectively set field on instanceof: " + clazz.getSimpleName() + "\n " + illegalAccessException.toString());
        }
    }
}

