/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.impl.DataAdapterExecutionDetails;
import com.vmware.vise.data.query.impl.DataAdapterInfo;
import com.vmware.vise.data.query.impl.DataAdapterUtil;
import com.vmware.vise.data.query.impl.DataAdaptersExecutionResult;
import com.vmware.vise.data.query.impl.DataServiceExtensionRegistryInternal;
import com.vmware.vise.data.query.impl.ProfiledTaskExecutor;
import com.vmware.vise.data.query.impl.ResultSetInfo;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

final class DataAdapterRetriever {
    private final DataServiceExtensionRegistryInternal _dataAdapterRegistryInternal;
    private final ProfiledTaskExecutor _taskExecutor;
    private final Map<QuerySpec, QuerySpec> _internalQueryTransformationMap = new IdentityHashMap<QuerySpec, QuerySpec>();
    private final Map<DataAdapterInfo, List<QuerySpec>> _queriesByAdapter = new IdentityHashMap<DataAdapterInfo, List<QuerySpec>>();
    private final Map<QuerySpec, QuerySpec> _queryBySingleItemQuery = new IdentityHashMap<QuerySpec, QuerySpec>();
    private final Map<QuerySpec, List<ResultSetInfo>> _combinedResultsByQuery = new IdentityHashMap<QuerySpec, List<ResultSetInfo>>();
    private final List<DataAdapterExecutionDetails> _executionDetails = new ArrayList<DataAdapterExecutionDetails>();

    DataAdapterRetriever(DataServiceExtensionRegistryInternal dataServiceExtensionRegistryInternal, ProfiledTaskExecutor profiledTaskExecutor) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{dataServiceExtensionRegistryInternal, profiledTaskExecutor});
        this._dataAdapterRegistryInternal = dataServiceExtensionRegistryInternal;
        this._taskExecutor = profiledTaskExecutor;
    }

    AdapterInvocationResults getResultsFromDataAdapters() throws InterruptedException {
        List<ResultSetInfo> list;
        AdapterInvocationResults adapterInvocationResults = this.invokeDataAdapters(this._queriesByAdapter);
        this._executionDetails.addAll(adapterInvocationResults.executionDetails);
        Map<QuerySpec, List<ResultSetInfo>> map = adapterInvocationResults.adapterResultsByQuery;
        Map<QuerySpec, List<ResultSetInfo>> map2 = this.extractSingleItemResults(map);
        Set<QuerySpec> set = this.extractMultiAdapterQueries(map2, map);
        for (QuerySpec object2 : map.keySet()) {
            QuerySpec querySpec = this._internalQueryTransformationMap.get(object2);
            List<ResultSetInfo> list2 = map.get(object2);
            list = this._combinedResultsByQuery.get(querySpec);
            if (list == null) {
                list = new ArrayList<ResultSetInfo>();
                this._combinedResultsByQuery.put(querySpec, list);
            }
            list.addAll(list2);
        }
        Map<DataAdapterInfo, List<QuerySpec>> map3 = this.getMultiAdapterQueriesByAdapter(set);
        AdapterInvocationResults adapterInvocationResults2 = this.invokeDataAdapters(map3);
        map = adapterInvocationResults2.adapterResultsByQuery;
        DataAdapterRetriever.markResultsAsUnpaged(map);
        for (QuerySpec querySpec : map.keySet()) {
            list = this._internalQueryTransformationMap.get(querySpec);
            List<ResultSetInfo> list3 = map.get(querySpec);
            List<ResultSetInfo> list4 = this._combinedResultsByQuery.get(list);
            if (list4 == null) {
                list4 = new ArrayList<ResultSetInfo>();
                this._combinedResultsByQuery.put((QuerySpec)((Object)list), list4);
            }
            list4.addAll(list3);
        }
        this._executionDetails.addAll(adapterInvocationResults2.executionDetails);
        adapterInvocationResults = new AdapterInvocationResults();
        adapterInvocationResults.adapterResultsByQuery = this._combinedResultsByQuery;
        adapterInvocationResults.executionDetails = this._executionDetails;
        return adapterInvocationResults;
    }

    void addQuerySpecs(Set<QuerySpec> set) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{set});
        for (QuerySpec querySpec : set) {
            this.addQuerySpec(querySpec);
        }
    }

    private void addQuerySpec(QuerySpec querySpec) {
        this._internalQueryTransformationMap.put(querySpec, querySpec);
        Collection<DataAdapterInfo> collection = this._dataAdapterRegistryInternal.getDataAdapters(querySpec);
        if (collection.isEmpty()) {
            Exception exception = new Exception(String.format(Utils.getLocalizedString("error.noAdapterFoundForQuery"), querySpec.name));
            ResultSetInfo resultSetInfo = ResultSetInfo.createErrorResult(exception);
            DataAdapterRetriever.addResult(this._combinedResultsByQuery, querySpec, resultSetInfo);
            return;
        }
        this.addQueriesToAdapters(querySpec, collection);
    }

    private void addQueriesToAdapters(QuerySpec querySpec, Collection<DataAdapterInfo> collection) {
        assert (querySpec != null);
        assert (collection != null);
        Integer n = querySpec.resultSpec.offset;
        QuerySpec querySpec2 = null;
        if (collection.size() > 1 && n != null && n > 0) {
            querySpec2 = DataAdapterRetriever.getSingleItemQuery(querySpec);
            this._queryBySingleItemQuery.put(querySpec2, querySpec);
        }
        for (DataAdapterInfo dataAdapterInfo : collection) {
            List<QuerySpec> list = this._queriesByAdapter.get(dataAdapterInfo);
            if (list == null) {
                list = new ArrayList<QuerySpec>();
                this._queriesByAdapter.put(dataAdapterInfo, list);
            }
            list.add(querySpec);
            if (querySpec2 == null) continue;
            list.add(querySpec2);
        }
    }

    private static QuerySpec getSingleItemQuery(QuerySpec querySpec) {
        ResultSpec resultSpec;
        assert (querySpec != null);
        assert (querySpec.resultSpec != null);
        QuerySpec querySpec2 = new QuerySpec(querySpec);
        querySpec2.resultSpec = resultSpec = (ResultSpec)ObjectUtil.shallowCopy((Object)querySpec.resultSpec, ResultSpec.class);
        resultSpec.maxResultCount = 1;
        resultSpec.offset = 0;
        return querySpec2;
    }

    private Map<QuerySpec, List<ResultSetInfo>> extractSingleItemResults(Map<QuerySpec, List<ResultSetInfo>> map) {
        assert (map != null);
        IdentityHashMap<QuerySpec, List<ResultSetInfo>> identityHashMap = new IdentityHashMap<QuerySpec, List<ResultSetInfo>>();
        for (QuerySpec querySpec : this._queryBySingleItemQuery.keySet()) {
            List<ResultSetInfo> list = map.remove(querySpec);
            identityHashMap.put(querySpec, list);
        }
        return identityHashMap;
    }

    private Set<QuerySpec> extractMultiAdapterQueries(Map<QuerySpec, List<ResultSetInfo>> map, Map<QuerySpec, List<ResultSetInfo>> map2) {
        assert (map != null);
        assert (map2 != null);
        HashSet<QuerySpec> hashSet = new HashSet<QuerySpec>();
        for (QuerySpec querySpec : map.keySet()) {
            List<ResultSetInfo> list = map.get(querySpec);
            if (!DataAdapterRetriever.hasMultiAdapterResults(list)) continue;
            QuerySpec querySpec2 = this._queryBySingleItemQuery.get(querySpec);
            map2.remove(querySpec2);
            QuerySpec querySpec3 = DataAdapterRetriever.getMultiAdapterQuerySpec(querySpec2);
            QuerySpec querySpec4 = this._internalQueryTransformationMap.get(querySpec2);
            this._internalQueryTransformationMap.put(querySpec3, querySpec4);
            hashSet.add(querySpec3);
        }
        return hashSet;
    }

    private Map<DataAdapterInfo, List<QuerySpec>> getMultiAdapterQueriesByAdapter(Set<QuerySpec> set) {
        IdentityHashMap<DataAdapterInfo, List<QuerySpec>> identityHashMap = new IdentityHashMap<DataAdapterInfo, List<QuerySpec>>();
        for (DataAdapterInfo dataAdapterInfo : this._queriesByAdapter.keySet()) {
            List<QuerySpec> list = this.getMultiAdapterQuerySpecs(dataAdapterInfo, set);
            if (list.isEmpty()) continue;
            identityHashMap.put(dataAdapterInfo, list);
        }
        return identityHashMap;
    }

    private List<QuerySpec> getMultiAdapterQuerySpecs(DataAdapterInfo dataAdapterInfo, Set<QuerySpec> set) {
        assert (dataAdapterInfo != null);
        assert (set != null);
        HashSet hashSet = new HashSet(this._queriesByAdapter.get(dataAdapterInfo));
        ArrayList<QuerySpec> arrayList = new ArrayList<QuerySpec>();
        for (QuerySpec querySpec : set) {
            QuerySpec querySpec2 = this._internalQueryTransformationMap.get(querySpec);
            if (!hashSet.contains(querySpec2)) continue;
            arrayList.add(querySpec);
        }
        return arrayList;
    }

    private AdapterInvocationResults invokeDataAdapters(Map<DataAdapterInfo, List<QuerySpec>> map) throws InterruptedException {
        assert (map != null);
        List<DataAdaptersExecutionResult> list = this.runDataTasks(map);
        HashMap<QuerySpec, List<ResultSetInfo>> hashMap = new HashMap<QuerySpec, List<ResultSetInfo>>();
        ArrayList<DataAdapterExecutionDetails> arrayList = new ArrayList<DataAdapterExecutionDetails>(list.size());
        for (DataAdaptersExecutionResult dataAdaptersExecutionResult : list) {
            List<DataAdapterExecutionDetails> list2;
            Map<QuerySpec, ResultSetInfo> map2 = dataAdaptersExecutionResult.getResultsPerQuery();
            if (map2 != null) {
                DataAdapterRetriever.addResults(hashMap, map2);
            }
            if ((list2 = dataAdaptersExecutionResult.getAdaptersExecutionDetails()) == null || list2.size() <= 0) continue;
            arrayList.addAll(list2);
        }
        AdapterInvocationResults adapterInvocationResults = new AdapterInvocationResults();
        adapterInvocationResults.adapterResultsByQuery = hashMap;
        adapterInvocationResults.executionDetails = arrayList;
        return adapterInvocationResults;
    }

    private List<DataAdaptersExecutionResult> runDataTasks(Map<DataAdapterInfo, List<QuerySpec>> map) throws InterruptedException {
        assert (map != null);
        int n = map.size();
        if (n > 0) {
            ArrayList<Callable<DataAdaptersExecutionResult>> arrayList = new ArrayList<Callable<DataAdaptersExecutionResult>>(n);
            ArrayList<DataAdapterUtil.DataAdapterQueryBatch> arrayList2 = new ArrayList<DataAdapterUtil.DataAdapterQueryBatch>(n);
            for (DataAdapterInfo dataAdapterInfo : map.keySet()) {
                List<QuerySpec> list = map.get(dataAdapterInfo);
                QuerySpec[] querySpecArray = list.toArray(new QuerySpec[list.size()]);
                arrayList2.add(new DataAdapterUtil.DataAdapterQueryBatch(dataAdapterInfo, querySpecArray));
                Callable<DataAdaptersExecutionResult> callable = DataAdapterUtil.createAdapterTask(dataAdapterInfo, querySpecArray, "Adapter");
                arrayList.add(callable);
            }
            List<DataAdaptersExecutionResult> list = DataAdapterUtil.executeAdapterTasks(this._taskExecutor, arrayList2, arrayList);
            return list;
        }
        return Collections.emptyList();
    }

    private static QuerySpec getMultiAdapterQuerySpec(QuerySpec querySpec) {
        assert (querySpec != null);
        assert (querySpec.resultSpec != null);
        ResultSpec resultSpec = querySpec.resultSpec;
        if (resultSpec.maxResultCount != null && resultSpec.maxResultCount == 0 || resultSpec.offset == null || resultSpec.offset == 0) {
            return querySpec;
        }
        QuerySpec querySpec2 = new QuerySpec(querySpec);
        ResultSpec resultSpec2 = (ResultSpec)ObjectUtil.shallowCopy((Object)resultSpec, ResultSpec.class);
        if (resultSpec.maxResultCount != null && resultSpec.maxResultCount > 0) {
            resultSpec2.maxResultCount = resultSpec.maxResultCount + resultSpec.offset;
        }
        resultSpec2.offset = 0;
        querySpec2.resultSpec = resultSpec2;
        return querySpec2;
    }

    private static void markResultsAsUnpaged(Map<QuerySpec, List<ResultSetInfo>> map) {
        assert (map != null);
        for (QuerySpec querySpec : map.keySet()) {
            List<ResultSetInfo> list = map.get(querySpec);
            ArrayList<ResultSetInfo> arrayList = new ArrayList<ResultSetInfo>();
            for (ResultSetInfo resultSetInfo : list) {
                ResultSetInfo resultSetInfo2 = ResultSetInfo.getResultSetInfo(resultSetInfo.getResultSet(), resultSetInfo.isSorted(), false);
                arrayList.add(resultSetInfo2);
            }
            list.clear();
            list.addAll(arrayList);
        }
    }

    private static boolean hasMultiAdapterResults(List<ResultSetInfo> list) {
        int n = 0;
        for (ResultSetInfo resultSetInfo : list) {
            if (resultSetInfo == null || resultSetInfo.getItemCount() <= 0) continue;
            ++n;
        }
        boolean bl = n > 1;
        return bl;
    }

    private static void addResults(Map<QuerySpec, List<ResultSetInfo>> map, Map<QuerySpec, ResultSetInfo> map2) {
        assert (map != null);
        assert (map2 != null);
        for (QuerySpec querySpec : map2.keySet()) {
            ResultSetInfo resultSetInfo = map2.get(querySpec);
            DataAdapterRetriever.addResult(map, querySpec, resultSetInfo);
        }
    }

    private static void addResult(Map<QuerySpec, List<ResultSetInfo>> map, QuerySpec querySpec, ResultSetInfo resultSetInfo) {
        assert (map != null);
        List<ResultSetInfo> list = map.get(querySpec);
        if (list == null) {
            list = new ArrayList<ResultSetInfo>();
            map.put(querySpec, list);
        }
        list.add(resultSetInfo);
    }

    static class AdapterInvocationResults {
        Map<QuerySpec, List<ResultSetInfo>> adapterResultsByQuery;
        List<DataAdapterExecutionDetails> executionDetails;

        AdapterInvocationResults() {
        }
    }
}

