/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.common.NameValuePair;
import com.vmware.vise.data.common.XSFacet;
import com.vmware.vise.data.common.XSFacetType;
import com.vmware.vise.metadata.QuantityTypes;
import com.vmware.vise.metadata.Units;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vise.util.ValidationUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DataFormatUtil {
    private static Log _log = LogFactory.getLog(DataFormatUtil.class);
    private static final int PRECISION = 2;
    private static final boolean IS_UNIT_LABEL_INCLUDED = true;

    public static String formatValueWithUnit(Object object, Units units, Units units2) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{object, units, units2});
        QuantityTypes quantityTypes = units.getType();
        QuantityTypes quantityTypes2 = units2.getType();
        if (quantityTypes != quantityTypes2 && !QuantityTypes.ANY.equals((Object)quantityTypes2)) {
            return object.toString();
        }
        try {
            String string = DataFormatUtil.formatValueByUnitType(object, units, units2);
            return string;
        }
        catch (Exception exception) {
            _log.error((Object)"Data formatting operation failed", (Throwable)exception);
            return object.toString();
        }
    }

    public static String formatValueWithStaticValueSpace(Object object, XSFacet[] xSFacetArray) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{object, xSFacetArray});
        if (xSFacetArray.length == 0) {
            return object.toString();
        }
        for (XSFacet xSFacet : xSFacetArray) {
            if (!XSFacetType.ENUMERATION.equals((Object)xSFacet.type)) continue;
            NameValuePair nameValuePair = (NameValuePair)xSFacet.value;
            if (!object.toString().equalsIgnoreCase(nameValuePair.value.toString())) continue;
            String string = nameValuePair.name.toString();
            return string;
        }
        return object.toString();
    }

    private static String formatValueByUnitType(Object object, Units units, Units units2) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{object, units, units2});
        long l = units.getBaseMultiplier();
        long l2 = units2.getBaseMultiplier();
        String string = null;
        switch (units.getType()) {
            case DATE: {
                if (Units.DATE.equals((Object)units2)) {
                    string = FormatUtil.getDateFormatted((Object)object);
                    break;
                }
                if (Units.TIME.equals((Object)units2)) {
                    string = FormatUtil.getTimeFormatted((Object)object);
                    break;
                }
                string = FormatUtil.getDateTimeFormatted((Object)object);
                break;
            }
            case TIME_SPAN: {
                if (Units.AUTO.equals((Object)units2)) {
                    string = FormatUtil.getTimeSpanFormattedToClosestUnit((Number)((Number)object), (long)l);
                    break;
                }
                string = object.toString();
                break;
            }
            case DATA_SIZE: {
                string = FormatUtil.getDataSizeFormatted((Number)((Number)object), (int)2, (long)l, (long)l2, (boolean)true);
                break;
            }
            case FREQUENCY: {
                string = FormatUtil.getFrequencyFormatted((Number)((Number)object), (int)2, (long)l, (long)l2, (boolean)true);
                break;
            }
            case BIT_RATE: {
                string = FormatUtil.getBitRateFormatted((Number)((Number)object), (int)2, (long)l, (long)l2, (boolean)true);
                break;
            }
            default: {
                string = object.toString();
            }
        }
        return string;
    }
}

