/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DerivedPropertyDataInternal;
import com.vmware.vise.data.query.DerivedPropertyInfo;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.impl.DataServiceExtensionRegistryInternal;
import com.vmware.vise.data.query.impl.DerivedPropertyDataImpl;
import com.vmware.vise.data.query.impl.PropertyProviderInfo;
import com.vmware.vise.data.query.impl.ResultSetInfo;
import com.vmware.vise.data.query.impl.SubTypeResolver;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.IdentityHashSet;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.collection.CollectionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DerivedPropertyManager {
    private static final Log _logger = LogFactory.getLog(DerivedPropertyManager.class);
    private final DataServiceExtensionRegistryInternal _dataAdapterRegistry;
    private final QuerySpecBuilder _querySpecBuilder;
    private final ObjectReferenceService _objectReferenceService;
    private final SubTypeResolver _subTypeResolver;

    public DerivedPropertyManager(DataServiceExtensionRegistryInternal dataServiceExtensionRegistryInternal, QuerySpecBuilder querySpecBuilder, ObjectReferenceService objectReferenceService, SubTypeResolver subTypeResolver) {
        this._dataAdapterRegistry = dataServiceExtensionRegistryInternal;
        this._querySpecBuilder = querySpecBuilder;
        this._objectReferenceService = objectReferenceService;
        this._subTypeResolver = subTypeResolver;
    }

    Map<QuerySpec, Pair<QuerySpec, DerivedPropertyDataInternal>> replaceDerivedWithSourcePropsInQueries(QuerySpec[] querySpecArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])querySpecArray)) {
            return new HashMap<QuerySpec, Pair<QuerySpec, DerivedPropertyDataInternal>>();
        }
        HashMap<QuerySpec, Pair<QuerySpec, DerivedPropertyDataInternal>> hashMap = new HashMap<QuerySpec, Pair<QuerySpec, DerivedPropertyDataInternal>>();
        Map<QuerySpec, Pair<QuerySpec, Map<String, List<String>>>> map = this.replaceDerivedWithSourceProps(querySpecArray);
        for (QuerySpec querySpec : querySpecArray) {
            Pair<QuerySpec, Map<String, List<String>>> pair = map.get(querySpec);
            if (pair != null) {
                hashMap.put((QuerySpec)pair.first, (Pair<QuerySpec, DerivedPropertyDataInternal>)new Pair((Object)querySpec, (Object)new DerivedPropertyDataImpl((Map)pair.second, new HashMap<Object, Map<String, Object>>()), false));
                continue;
            }
            hashMap.put(querySpec, (Pair<QuerySpec, DerivedPropertyDataInternal>)new Pair((Object)querySpec, null, false));
        }
        return hashMap;
    }

    private void appendDerivedPropertiesForTypeAndProperties(String string, Set<String> set, Map<String, Pair<Set<String>, Set<String>>> map) {
        assert (map != null);
        Map<String, Set<String>> map2 = this.getSourceProperties(string, set);
        if (map2.isEmpty()) {
            return;
        }
        map.put(string, (Pair<Set<String>, Set<String>>)new Pair(map2.keySet(), this.mergeSourceProperties(map2), true));
    }

    private Map<QuerySpec, Pair<QuerySpec, Map<String, List<String>>>> replaceDerivedWithSourceProps(QuerySpec[] querySpecArray) {
        HashMap<QuerySpec, Pair<QuerySpec, Map<String, List<String>>>> hashMap = new HashMap<QuerySpec, Pair<QuerySpec, Map<String, List<String>>>>();
        for (QuerySpec querySpec : querySpecArray) {
            HashMap<String, List<String>> hashMap2 = new HashMap<String, List<String>>();
            QuerySpec querySpec2 = this.replaceDerivedWithSourceProps(querySpec, hashMap2);
            if (querySpec2 == null) continue;
            hashMap.put(querySpec, (Pair<QuerySpec, Map<String, List<String>>>)new Pair((Object)querySpec2, hashMap2, true));
        }
        return hashMap;
    }

    private QuerySpec replaceDerivedWithSourceProps(QuerySpec querySpec, Map<String, List<String>> map) {
        assert (querySpec != null);
        assert (map != null);
        Map<String, Pair<Set<String>, Set<String>>> map2 = this.getSourceProperties(querySpec);
        if (map2 == null || map2.isEmpty()) {
            return null;
        }
        QuerySpec querySpec2 = querySpec;
        boolean bl = false;
        for (String string : map2.keySet()) {
            Pair<Set<String>, Set<String>> pair = map2.get(string);
            QuerySpec querySpec3 = this.replaceDerivedWithSourcePropsForType(querySpec2, string, (Set)pair.first, (Set)pair.second);
            if (querySpec3 != null) {
                querySpec2 = querySpec3;
                map.put(string, new ArrayList((Collection)pair.second));
                bl = true;
                continue;
            }
            bl = false;
            break;
        }
        if (bl) {
            return querySpec2;
        }
        return null;
    }

    private Map<String, Pair<Set<String>, Set<String>>> getSourceProperties(QuerySpec querySpec) {
        if (querySpec == null) {
            return null;
        }
        Map<String, Set<String>> map = this._querySpecBuilder.getQueryProperties(querySpec, true);
        if (map == null || map.size() == 0) {
            return null;
        }
        HashMap<String, Pair<Set<String>, Set<String>>> hashMap = new HashMap<String, Pair<Set<String>, Set<String>>>();
        Set<String> set2 = map.keySet();
        for (String object2 : set2) {
            if ("*".equals(object2)) continue;
            Set<String> set = map.get(object2);
            this.appendDerivedPropertiesForTypeAndProperties(object2, set, hashMap);
            Set<String> set32 = this._subTypeResolver.getSubTypes(object2);
            if (set32 == null || set32.isEmpty()) continue;
            for (String string : set32) {
                if (set2.contains(string)) continue;
                this.appendDerivedPropertiesForTypeAndProperties(string, set, hashMap);
            }
        }
        Set<String> set3 = map.get("*");
        if (set3 != null && !set3.isEmpty()) {
            Set<String> set = this._dataAdapterRegistry.getDerivedPropertyProvidersRegisteredTypes();
            for (Set<String> set32 : set) {
                this.appendDerivedPropertiesForTypeAndProperties((String)((Object)set32), set3, hashMap);
            }
        }
        if (hashMap.size() == 0) {
            return null;
        }
        return hashMap;
    }

    private QuerySpec replaceDerivedWithSourcePropsForType(QuerySpec querySpec, String string, Set<String> set, Set<String> set2) {
        assert (querySpec != null);
        assert (string != null);
        if (CollectionUtil.isNullOrEmpty(set2) || CollectionUtil.isNullOrEmpty(set)) {
            return null;
        }
        try {
            HashSet<String> hashSet = new HashSet<String>(set);
            for (String string2 : set) {
                hashSet.add(string2 + ".@formatted");
            }
            ArrayList arrayList = new ArrayList();
            boolean bl = false;
            boolean bl2 = false;
            PropertySpec[] propertySpecArray = querySpec.resourceSpec.propertySpecs;
            if (propertySpecArray != null) {
                for (PropertySpec propertySpec : propertySpecArray) {
                    if (propertySpec == null) continue;
                    PropertySpec propertySpec2 = this.replaceDerivedWithSourceProps(propertySpec, string, hashSet, set2);
                    if (propertySpec2 != null) {
                        bl = bl || string.equals(propertySpec2.type);
                        bl2 = true;
                    } else {
                        propertySpec2 = propertySpec;
                    }
                    arrayList.add(propertySpec2);
                }
            }
            if (!bl) {
                PropertySpec propertySpec = new PropertySpec();
                propertySpec.type = string;
                propertySpec.propertyNames = set2.toArray(new String[set2.size()]);
                arrayList.add(propertySpec);
                bl2 = true;
            }
            if (bl2) {
                QuerySpec querySpec2 = querySpec.clone();
                querySpec2.resourceSpec.propertySpecs = arrayList.toArray(new PropertySpec[arrayList.size()]);
                return querySpec2;
            }
            return null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            _logger.warn((Object)("Error has occurred while enriching QuerySpec: " + querySpec));
            return null;
        }
    }

    private PropertySpec replaceDerivedWithSourceProps(PropertySpec propertySpec, String string, Set<String> set, Set<String> set2) throws CloneNotSupportedException {
        assert (propertySpec != null);
        if (!this.canRepalceDerivedProperty(propertySpec, string)) {
            return null;
        }
        PropertySpec propertySpec2 = propertySpec.clone();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.addAll(Arrays.asList(propertySpec.propertyNames));
        linkedHashSet.removeAll(set);
        if (propertySpec.type != null) {
            linkedHashSet.addAll(set2);
        }
        propertySpec2.propertyNames = linkedHashSet.toArray(new String[linkedHashSet.size()]);
        return propertySpec2;
    }

    void collectDerivedPropertyData(Map<QuerySpec, ResultSetInfo> map, Map<QuerySpec, DerivedPropertyDataInternal> map2) {
        if (map == null || map.isEmpty() || map2 == null || map2.isEmpty()) {
            return;
        }
        for (QuerySpec querySpec : map.keySet()) {
            ResultSetInfo resultSetInfo;
            DerivedPropertyDataInternal derivedPropertyDataInternal = map2.get(querySpec);
            if (derivedPropertyDataInternal == null || (resultSetInfo = map.get(querySpec)) == null || resultSetInfo.getResultSet() == null) continue;
            this.collectSourcePropertyValues(resultSetInfo, derivedPropertyDataInternal);
        }
    }

    private void collectSourcePropertyValues(ResultSetInfo resultSetInfo, DerivedPropertyDataInternal derivedPropertyDataInternal) {
        Map<Object, Map<String, Object>> map = this.getSourcePropertyValues(resultSetInfo, derivedPropertyDataInternal.getSourcePropertyNamesByType());
        derivedPropertyDataInternal.addSourcePropertyValuesByObject(map);
    }

    private Map<Object, Map<String, Object>> getSourcePropertyValues(ResultSetInfo resultSetInfo, Map<String, List<String>> map) {
        Object[] objectArray = resultSetInfo.getResultSet().items;
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            return new HashMap<Object, Map<String, Object>>();
        }
        HashMap<Object, Map<String, Object>> hashMap = new HashMap<Object, Map<String, Object>>();
        for (Object object : objectArray) {
            Object object2 = ((ResultItem)object).resourceObject;
            String string = this._objectReferenceService.getResourceObjectType(object2);
            List<String> list = map.get(string);
            Object[] objectArray2 = ((ResultItem)object).properties;
            HashMap<String, Object> hashMap2 = (HashMap<String, Object>)hashMap.get(object2);
            if (hashMap2 == null) {
                hashMap2 = new HashMap<String, Object>();
            }
            if (!ArrayUtil.isNullOrEmpty(list) && !ArrayUtil.isNullOrEmpty((Object[])objectArray2)) {
                for (Object object3 : objectArray2) {
                    if (object3 == null || !list.contains(((PropertyValue)object3).propertyName)) continue;
                    hashMap2.put(((PropertyValue)object3).propertyName, ((PropertyValue)object3).value);
                }
            }
            hashMap.put(object2, hashMap2);
        }
        return hashMap;
    }

    private final Map<String, Set<String>> getSourceProperties(String string, Set<String> set) {
        Collection<PropertyProviderInfo> collection = this._dataAdapterRegistry.getDerivedPropertyProviders(string, set);
        if (collection.isEmpty()) {
            return new HashMap<String, Set<String>>(0);
        }
        IdentityHashSet identityHashSet = new IdentityHashSet();
        for (PropertyProviderInfo propertyProviderInfo : collection) {
            identityHashSet.add(propertyProviderInfo.propertyProvider);
        }
        return this.getSourcePropertiesFromPropertyAdapters((Set<PropertyProviderAdapter>)identityHashSet, string, set);
    }

    private final Map<String, Set<String>> getSourcePropertiesFromPropertyAdapters(Set<PropertyProviderAdapter> set, String string, Set<String> set2) {
        if (set2 == null || set2.size() == 0) {
            return new HashMap<String, Set<String>>();
        }
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        for (PropertyProviderAdapter propertyProviderAdapter : set) {
            Object[] objectArray = this._dataAdapterRegistry.getProvidedTypeInfos(propertyProviderAdapter);
            if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) continue;
            for (Object object : objectArray) {
                if (!string.equals(((TypeInfo)object).type) || ((TypeInfo)object).derivedProperties == null) continue;
                for (DerivedPropertyInfo derivedPropertyInfo : ((TypeInfo)object).derivedProperties) {
                    if (!set2.contains(derivedPropertyInfo.propertyName)) continue;
                    HashSet<String> hashSet = (HashSet<String>)hashMap.get(derivedPropertyInfo.propertyName);
                    if (hashSet == null) {
                        hashSet = new HashSet<String>();
                        hashMap.put(derivedPropertyInfo.propertyName, hashSet);
                    }
                    for (String string2 : derivedPropertyInfo.sourcePropertyNames) {
                        hashSet.add(string2);
                    }
                }
            }
        }
        return hashMap;
    }

    private final Set<String> mergeSourceProperties(Map<String, Set<String>> map) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Set<String> set : map.values()) {
            hashSet.addAll(set);
        }
        return hashSet;
    }

    private boolean canRepalceDerivedProperty(PropertySpec propertySpec, String string) {
        return StringUtil.isNullOrEmpty((String)propertySpec.relation) && (propertySpec.type == null || string.equals(propertySpec.type)) && !ArrayUtil.isNullOrEmpty((Object[])propertySpec.propertyNames);
    }
}

