/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.query.DataServiceException;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.internal.profiling.MdcAwareExecutorService;
import com.vmware.vise.data.query.util.Config;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.concurrent.ExecutorUtil;
import com.vmware.vise.util.concurrent.ThreadPoolFactory;
import com.vmware.vise.util.concurrent.ThreadPoolProfiler;
import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class ProfiledTaskExecutor {
    private static final String DS_THREAD_POOL_NAME = "data-service-pool";
    private final ExecutorService _executor;
    private final ThreadPoolProfiler _threadPoolProfiler;
    private final long _timeoutInMillis;

    ProfiledTaskExecutor(long l) {
        long l2 = 50L;
        ThreadPoolExecutor threadPoolExecutor = ThreadPoolFactory.newIdleThreadsAwareThreadPool((String)DS_THREAD_POOL_NAME, (int)Config.THREAD_POOL_CORE_SIZE, (int)Config.THREAD_POOL_MAXIMUM_SIZE, (int)Config.THREAD_POOL_QUEUE_CAPACITY, (ThreadFactory)new WorkerThreadFactory(DS_THREAD_POOL_NAME), (long)l2, (TimeUnit)TimeUnit.MILLISECONDS);
        this._threadPoolProfiler = new ThreadPoolProfiler(threadPoolExecutor);
        this._executor = new MdcAwareExecutorService(threadPoolExecutor);
        this._timeoutInMillis = l;
    }

    <T> List<ExecutorUtil.TaskResult<T>> executeTasks(List<Callable<T>> list) throws InterruptedException {
        ValidationUtil.paramsNotNull((Object[])new Object[]{list});
        this._threadPoolProfiler.profileThreadPoolIfBusy();
        try {
            List list2 = ExecutorUtil.executeTasks(list, (Executor)this._executor, (long)this._timeoutInMillis, (TimeUnit)TimeUnit.MILLISECONDS, (boolean)true, (boolean)true, (boolean)false);
            return list2;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            throw new DataServiceException("The Data Service thread pool 'data-service-pool' rejected a task.", rejectedExecutionException);
        }
        catch (TimeoutException timeoutException) {
            String string = String.format(Utils.getLocalizedString("error.dataServiceTimeout"), this.getTaskTimeoutInSecs());
            throw new DataServiceException(string, timeoutException);
        }
    }

    long getTaskTimeoutInSecs() {
        return this._timeoutInMillis / 1000L;
    }

    void shutdown() {
        this._executor.shutdown();
    }
}

