/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.impl.BatchedQueryReducer;
import com.vmware.vise.data.query.impl.ResultSetInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class QueryBatchReducer
implements BatchedQueryReducer {
    private static final Log _logger = LogFactory.getLog(QueryBatchReducer.class);
    private Map<QuerySpec, List<QuerySpec>> _skippedQueriesByRepresentativeQuery;

    @Override
    public QuerySpec[] reduceBatch(QuerySpec[] querySpecArray) {
        if (querySpecArray == null || querySpecArray.length <= 1) {
            return querySpecArray;
        }
        this._skippedQueriesByRepresentativeQuery = null;
        ArrayList<QuerySpec> arrayList = new ArrayList<QuerySpec>(querySpecArray.length);
        for (QuerySpec querySpec : querySpecArray) {
            boolean bl = false;
            for (QuerySpec querySpec2 : arrayList) {
                List<QuerySpec> list;
                if (!QueryUtil.areEquivalent(querySpec2, querySpec)) continue;
                _logger.debug((Object)("Skipping QuerySpec: " + querySpec.name));
                if (this._skippedQueriesByRepresentativeQuery == null) {
                    this._skippedQueriesByRepresentativeQuery = new HashMap<QuerySpec, List<QuerySpec>>();
                }
                if ((list = this._skippedQueriesByRepresentativeQuery.get(querySpec2)) == null) {
                    list = new ArrayList<QuerySpec>();
                    this._skippedQueriesByRepresentativeQuery.put(querySpec2, list);
                }
                list.add(querySpec);
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(querySpec);
        }
        if (_logger.isInfoEnabled() && arrayList.size() < querySpecArray.length) {
            _logger.info((Object)("Reduced query batch from " + querySpecArray.length + " to " + arrayList.size()));
        }
        return arrayList.toArray(new QuerySpec[arrayList.size()]);
    }

    @Override
    public Map<QuerySpec, ResultSetInfo> getResultsByOriginalQuery(Map<QuerySpec, ResultSetInfo> map) {
        if (this._skippedQueriesByRepresentativeQuery == null) {
            return map;
        }
        HashMap<QuerySpec, ResultSetInfo> hashMap = new HashMap<QuerySpec, ResultSetInfo>();
        for (Map.Entry<QuerySpec, ResultSetInfo> entry : map.entrySet()) {
            QuerySpec querySpec = entry.getKey();
            ResultSetInfo resultSetInfo = entry.getValue();
            hashMap.put(querySpec, resultSetInfo);
            List<QuerySpec> list = this._skippedQueriesByRepresentativeQuery.get(querySpec);
            if (list == null) continue;
            for (QuerySpec querySpec2 : list) {
                ResultSetInfo resultSetInfo2 = QueryBatchReducer.toOriginalResult(querySpec2, resultSetInfo);
                hashMap.put(querySpec2, resultSetInfo2);
            }
        }
        return hashMap;
    }

    private static ResultSetInfo toOriginalResult(QuerySpec querySpec, ResultSetInfo resultSetInfo) {
        ResultSet resultSet = new ResultSet(resultSetInfo.getResultSet());
        resultSet.queryName = querySpec.name;
        ResultSetInfo resultSetInfo2 = ResultSetInfo.getResultSetInfo(resultSetInfo, resultSet);
        return resultSetInfo2;
    }
}

