/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.impl.ResultSetInfo;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.metadata.impl.MetadataServiceRegistryInternal;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class ResultDirectory {
    private static final Log _logger = LogFactory.getLog(ResultDirectory.class);
    private final Map<String, Set<String>> _remainingPropertiesByType = new HashMap<String, Set<String>>();
    private final Map<String, Set<ParameterSpec>> _parameters = new HashMap<String, Set<ParameterSpec>>();
    private final Map<String, Set<Object>> _objectsPerType = new HashMap<String, Set<Object>>();
    private final MetadataServiceRegistryInternal _metadataServiceRegistry;

    ResultDirectory(MetadataServiceRegistryInternal metadataServiceRegistryInternal, QuerySpec querySpec, ResultSetInfo resultSetInfo) {
        assert (querySpec != null && querySpec.resourceSpec != null);
        assert (resultSetInfo != null);
        this._metadataServiceRegistry = metadataServiceRegistryInternal;
        Map<String, List<ResultItem>> map = ResultDirectory.groupResultItemsPerType(resultSetInfo);
        this.computeObjectsSet(querySpec, map);
        this.computeRemainingProperties(querySpec, map);
    }

    boolean hasRemainingProperties() {
        if (this._remainingPropertiesByType.isEmpty()) {
            return false;
        }
        for (Set<String> set : this._remainingPropertiesByType.values()) {
            if (set == null || set.isEmpty()) continue;
            return true;
        }
        return false;
    }

    Set<String> getRemainingPropertiesFor(String string) {
        assert (!StringUtil.isNullOrEmpty((String)string));
        Set<String> set = this._remainingPropertiesByType.get(string);
        if (set == null) {
            return new HashSet<String>(0);
        }
        return set;
    }

    Set<ParameterSpec> getParametersFor(Set<String> set) {
        HashSet<ParameterSpec> hashSet = new HashSet<ParameterSpec>();
        for (String string : set) {
            Set<ParameterSpec> set2 = this._parameters.get(string);
            if (set2 == null) continue;
            hashSet.addAll(set2);
        }
        return hashSet;
    }

    Map<String, Set<Object>> getEnumeratedObjects() {
        return this._objectsPerType;
    }

    /*
     * WARNING - void declaration
     */
    private void computeObjectsSet(QuerySpec querySpec, Map<String, List<ResultItem>> map) {
        Object[] objectArray;
        boolean bl = true;
        for (String object2 : map.keySet()) {
            objectArray = map.get(object2);
            for (ResultItem resultItem : objectArray) {
                ResultDirectory.addObjectRef(this._objectsPerType, resultItem.resourceObject);
                bl = false;
            }
        }
        boolean bl2 = false;
        if (querySpec.resultSpec != null) {
            Integer n = querySpec.resultSpec.maxResultCount;
            boolean bl3 = bl2 = n != null && n >= 0;
        }
        if (!bl2 || bl) {
            void var8_15;
            Object[] objectArray2;
            objectArray = objectArray2 = Utils.getEnumeratedObjects(querySpec);
            int n = objectArray.length;
            boolean bl4 = false;
            while (var8_15 < n) {
                Object object = objectArray[var8_15];
                ResultDirectory.addObjectRef(this._objectsPerType, object);
                ++var8_15;
            }
        }
    }

    private static void addObjectRef(Map<String, Set<Object>> map, Object object) {
        String string = QueryUtil.getReferenceType(object);
        if (string == null) {
            _logger.warn((Object)String.format("Type cannot be resolved for %1$s", object.toString()));
            return;
        }
        Set<Object> set = map.get(string);
        if (set == null) {
            set = new HashSet<Object>();
            map.put(string, set);
        }
        set.add(object);
    }

    private void computeRemainingProperties(QuerySpec querySpec, Map<String, List<ResultItem>> map) {
        List<ResultItemsByTypeInfo> list = this.getTypeResultInfos(map);
        for (PropertySpec propertySpec : querySpec.resourceSpec.propertySpecs) {
            if (!StringUtil.isNullOrEmpty((String)propertySpec.relation)) continue;
            if (StringUtil.isNullOrEmpty((String)propertySpec.type) || propertySpec.type.equals("*")) {
                Set<String> set = this._objectsPerType.keySet();
                this.addRemainingPropertiesForAllTypes(list, set, propertySpec);
            } else {
                this.addRemainingProperties(list, propertySpec.type, propertySpec);
            }
            this.addParameters(propertySpec);
        }
    }

    private List<ResultItemsByTypeInfo> getTypeResultInfos(Map<String, List<ResultItem>> map) {
        ArrayList<ResultItemsByTypeInfo> arrayList = new ArrayList<ResultItemsByTypeInfo>();
        for (String string : map.keySet()) {
            String[] stringArray = this._metadataServiceRegistry.getSupertypes(string);
            List<ResultItem> list = map.get(string);
            ResultItemsByTypeInfo resultItemsByTypeInfo = new ResultItemsByTypeInfo(list, string, stringArray);
            arrayList.add(resultItemsByTypeInfo);
        }
        return arrayList;
    }

    private void addRemainingPropertiesForAllTypes(List<ResultItemsByTypeInfo> list, Set<String> set, PropertySpec propertySpec) {
        for (String string : set) {
            this.addRemainingProperties(list, string, propertySpec);
        }
    }

    private void addRemainingPropertiesByType(String string, Set<String> set) {
        Set<String> set2 = this._remainingPropertiesByType.get(string);
        if (set2 == null) {
            set2 = new HashSet<String>();
            this._remainingPropertiesByType.put(string, set2);
        }
        set2.addAll(set);
    }

    private void addRemainingProperties(List<ResultItemsByTypeInfo> list, String string, PropertySpec propertySpec) {
        List<ResultItemsByTypeInfo> list2 = this.filterByType(string, list);
        if (ArrayUtil.isNullOrEmpty(list2)) {
            this.addAllRemainingProperties(string, propertySpec);
            return;
        }
        for (ResultItemsByTypeInfo resultItemsByTypeInfo : list2) {
            List<ResultItem> list3 = resultItemsByTypeInfo.getResultItems();
            String string2 = resultItemsByTypeInfo.getType();
            if (ArrayUtil.isNullOrEmpty(list3)) {
                this.addAllRemainingProperties(string2, propertySpec);
                continue;
            }
            Set<String> set = ResultDirectory.getRemainingProperties(propertySpec.propertyNames, list3);
            this.addRemainingPropertiesByType(string2, set);
        }
    }

    private void addAllRemainingProperties(String string, PropertySpec propertySpec) {
        Set<Object> set = this._objectsPerType.get(string);
        if (set != null && !set.isEmpty()) {
            Set<String> set2 = ResultDirectory.getProperties(propertySpec.propertyNames);
            this.addRemainingPropertiesByType(string, set2);
        }
    }

    private void addParameters(PropertySpec propertySpec) {
        if (propertySpec.parameters == null) {
            return;
        }
        for (ParameterSpec parameterSpec : propertySpec.parameters) {
            Set<ParameterSpec> set = this._parameters.get(parameterSpec.propertyName);
            if (set == null) {
                set = new HashSet<ParameterSpec>();
                this._parameters.put(parameterSpec.propertyName, set);
            }
            set.add(parameterSpec);
        }
    }

    private List<ResultItemsByTypeInfo> filterByType(String string, List<ResultItemsByTypeInfo> list) {
        ArrayList<ResultItemsByTypeInfo> arrayList = new ArrayList<ResultItemsByTypeInfo>();
        for (ResultItemsByTypeInfo resultItemsByTypeInfo : list) {
            if (!resultItemsByTypeInfo.ofType(string)) continue;
            arrayList.add(resultItemsByTypeInfo);
        }
        return arrayList;
    }

    private static Set<String> getRemainingProperties(String[] stringArray, List<ResultItem> list) {
        HashSet<String> hashSet = new HashSet<String>();
        if (stringArray == null) {
            hashSet.add("*");
        } else {
            for (ResultItem resultItem : list) {
                for (String string : stringArray) {
                    PropertyValue propertyValue = ResultUtil.getPropertyValue(resultItem, string);
                    if (propertyValue != null) continue;
                    hashSet.add(string);
                }
            }
        }
        return hashSet;
    }

    private static Set<String> getProperties(String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : stringArray) {
            hashSet.add(string);
        }
        return hashSet;
    }

    private static Map<String, List<ResultItem>> groupResultItemsPerType(ResultSetInfo resultSetInfo) {
        HashMap<String, List<ResultItem>> hashMap = new HashMap<String, List<ResultItem>>();
        for (ResultItem resultItem : resultSetInfo.getResultSet().items) {
            Object object = resultItem.resourceObject;
            String string = QueryUtil.getReferenceType(object);
            ArrayList<ResultItem> arrayList = (ArrayList<ResultItem>)hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<ResultItem>();
                hashMap.put(string, arrayList);
            }
            arrayList.add(resultItem);
        }
        return hashMap;
    }

    private static class ResultItemsByTypeInfo {
        private final String _type;
        private final Set<String> _superTypes = new HashSet<String>();
        private final List<ResultItem> _resultItems;

        public ResultItemsByTypeInfo(List<ResultItem> list, String string, String[] stringArray) {
            this._resultItems = list;
            this._type = string;
            if (stringArray != null) {
                for (String string2 : stringArray) {
                    this._superTypes.add(string2);
                }
            }
        }

        public boolean ofType(String string) {
            if (string == null) {
                return false;
            }
            if (string.equals(this._type)) {
                return true;
            }
            return this._superTypes.contains(string);
        }

        public String getType() {
            return this._type;
        }

        public List<ResultItem> getResultItems() {
            return this._resultItems;
        }
    }
}

