/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.query.OrderingCriteria;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.impl.ResultSetInfo;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.util.ItemUidComparator;
import com.vmware.vise.data.query.util.ResultItemComparator;
import com.vmware.vise.data.query.util.ResultUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class ResultsManager {
    private static Log _logger = LogFactory.getLog(ResultsManager.class);

    private ResultsManager() {
    }

    static Map<QuerySpec, ResultSetInfo> applyResultSpecsToResults(Map<QuerySpec, ResultSetInfo> map, Set<QuerySpec> set) {
        ResultsManager.sortResults(map, set);
        ResultsManager.pageResults(map, set);
        return map;
    }

    static ResultSet[] orderResultsPerQueryOrder(QuerySpec[] querySpecArray, Map<QuerySpec, ResultSetInfo> map) {
        if (querySpecArray == null || querySpecArray.length == 0 || map == null || map.size() == 0) {
            ResultSet resultSet = new ResultSet();
            resultSet.error = new Exception(Utils.getLocalizedString("error.invalidResult"));
            return new ResultSet[]{resultSet};
        }
        ArrayList<ResultSet> arrayList = new ArrayList<ResultSet>();
        for (QuerySpec querySpec : querySpecArray) {
            ResultSetInfo resultSetInfo = map.get(querySpec);
            ResultSet resultSet = null;
            if (resultSetInfo == null) {
                _logger.warn((Object)("No matching result set found for query - " + querySpec.name));
                resultSet = new ResultSet();
                resultSet.queryName = querySpec.name;
                resultSet.items = new ResultItem[0];
                resultSet.totalMatchedObjectCount = 0;
            } else {
                resultSet = resultSetInfo.getResultSet();
            }
            arrayList.add(resultSet);
        }
        return arrayList.toArray(new ResultSet[arrayList.size()]);
    }

    private static void sortResults(Map<QuerySpec, ResultSetInfo> map, Set<QuerySpec> set) {
        assert (map != null);
        for (QuerySpec querySpec : map.keySet()) {
            ResultSetInfo resultSetInfo = map.get(querySpec);
            if (resultSetInfo.isSorted()) {
                return;
            }
            ResultSetInfo resultSetInfo2 = ResultsManager.getSortedResult(querySpec, resultSetInfo, set.contains(querySpec));
            map.put(querySpec, resultSetInfo2);
        }
    }

    private static ResultSetInfo getSortedResult(QuerySpec querySpec, ResultSetInfo resultSetInfo, boolean bl) {
        assert (querySpec != null);
        ResultSpec resultSpec = querySpec.resultSpec;
        if (resultSpec == null) {
            return resultSetInfo;
        }
        if (resultSpec == null || resultSpec.order == null || resultSpec.order == Utils.DEFAULT_ORDERING_CRITERIA) {
            ResultSetInfo resultSetInfo2 = ResultsManager.sortByItemUid(resultSetInfo);
            return resultSetInfo2;
        }
        ResultSetInfo resultSetInfo3 = ResultsManager.sortBySpec(resultSetInfo, resultSpec.order, bl);
        return resultSetInfo3;
    }

    private static ResultSetInfo sortBySpec(ResultSetInfo resultSetInfo, OrderingCriteria orderingCriteria, boolean bl) {
        assert (resultSetInfo != null);
        assert (orderingCriteria != null);
        Arrays.sort(resultSetInfo.getResultSet().items, new ResultItemComparator(orderingCriteria));
        ResultSetInfo resultSetInfo2 = ResultSetInfo.getResultSetInfo(resultSetInfo.getResultSet(), !bl, bl ? false : resultSetInfo.isPaged());
        return resultSetInfo2;
    }

    private static ResultSetInfo sortByItemUid(ResultSetInfo resultSetInfo) {
        assert (resultSetInfo != null);
        Arrays.sort(resultSetInfo.getResultSet().items, new ItemUidComparator());
        ResultSetInfo resultSetInfo2 = ResultSetInfo.getResultSetInfo(resultSetInfo.getResultSet(), true, resultSetInfo.isPaged());
        return resultSetInfo2;
    }

    private static void pageResults(Map<QuerySpec, ResultSetInfo> map, Set<QuerySpec> set) {
        for (QuerySpec querySpec : map.keySet()) {
            boolean bl;
            if (set.contains(querySpec)) continue;
            ResultSpec resultSpec = querySpec.resultSpec;
            ResultSetInfo resultSetInfo = map.get(querySpec);
            if (!resultSetInfo.isSorted() && ResultsManager.isOffsetSpecified(resultSpec)) {
                _logger.warn((Object)"Result could not be paged because it is unsorted and the resultSpec specifies an offset greater than zero.");
                continue;
            }
            if (resultSetInfo.isPaged() || !(bl = ResultUtil.pageResult(resultSetInfo.getResultSet(), resultSpec))) continue;
            ResultSetInfo resultSetInfo2 = ResultSetInfo.getResultSetInfo(resultSetInfo.getResultSet(), resultSetInfo.isSorted(), true);
            map.put(querySpec, resultSetInfo2);
        }
    }

    private static boolean isOffsetSpecified(ResultSpec resultSpec) {
        return resultSpec != null && resultSpec.offset != null && resultSpec.offset > 0;
    }
}

