/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.common.MappingUtil;
import com.vmware.vise.data.common.PathTemplate;
import com.vmware.vise.data.common.UnsupportedPropertyException;
import com.vmware.vise.data.query.DataException;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.Config;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServicePropertyProviderAdapter
implements PropertyProviderAdapter {
    private PropertyProviderBean _providerInstance;
    private Map<String, ArrayList<String>> _propertyByType;
    private Map<String, Method> _methodByGeneratedPropertyName;
    private Map<Pair<String, String>, Method> _methodByTypePropertyPair;
    private static final Log _logger = LogFactory.getLog(ServicePropertyProviderAdapter.class);

    public ServicePropertyProviderAdapter(PropertyProviderBean propertyProviderBean) {
        this._providerInstance = propertyProviderBean;
        this._propertyByType = new HashMap<String, ArrayList<String>>();
        this._methodByGeneratedPropertyName = new HashMap<String, Method>();
        this._methodByTypePropertyPair = new HashMap<Pair<String, String>, Method>();
        this.processProvider();
    }

    public TypeInfo[] getProvidedTypeInfos() {
        if (this._propertyByType.size() == 0) {
            return null;
        }
        ArrayList<TypeInfo> arrayList = new ArrayList<TypeInfo>();
        for (Map.Entry<String, ArrayList<String>> entry : this._propertyByType.entrySet()) {
            TypeInfo typeInfo = new TypeInfo();
            typeInfo.type = entry.getKey();
            typeInfo.properties = entry.getValue().toArray(new String[0]);
            arrayList.add(typeInfo);
        }
        return arrayList.toArray(new TypeInfo[0]);
    }

    @Override
    public ResultSet getProperties(PropertyRequestSpec propertyRequestSpec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequestSpec});
        Object[] objectArray = propertyRequestSpec.objects;
        PropertySpec[] propertySpecArray = propertyRequestSpec.properties;
        if (objectArray == null || objectArray.length == 0 || propertySpecArray == null || propertySpecArray.length == 0) {
            return null;
        }
        ResultSet resultSet = new ResultSet();
        ArrayList<DataException> arrayList = new ArrayList<DataException>();
        ArrayList<ResultItem> arrayList2 = new ArrayList<ResultItem>();
        for (PropertySpec propertySpec : propertySpecArray) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (propertySpec.parameters != null) {
                for (ParameterSpec parameterSpec : propertySpec.parameters) {
                    hashMap.put(parameterSpec.propertyName, parameterSpec);
                }
            }
            for (Object object : objectArray) {
                ResultItem resultItem = new ResultItem();
                resultItem.resourceObject = object;
                arrayList2.add(resultItem);
                ArrayList<PropertyValue> arrayList3 = new ArrayList<PropertyValue>();
                for (String string : propertySpec.propertyNames) {
                    HashMap<String, Object> hashMap2 = null;
                    Method method = this._methodByGeneratedPropertyName.get(string);
                    if (method == null) {
                        hashMap2 = new HashMap<String, Object>();
                        method = this.getPropertyAccessor(object, string, hashMap2);
                    }
                    if (method == null) continue;
                    try {
                        PropertyValue propertyValue = this.invokeMethod(method, string, object, (ParameterSpec)hashMap.get(string), hashMap2);
                        arrayList3.add(propertyValue);
                    }
                    catch (Exception exception) {
                        if (exception.getCause() instanceof UnsupportedPropertyException) continue;
                        Throwable throwable = exception;
                        if (exception instanceof InvocationTargetException) {
                            throwable = ((InvocationTargetException)exception).getCause();
                        }
                        String string2 = String.format("Error when fetching property {%1s} from property provider {%2s}", string, this._providerInstance.getClass().toString());
                        _logger.error((Object)string2, throwable);
                        DataException dataException = DataException.newInstance(throwable, object, string);
                        arrayList.add(dataException);
                    }
                }
                if (arrayList3.size() == 0) continue;
                resultItem.properties = arrayList3.toArray(new PropertyValue[0]);
            }
        }
        resultSet.items = arrayList2.toArray(new ResultItem[0]);
        if (arrayList.size() > 0) {
            List<DataException> list = ResultUtil.mergeDuplicates(arrayList);
            resultSet.error = list.size() > 1 ? new CompositeException((Collection)list) : (Exception)list.get(0);
        }
        return resultSet;
    }

    public PropertyProviderBean getPropertyProvider() {
        return this._providerInstance;
    }

    private static String getPropertyAccessorParam(String string, String string2) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            return string2;
        }
        if (StringUtil.isNullOrEmpty((String)string2)) {
            return string;
        }
        if (PathTemplate.matches(string, string2)) {
            return string2;
        }
        return null;
    }

    private static String[] getPropertyAccessorTypes(String[] stringArray, String[] stringArray2) {
        if (ArrayUtil.isNullOrEmpty((Object[])stringArray)) {
            return stringArray2;
        }
        if (ArrayUtil.isNullOrEmpty((Object[])stringArray2)) {
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray2.length);
        block0: for (String string : stringArray2) {
            for (String string2 : stringArray) {
                if (!string2.equals(string)) continue;
                arrayList.add(string);
                continue block0;
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private Method getPropertyAccessor(Object object, String string, Map<String, Object> map) {
        String string2 = QueryUtil.getReferenceType(object);
        for (Pair<String, String> pair : this._methodByTypePropertyPair.keySet()) {
            if (!MappingUtil.matchesMapping((String)pair.first, (String)pair.second, string2, string, map)) continue;
            Method method = this._methodByTypePropertyPair.get(pair);
            return method;
        }
        return null;
    }

    private PropertyValue invokeMethod(Method method, String string, Object object, ParameterSpec parameterSpec, Map<String, Object> map) throws Exception {
        if (method == null || object == null) {
            return null;
        }
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.propertyName = string;
        propertyValue.resourceObject = object;
        Object object2 = null;
        if (parameterSpec != null) {
            object2 = parameterSpec.parameter;
        }
        Object[] objectArray = MappingUtil.resolveArgs(method, new Object[]{object, object2}, map);
        long l = System.currentTimeMillis();
        Exception exception = null;
        try {
            propertyValue.value = method.invoke((Object)this._providerInstance, objectArray);
        }
        catch (Exception exception2) {
            try {
                exception = exception2;
                throw exception2;
            }
            catch (Throwable throwable) {
                long l2 = System.currentTimeMillis() - l;
                if (l2 > Config.PROPERTY_PROVIDER_BEAN_METHOD_TIME_THRESHOLD && _logger.isWarnEnabled()) {
                    _logger.warn((Object)("A PropertyProviderBean method's execution took too long: " + l2 + " milliseconds." + (exception != null ? " The method failed with an exception: " + exception.getMessage() : "") + " (Provider instance: " + this._providerInstance + ", method: " + method + ", property: " + "ref: " + object + ", method args: " + Arrays.toString(objectArray) + ")"));
                }
                throw throwable;
            }
        }
        long l3 = System.currentTimeMillis() - l;
        if (l3 > Config.PROPERTY_PROVIDER_BEAN_METHOD_TIME_THRESHOLD && _logger.isWarnEnabled()) {
            _logger.warn((Object)("A PropertyProviderBean method's execution took too long: " + l3 + " milliseconds." + (exception != null ? " The method failed with an exception: " + exception.getMessage() : "") + " (Provider instance: " + this._providerInstance + ", method: " + method + ", property: " + "ref: " + object + ", method args: " + Arrays.toString(objectArray) + ")"));
        }
        return propertyValue;
    }

    private void processProvider() {
        Method[] methodArray;
        if (this._providerInstance == null) {
            return;
        }
        Class<?> clazz = this._providerInstance.getClass();
        ModelMetadata modelMetadata = clazz.getAnnotation(ModelMetadata.class);
        for (Method method : methodArray = clazz.getDeclaredMethods()) {
            this.processPropertyAccessor(method, modelMetadata);
            this.processGetMethod(method);
        }
    }

    private void processGetMethod(Method method) {
        Annotation[] annotationArray;
        String string = Utils.getPropertyName(method);
        if (StringUtil.isNullOrEmpty((String)string)) {
            return;
        }
        boolean bl = false;
        for (Annotation annotation : annotationArray = method.getAnnotations()) {
            if (!type.class.isInstance(annotation)) continue;
            bl = true;
            this.populateTypeToPropertyMapping((type)annotation, string);
            break;
        }
        if (bl) {
            this.applyWorkaroundForJavaBug4071957(method);
            this._methodByGeneratedPropertyName.put(string, method);
        }
    }

    private void processPropertyAccessor(Method method, ModelMetadata modelMetadata) {
        String string = Utils.getPropertyName(method);
        if (StringUtil.isNullOrEmpty((String)string)) {
            return;
        }
        ModelMetadata modelMetadata2 = method.getAnnotation(ModelMetadata.class);
        String[] stringArray = null;
        String string2 = null;
        if (modelMetadata2 != null) {
            if (!StringUtil.isNullOrEmpty((String)modelMetadata2.property())) {
                string = modelMetadata2.property();
            }
            stringArray = modelMetadata2.type();
            string2 = modelMetadata2.propertyNamespace();
        }
        if (modelMetadata != null) {
            string = ServicePropertyProviderAdapter.getPropertyAccessorParam(modelMetadata.property(), string);
            string2 = ServicePropertyProviderAdapter.getPropertyAccessorParam(modelMetadata.propertyNamespace(), string2);
            stringArray = ServicePropertyProviderAdapter.getPropertyAccessorTypes(modelMetadata.type(), stringArray);
        }
        if (ArrayUtil.isNullOrEmpty(stringArray) || StringUtil.isNullOrEmpty((String)string)) {
            return;
        }
        string = Utils.getNamespacedProperty(string, string2);
        for (String string3 : stringArray) {
            this.applyWorkaroundForJavaBug4071957(method);
            this._methodByTypePropertyPair.put((Pair<String, String>)new Pair((Object)string3, (Object)string, true), method);
            this.populateTypeToPropertyMapping(string3, string);
        }
    }

    private void applyWorkaroundForJavaBug4071957(Method method) {
        if (Modifier.isPublic(method.getModifiers())) {
            method.setAccessible(true);
        }
    }

    private void populateTypeToPropertyMapping(type type2, String string) {
        String[] stringArray;
        for (String string2 : stringArray = type2.value().split(",")) {
            string2 = string2.trim();
            this.populateTypeToPropertyMapping(string2, string);
        }
    }

    private void populateTypeToPropertyMapping(String string, String string2) {
        ArrayList<String> arrayList = this._propertyByType.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this._propertyByType.put(string, arrayList);
        }
        arrayList.add(string2);
    }

    public String toString() {
        return super.toString() + "(" + this._providerInstance.getClass().getName() + ")";
    }
}

