/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.internal.profiling;

import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.util.OpIdUtil;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.MDC;

public final class ViseDsLogConfigurator {
    private static final String BATCH_INVOCATION_ID_KEY = "viseBatch";
    private static final String PROVIDER_INVOCATION_ID_KEY = "viseProvider";
    private static final AtomicLong BATCH_INVOCATION_ID_GENERATOR = new AtomicLong(0L);
    private static final AtomicLong PROVIDER_INVOCATION_ID_GENERATOR = new AtomicLong(0L);

    public static ViseDsLogContext onBatchStart() {
        final String string = ViseDsLogConfigurator.getBatchInvocation();
        final String string2 = ViseDsLogConfigurator.nextBatchInvocation();
        ViseDsLogConfigurator.setBatchInvocation(string2);
        return new ViseDsLogContext(){

            @Override
            public void close() {
                ViseDsLogConfigurator.setBatchInvocation(string);
            }

            @Override
            public String getInvocationId() {
                return string2;
            }
        };
    }

    public static ViseDsLogContext onDataAdapterStart(DataProviderAdapter dataProviderAdapter) {
        assert (dataProviderAdapter != null);
        return ViseDsLogConfigurator.onProviderInvocation(dataProviderAdapter.getClass().getSimpleName());
    }

    public static ViseDsLogContext onPropertyProviderStart(PropertyProviderAdapter propertyProviderAdapter) {
        assert (propertyProviderAdapter != null);
        String string = Utils.renderPropertyProvider(propertyProviderAdapter, false);
        return ViseDsLogConfigurator.onProviderInvocation(string);
    }

    private static ViseDsLogContext onProviderInvocation(String string) {
        final String string2 = OpIdUtil.getCustomOpIdPrefix();
        final String string3 = ViseDsLogConfigurator.getProviderInvocation();
        final String string4 = ViseDsLogConfigurator.nextProviderInvocation(string);
        OpIdUtil.setCustomOpIdPrefix((String)string4);
        ViseDsLogConfigurator.setProviderInvocation(string4);
        return new ViseDsLogContext(){

            @Override
            public void close() {
                OpIdUtil.setCustomOpIdPrefix((String)string2);
                ViseDsLogConfigurator.setProviderInvocation(string3);
            }

            @Override
            public String getInvocationId() {
                return string4;
            }
        };
    }

    private static void setBatchInvocation(String string) {
        MDC.put((String)BATCH_INVOCATION_ID_KEY, (String)string);
    }

    public static String getBatchInvocation() {
        return MDC.get((String)BATCH_INVOCATION_ID_KEY);
    }

    private static void setProviderInvocation(String string) {
        MDC.put((String)PROVIDER_INVOCATION_ID_KEY, (String)string);
    }

    public static String getProviderInvocation() {
        return MDC.get((String)PROVIDER_INVOCATION_ID_KEY);
    }

    private static String nextBatchInvocation() {
        String string = Long.toString(BATCH_INVOCATION_ID_GENERATOR.incrementAndGet());
        return string;
    }

    private static String nextProviderInvocation(String string) {
        String string2 = Long.toString(PROVIDER_INVOCATION_ID_GENERATOR.incrementAndGet());
        return string + ":" + string2;
    }

    public static interface ViseDsLogContext
    extends AutoCloseable {
        public String getInvocationId();

        @Override
        public void close();
    }
}

