/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.transform.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.transform.Transformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FormattingPropertyConstraintTransformer
implements Transformer<Constraint, Constraint> {
    private static final Log _logger = LogFactory.getLog(FormattingPropertyConstraintTransformer.class);

    @Override
    public Transformer.Result<Constraint> transform(Constraint constraint) {
        if (!(constraint instanceof PropertyConstraint)) {
            return new Transformer.Result<Constraint>(constraint);
        }
        PropertyConstraint propertyConstraint = (PropertyConstraint)constraint;
        String string = propertyConstraint.propertyName;
        if (string == null) {
            _logger.error((Object)"The 'propertyName' of the PropertyConstraint is null");
            return new Transformer.Result<Constraint>(constraint);
        }
        boolean bl = false;
        if (string.contains(".@formatted")) {
            string = Utils.getStringBeforeSubStr(string, ".@formatted");
            bl = true;
        }
        PropertyConstraint propertyConstraint2 = propertyConstraint;
        if (bl) {
            propertyConstraint2 = new PropertyConstraint();
            propertyConstraint2.comparableValue = propertyConstraint.comparableValue;
            propertyConstraint2.comparator = propertyConstraint.comparator;
            propertyConstraint2.targetType = propertyConstraint.targetType;
            propertyConstraint2.propertyName = string;
        }
        return new Transformer.Result<Constraint>(propertyConstraint2, bl);
    }
}

