/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.transform.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.transform.Transformer;
import java.util.ArrayList;
import java.util.HashMap;

public final class NormalizeConstraintTransformer
implements Transformer<Constraint, Constraint> {
    @Override
    public Transformer.Result<Constraint> transform(Constraint constraint) {
        if (!(constraint instanceof CompositeConstraint)) {
            return new Transformer.Result<Constraint>(constraint);
        }
        CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
        boolean bl = this.removeDuplicateChildren(compositeConstraint);
        return new Transformer.Result<Constraint>(compositeConstraint, bl, null);
    }

    private boolean removeDuplicateChildren(CompositeConstraint compositeConstraint) {
        Constraint[] constraintArray = compositeConstraint.nestedConstraints;
        HashMap<Object, ObjectIdentityConstraint> hashMap = new HashMap<Object, ObjectIdentityConstraint>();
        ArrayList<Constraint> arrayList = new ArrayList<Constraint>(constraintArray.length);
        for (Constraint constraint : constraintArray) {
            if (constraint instanceof ObjectIdentityConstraint) {
                ObjectIdentityConstraint objectIdentityConstraint = (ObjectIdentityConstraint)constraint;
                hashMap.put(objectIdentityConstraint.target, objectIdentityConstraint);
                continue;
            }
            arrayList.add(constraint);
        }
        arrayList.addAll(hashMap.values());
        boolean bl = false;
        if (arrayList.size() != constraintArray.length) {
            bl = true;
            Constraint[] constraintArray2 = arrayList.toArray(new Constraint[arrayList.size()]);
            compositeConstraint.nestedConstraints = constraintArray2;
        }
        return bl;
    }
}

