/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.util;

import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.data.query.DataException;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.util.ResultItemComparator;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.Merger;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.collection.CollectionUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ResultUtil {
    private static final Log _logger = LogFactory.getLog(ResultUtil.class);
    private static final ResultItem[] EMPTY_RESULT_ITEMS = new ResultItem[0];

    public static boolean pageResult(ResultSet resultSet, ResultSpec resultSpec) {
        int n;
        int n2;
        if (resultSet == null || resultSet.items == null || resultSet.items.length <= 0 || resultSpec == null) {
            return false;
        }
        int n3 = resultSpec.maxResultCount != null ? resultSpec.maxResultCount : -1;
        int n4 = n2 = resultSpec.offset != null ? resultSpec.offset : 0;
        if (n2 == 0 && n3 < 0) {
            return false;
        }
        int n5 = n2;
        ResultItem[] resultItemArray = resultSet.items;
        if (n5 < 0 || n5 >= resultItemArray.length) {
            resultSet.items = EMPTY_RESULT_ITEMS;
            return true;
        }
        int n6 = n3 < 0 ? resultItemArray.length : ((n = n2 + n3) < 0 || n > resultItemArray.length ? resultItemArray.length : n);
        resultSet.items = Arrays.copyOfRange(resultItemArray, n5, n6);
        return true;
    }

    public static void sortResult(ResultSet resultSet, ResultSpec resultSpec) {
        if (resultSpec == null || resultSpec.order == null || ArrayUtil.isNullOrEmpty((Object[])resultSpec.order.orderingProperties) || resultSet == null || ArrayUtil.isNullOrEmpty((Object[])resultSet.items)) {
            return;
        }
        ResultItemComparator resultItemComparator = new ResultItemComparator(resultSpec.order);
        Arrays.sort(resultSet.items, resultItemComparator);
    }

    public static PropertyValue getPropertyValue(ResultItem resultItem, String string) {
        if (resultItem == null || resultItem.properties == null || StringUtil.isNullOrEmpty((String)string)) {
            return null;
        }
        for (PropertyValue propertyValue : resultItem.properties) {
            if (propertyValue == null || !string.equals(propertyValue.propertyName)) continue;
            return propertyValue;
        }
        return null;
    }

    public static boolean hasProperty(ResultItem resultItem, String string) {
        return ResultUtil.getPropertyValue(resultItem, string) != null;
    }

    public static void addProperty(ResultItem resultItem, PropertyValue propertyValue) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{resultItem, propertyValue});
        int n = resultItem.properties.length + 1;
        resultItem.properties = Arrays.copyOfRange(resultItem.properties, 0, n);
        resultItem.properties[n - 1] = propertyValue;
    }

    public static ResultSet newEmptyResultSet() {
        ResultSet resultSet = new ResultSet();
        resultSet.totalMatchedObjectCount = 0;
        return resultSet;
    }

    public static ResultSet newErrorResultSet(Exception ... exceptionArray) {
        ResultSet resultSet = new ResultSet();
        if (exceptionArray == null || exceptionArray.length == 0) {
            throw new IllegalArgumentException("Parameters must include at least one exception");
        }
        resultSet.error = exceptionArray.length == 1 ? exceptionArray[0] : new CompositeException(exceptionArray);
        return resultSet;
    }

    public static PropertyValue newProperty(String string, Object object) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Property name is " + (string == null ? "null." : "empty."));
        }
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.propertyName = string;
        propertyValue.value = object;
        return propertyValue;
    }

    public static PropertyValue newProperty(String string, Object object, Object object2) {
        PropertyValue propertyValue = ResultUtil.newProperty(string, object);
        propertyValue.resourceObject = object2;
        return propertyValue;
    }

    public static List<DataException> mergeDuplicates(Collection<DataException> collection) {
        List list = CollectionUtil.mergeDuplicates(collection, (Comparator)new Comparator<DataException>(){

            @Override
            public int compare(DataException dataException, DataException dataException2) {
                Throwable throwable = dataException.rootCause;
                Throwable throwable2 = dataException2.rootCause;
                boolean bl = false;
                if (throwable == null) {
                    if (throwable2 != null) {
                        return -1;
                    }
                    bl = true;
                } else {
                    if (throwable2 == null) {
                        return 1;
                    }
                    String string = throwable.getMessage();
                    String string2 = throwable2.getMessage();
                    boolean bl2 = throwable.getClass().equals(throwable2.getClass()) && (string == null ? string2 == null : string.equals(string2)) ? true : (bl = false);
                }
                if (bl && Arrays.equals(dataException.objects, dataException2.objects)) {
                    return 0;
                }
                return 1;
            }
        }, (Merger)new Merger<DataException>(){

            public DataException merge(DataException dataException, DataException dataException2) {
                String[] stringArray;
                if (dataException.properties == null) {
                    stringArray = dataException2.properties;
                } else if (dataException2.properties == null) {
                    stringArray = dataException.properties;
                } else {
                    stringArray = new String[dataException.properties.length + dataException2.properties.length];
                    System.arraycopy(dataException.properties, 0, stringArray, 0, dataException.properties.length);
                    System.arraycopy(dataException2.properties, 0, stringArray, dataException.properties.length, dataException2.properties.length);
                }
                dataException.properties = stringArray;
                return dataException;
            }
        });
        return list;
    }

    public static void setQueryNamesIntoResults(QuerySpec[] querySpecArray, ResultSet[] resultSetArray) {
        if (querySpecArray == null || resultSetArray == null) {
            return;
        }
        if (querySpecArray.length != resultSetArray.length) {
            throw new IllegalArgumentException("The number of querySpecs (" + querySpecArray.length + ") is different from the number of resultSets (" + resultSetArray.length + ").");
        }
        int n = resultSetArray.length;
        for (int i = 0; i < n; ++i) {
            QuerySpec querySpec;
            ResultSet resultSet = resultSetArray[i];
            if (resultSet == null || (querySpec = querySpecArray[i]) == null || querySpec.name == null) continue;
            if (!StringUtil.isNullOrWhitespace((String)resultSet.queryName) && !resultSet.queryName.equals(querySpec.name)) {
                _logger.warn((Object)("The result set at position " + i + " (0-based) has a queryName (" + resultSet.queryName + ") but it's different from the name of the querySpec (" + querySpec.name + "). The querySpec's name will overwrite" + " the resultSet's name."));
            }
            resultSet.queryName = querySpec.name;
        }
    }
}

