/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.util.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.util.PropertyChangeInfo;
import com.vmware.vise.data.query.util.QueryHelperService;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QueryHelperServiceImpl
implements QueryHelperService {
    private static final Logger _logger = LoggerFactory.getLogger(QueryHelperServiceImpl.class);
    public static final Constraint[] EMPTY_CONSTRAINTS = new Constraint[0];
    public static final ResultSet[] EMPTYSET = new ResultSet[0];
    private final ObjectReferenceService _objectReferenceService;

    public QueryHelperServiceImpl(ObjectReferenceService objectReferenceService) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{objectReferenceService});
        this._objectReferenceService = objectReferenceService;
    }

    @Override
    public String getResourceObjectType(Object object) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{object});
        return this._objectReferenceService.getResourceObjectType(object);
    }

    @Override
    public String getServerGuid(Object object) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{object});
        return this._objectReferenceService.getServerGuid(object);
    }

    @Override
    public String getUid(Object object) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{object});
        return this._objectReferenceService.getUid(object);
    }

    @Override
    public Object getReference(String string) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{string});
        return this._objectReferenceService.getReference(string);
    }

    @Override
    public String getUid(Object object, boolean bl) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{object});
        return this._objectReferenceService.getUid(object, bl);
    }

    @Override
    public Object getReference(String string, boolean bl) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{string});
        return this._objectReferenceService.getReference(string, bl);
    }

    @Override
    public <T> T getProperty(DataService dataService, Object object, String string) throws Exception {
        PropertyValue[] propertyValueArray;
        if (object == null || StringUtil.isNullOrEmpty((String)string)) {
            throw new Exception(Utils.getLocalizedString("error.invalidQueryInput"));
        }
        for (PropertyValue propertyValue : propertyValueArray = this.getProperties(dataService, object, new String[]{string})) {
            if (propertyValue == null || propertyValue.propertyName == null || !propertyValue.propertyName.equals(string)) continue;
            return (T)propertyValue.value;
        }
        return null;
    }

    @Override
    public PropertyValue[] getProperty(DataService dataService, Object[] objectArray, String string) throws Exception {
        return this.getProperties(dataService, objectArray, new String[]{string});
    }

    @Override
    public PropertyValue[] getProperties(DataService dataService, Object object, String[] stringArray) throws Exception {
        return this.getProperties(dataService, new Object[]{object}, stringArray);
    }

    @Override
    public PropertyValue[] getProperties(DataService dataService, Object[] objectArray, String[] stringArray) throws Exception {
        ResultItem[] resultItemArray;
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray) || ArrayUtil.isNullOrEmpty((Object[])stringArray)) {
            throw new Exception(Utils.getLocalizedString("error.invalidQueryInput"));
        }
        Object object = objectArray[0];
        QuerySpec querySpec = this.buildQuerySpec(objectArray, stringArray);
        querySpec.name = this.getUid(object) + ".properties";
        ResultSet resultSet = this.getData(dataService, querySpec);
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
        if (resultSet != null && (resultItemArray = resultSet.items) != null && resultItemArray.length > 0 && resultItemArray[0] != null) {
            for (ResultItem resultItem : resultItemArray) {
                for (PropertyValue propertyValue : resultItem.properties) {
                    propertyValue.resourceObject = resultItem.resourceObject;
                    arrayList.add(propertyValue);
                }
            }
        }
        if (arrayList.isEmpty() && resultSet.error != null) {
            throw resultSet.error;
        }
        return (PropertyValue[])ArrayUtil.toArray(arrayList, PropertyValue.class);
    }

    @Override
    public PropertyValue[] getPropertyForRelatedObjects(DataService dataService, Object object, String string, String string2, String string3) throws Exception {
        return this.getPropertiesForRelatedObjects(dataService, object, string, string2, new String[]{string3});
    }

    @Override
    public PropertyValue[] getPropertiesForRelatedObjects(DataService dataService, Object object, String string, String string2, String[] stringArray) throws Exception {
        if (object == null || ArrayUtil.isNullOrEmpty((Object[])stringArray)) {
            throw new Exception(Utils.getLocalizedString("error.invalidQueryInput"));
        }
        if (StringUtil.isNullOrEmpty((String)string)) {
            return this.getProperties(dataService, object, stringArray);
        }
        ObjectIdentityConstraint objectIdentityConstraint = this.createObjectIdentityConstraint(object);
        RelationalConstraint relationalConstraint = this.createRelationalConstraint(string, objectIdentityConstraint, true, string2);
        QuerySpec querySpec = this.buildQuerySpec(relationalConstraint, stringArray);
        querySpec.name = this.getUid(object) + "." + string + ".properties";
        ResultSet resultSet = this.getData(dataService, querySpec);
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
        if (resultSet != null && resultSet.items != null) {
            for (ResultItem resultItem : resultSet.items) {
                if (resultItem == null || resultItem.properties == null) continue;
                for (PropertyValue propertyValue : resultItem.properties) {
                    if (propertyValue == null) continue;
                    arrayList.add(propertyValue);
                }
            }
        }
        if (arrayList.isEmpty() && resultSet.error != null) {
            throw resultSet.error;
        }
        return (PropertyValue[])ArrayUtil.toArray(arrayList, PropertyValue.class);
    }

    @Override
    public ResultSet getData(DataService dataService, QuerySpec querySpec) throws Exception {
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{querySpec};
        Response response = new Response();
        response = dataService.getData(requestSpec);
        Object[] objectArray = response.resultSet;
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray) || objectArray[0] == null) {
            throw new Exception(Utils.getLocalizedString("error.emptyResult"));
        }
        return objectArray[0];
    }

    @Override
    public <T> T findPropertyValueIn(String string, List<ResultItem> list) {
        if (ArrayUtil.isNullOrEmpty(list)) {
            return null;
        }
        for (ResultItem resultItem : list) {
            Object[] objectArray = resultItem.properties;
            if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) continue;
            for (Object object : objectArray) {
                if (!((PropertyValue)object).propertyName.equals(string)) continue;
                return (T)((PropertyValue)object).value;
            }
        }
        return null;
    }

    @Override
    public boolean checkProperties(PropertyValue[] propertyValueArray, String[] stringArray) {
        if (propertyValueArray == null || stringArray == null || propertyValueArray.length < stringArray.length) {
            return false;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (PropertyValue object : propertyValueArray) {
            if (object == null || object.value == null) {
                return false;
            }
            hashSet.add(object.propertyName);
        }
        for (String string : stringArray) {
            if (string == null || hashSet.contains(string)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object[] findMoRefsIn(ResultSet resultSet) {
        ResultItem[] resultItemArray;
        Object[] objectArray = null;
        if (resultSet != null && (resultItemArray = resultSet.items) != null && resultItemArray.length > 0) {
            objectArray = (Object[])Array.newInstance(resultItemArray[0].resourceObject.getClass(), resultItemArray.length);
            for (int i = 0; i < resultItemArray.length; ++i) {
                objectArray[i] = resultItemArray[i].resourceObject;
            }
        }
        return objectArray;
    }

    @Override
    public String getLocalizedString(String string) {
        return Utils.getLocalizedString(string);
    }

    @Override
    public Boolean waitUntilSearchable(DataService dataService, Object object, String[] stringArray) {
        return this.waitUntilStatusChange(dataService, object, stringArray, true);
    }

    @Override
    public Boolean waitUntilSearchable(DataService dataService, Object object) {
        return this.waitUntilSearchable(dataService, object, new String[]{"name"});
    }

    @Override
    public Boolean waitUntilNotSearchable(DataService dataService, Object object, String[] stringArray) {
        return this.waitUntilStatusChange(dataService, object, stringArray, false);
    }

    @Override
    public Boolean waitUntilNotSearchable(DataService dataService, Object object) {
        return this.waitUntilNotSearchable(dataService, object, new String[]{"name"});
    }

    @Override
    public Boolean waitUntilStatusChange(DataService dataService, Object object, String[] stringArray, boolean bl) {
        PropertyValue[] propertyValueArray = null;
        boolean bl2 = false;
        for (int i = 0; i < 30; ++i) {
            try {
                propertyValueArray = this.getProperties(dataService, object, stringArray);
                boolean bl3 = this.checkProperties(propertyValueArray, stringArray);
                if (bl && bl3) {
                    bl2 = true;
                    break;
                }
                if (!bl && !bl3) {
                    bl2 = true;
                    break;
                }
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception exception) {
                _logger.error(exception.getLocalizedMessage());
            }
        }
        return bl2;
    }

    @Override
    public Boolean waitUntilPropertyChanged(DataService dataService, Object object, PropertyChangeInfo propertyChangeInfo) throws Exception {
        String string = propertyChangeInfo.getPropertyName();
        boolean bl = false;
        _logger.debug("Start waiting for change in property '" + string + "' on object " + this.getUid(object));
        for (int i = 0; i < 30; ++i) {
            Object t = this.getProperty(dataService, object, string);
            bl = propertyChangeInfo.isChanged(t);
            if (bl) {
                _logger.debug("Property '" + string + "' on object " + this.getUid(object) + " has changed!");
                break;
            }
            _logger.debug("No change detected for property '" + string + "' on object " + this.getUid(object));
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception exception) {
                _logger.error(exception.getLocalizedMessage());
            }
        }
        return bl;
    }

    @Override
    public QuerySpec buildQuerySpec(Object object, String[] stringArray) {
        ObjectIdentityConstraint objectIdentityConstraint = new ObjectIdentityConstraint();
        objectIdentityConstraint.target = object;
        String string = this.getResourceObjectType(object);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        QuerySpec querySpec = this.buildQuerySpec(objectIdentityConstraint, stringArray, hashSet);
        return querySpec;
    }

    @Override
    public QuerySpec buildQuerySpec(Object[] objectArray, String[] stringArray) {
        if (objectArray.length == 1) {
            return this.buildQuerySpec(objectArray[0], stringArray);
        }
        CompositeConstraint compositeConstraint = new CompositeConstraint();
        compositeConstraint.conjoiner = Conjoiner.OR;
        Constraint[] constraintArray = new Constraint[objectArray.length];
        HashSet<String> hashSet = new HashSet<String>();
        String string = null;
        for (int i = 0; i < objectArray.length; ++i) {
            ObjectIdentityConstraint objectIdentityConstraint = new ObjectIdentityConstraint();
            objectIdentityConstraint.target = objectArray[i];
            constraintArray[i] = objectIdentityConstraint;
            string = this.getResourceObjectType(objectIdentityConstraint.target);
            hashSet.add(string);
        }
        compositeConstraint.nestedConstraints = constraintArray;
        QuerySpec querySpec = this.buildQuerySpec(compositeConstraint, stringArray, hashSet);
        return querySpec;
    }

    @Override
    public QuerySpec buildQuerySpec(Constraint constraint, String[] stringArray) {
        QuerySpec querySpec = this.buildQuerySpec(constraint, stringArray, null);
        return querySpec;
    }

    @Override
    public QuerySpec buildQuerySpec(Constraint constraint, String[] stringArray, Set<String> set) {
        QuerySpec querySpec = new QuerySpec();
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.constraint = constraint;
        ArrayList<PropertySpec> arrayList = new ArrayList<PropertySpec>();
        if (set != null) {
            for (String string : set) {
                PropertySpec propertySpec = this.createPropertySpec(stringArray, string);
                arrayList.add(propertySpec);
            }
        } else {
            PropertySpec propertySpec = this.createPropertySpec(stringArray, null);
            arrayList.add(propertySpec);
        }
        resourceSpec.propertySpecs = arrayList.toArray(new PropertySpec[0]);
        querySpec.resourceSpec = resourceSpec;
        return querySpec;
    }

    @Override
    public PropertySpec createPropertySpec(String[] stringArray, String string) {
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.type = string;
        propertySpec.propertyNames = stringArray;
        return propertySpec;
    }

    @Override
    public ResourceSpec createEmptyResourceSpec() {
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.propertyNames = new String[0];
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.propertySpecs = new PropertySpec[]{propertySpec};
        return resourceSpec;
    }

    @Override
    public boolean areEquivalent(QuerySpec querySpec, QuerySpec querySpec2) {
        if (querySpec == querySpec2) {
            return true;
        }
        if (querySpec == null || querySpec2 == null) {
            return false;
        }
        return ObjectUtil.objectsEqual((Object)querySpec.resourceSpec, (Object)querySpec2.resourceSpec) && ObjectUtil.objectsEqual((Object)querySpec.resultSpec, (Object)querySpec2.resultSpec) && ObjectUtil.objectsEqual(querySpec.options, querySpec2.options);
    }

    @Override
    public Map<String, Set<String>> getQueryProperties(QuerySpec querySpec, boolean bl) {
        if (querySpec == null || querySpec.resourceSpec == null || ArrayUtil.isNullOrEmpty((Object[])querySpec.resourceSpec.propertySpecs)) {
            return new HashMap<String, Set<String>>();
        }
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        Set<String> set = this.getConstraintTargetTypes(querySpec.resourceSpec.constraint, bl);
        PropertySpec[] propertySpecArray = querySpec.resourceSpec.propertySpecs;
        if (set != null && set.isEmpty()) {
            set.add("*");
        }
        for (PropertySpec propertySpec : propertySpecArray) {
            if (!this.checkPropertySpec(propertySpec)) continue;
            if (StringUtil.isNullOrEmpty((String)propertySpec.type)) {
                for (String string : set) {
                    this.addQueryProperties(hashMap, string, propertySpec.propertyNames);
                }
                continue;
            }
            this.addQueryProperties(hashMap, propertySpec.type, propertySpec.propertyNames);
        }
        return hashMap;
    }

    private void addQueryProperties(Map<String, Set<String>> map, String string, String[] stringArray) {
        Set<String> set = map.get(string);
        if (set == null) {
            set = new HashSet<String>();
            map.put(string, set);
        }
        for (String string2 : stringArray) {
            set.add(Utils.stripIfEndsWith(string2, ".@formatted"));
        }
    }

    private boolean checkPropertySpec(PropertySpec propertySpec) {
        return propertySpec != null && StringUtil.isNullOrEmpty((String)propertySpec.relation) && !ArrayUtil.isNullOrEmpty((Object[])propertySpec.propertyNames);
    }

    @Override
    public RelationalConstraint createRelationalConstraint(String string, Constraint constraint, Boolean bl, String string2) {
        RelationalConstraint relationalConstraint = new RelationalConstraint();
        relationalConstraint.relation = string;
        relationalConstraint.hasInverseRelation = bl;
        relationalConstraint.constraintOnRelatedObject = constraint;
        relationalConstraint.targetType = string2;
        return relationalConstraint;
    }

    @Override
    public Constraint createConstraintForRelationship(Object object, String string, String string2) {
        ObjectIdentityConstraint objectIdentityConstraint = this.createObjectIdentityConstraint(object);
        RelationalConstraint relationalConstraint = this.createRelationalConstraint(string, objectIdentityConstraint, true, string2);
        return relationalConstraint;
    }

    @Override
    public PropertyConstraint createPropertyConstraint(String string, String string2, Comparator comparator, Object object) {
        PropertyConstraint propertyConstraint = new PropertyConstraint();
        propertyConstraint.targetType = string;
        propertyConstraint.propertyName = string2;
        propertyConstraint.comparator = comparator;
        propertyConstraint.comparableValue = object;
        return propertyConstraint;
    }

    @Override
    public Constraint combineIntoSingleConstraint(Constraint[] constraintArray, Conjoiner conjoiner) {
        if (ArrayUtil.isNullOrEmpty((Object[])constraintArray)) {
            return null;
        }
        if (constraintArray.length == 1) {
            return constraintArray[0];
        }
        return this.createCompositeConstraint(constraintArray, conjoiner);
    }

    @Override
    public Constraint combineIntoSingleConstraint(Object[] objectArray, Conjoiner conjoiner) {
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            return null;
        }
        Constraint[] constraintArray = new Constraint[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            ObjectIdentityConstraint objectIdentityConstraint = new ObjectIdentityConstraint();
            objectIdentityConstraint.target = objectArray[i];
            objectIdentityConstraint.targetType = this.getResourceObjectType(objectArray[i]);
            constraintArray[i] = objectIdentityConstraint;
        }
        if (objectArray.length == 1) {
            return constraintArray[0];
        }
        return this.createCompositeConstraint(constraintArray, conjoiner);
    }

    @Override
    public CompositeConstraint createCompositeConstraint(Constraint[] constraintArray, Conjoiner conjoiner) {
        CompositeConstraint compositeConstraint = new CompositeConstraint();
        compositeConstraint.nestedConstraints = constraintArray;
        compositeConstraint.conjoiner = conjoiner;
        return compositeConstraint;
    }

    @Override
    public ObjectIdentityConstraint createObjectIdentityConstraint(Object object) {
        ObjectIdentityConstraint objectIdentityConstraint = new ObjectIdentityConstraint();
        objectIdentityConstraint.target = object;
        objectIdentityConstraint.targetType = this.getResourceObjectType(object);
        return objectIdentityConstraint;
    }

    @Override
    public boolean validateQueryConstraint(Constraint constraint) {
        if (constraint == null) {
            _logger.warn("Invalid constraint: constraint is null");
            return false;
        }
        if (constraint instanceof ObjectIdentityConstraint) {
            boolean bl;
            ObjectIdentityConstraint objectIdentityConstraint = (ObjectIdentityConstraint)constraint;
            boolean bl2 = bl = objectIdentityConstraint.target != null;
            if (!bl) {
                _logger.warn("Invalid constraint: constraint target is null");
            }
            return bl;
        }
        if (constraint instanceof RelationalConstraint) {
            RelationalConstraint relationalConstraint = (RelationalConstraint)constraint;
            if (StringUtil.isNullOrEmpty((String)relationalConstraint.relation)) {
                _logger.warn("Invalid constraint: relational constraint's relation is null");
                return false;
            }
            return this.validateQueryConstraint(relationalConstraint.constraintOnRelatedObject);
        }
        if (constraint instanceof CompositeConstraint) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            if (compositeConstraint.nestedConstraints == null) {
                _logger.warn("Invalid composite constraint: nested constraints are null");
                return false;
            }
            if (compositeConstraint.nestedConstraints.length == 0) {
                _logger.warn("Invalid composite constraint: nested constraints are empty");
                return false;
            }
            if (compositeConstraint.conjoiner == null) {
                _logger.warn("Invalid composite constraint: conjoiner is null");
                return false;
            }
            for (Constraint constraint2 : compositeConstraint.nestedConstraints) {
                if (this.validateQueryConstraint(constraint2)) continue;
                return false;
            }
        } else if (constraint instanceof PropertyConstraint) {
            boolean bl;
            PropertyConstraint propertyConstraint = (PropertyConstraint)constraint;
            boolean bl3 = bl = propertyConstraint.comparator != null;
            if (!bl) {
                _logger.warn("Invalid constraint: property constraint comparator is null");
            }
            return bl;
        }
        return true;
    }

    @Override
    public Set<String> getConstraintTargetTypes(Constraint constraint, boolean bl) {
        if (constraint == null || constraint instanceof RelationalConstraint && ((RelationalConstraint)constraint).hasInverseRelation) {
            return new HashSet<String>();
        }
        String string = constraint.targetType;
        if (constraint instanceof ObjectIdentityConstraint) {
            string = this._objectReferenceService.getResourceObjectType(((ObjectIdentityConstraint)constraint).target);
        } else if (constraint instanceof CompositeConstraint) {
            Constraint[] constraintArray = ((CompositeConstraint)constraint).nestedConstraints;
            constraintArray = constraintArray == null ? new Constraint[]{} : constraintArray;
            HashSet<String> hashSet = new HashSet<String>();
            for (Constraint constraint2 : constraintArray) {
                Set<String> set = this.getConstraintTargetTypes(constraint2, bl);
                if (set.isEmpty()) continue;
                hashSet.addAll(set);
            }
            if (!hashSet.isEmpty()) {
                if (bl) {
                    return hashSet;
                }
                if (hashSet.size() == 1) {
                    string = (String)hashSet.iterator().next();
                }
            }
        }
        return StringUtil.isNullOrEmpty((String)string) ? new HashSet<String>() : new HashSet<String>(Arrays.asList(string));
    }

    @Override
    public String getConstraintTargetType(Constraint constraint) {
        Set<String> set = this.getConstraintTargetTypes(constraint, false);
        if (set != null && set.size() == 1) {
            return set.iterator().next();
        }
        return null;
    }
}

