/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.uri;

import com.vmware.vise.data.uri.ResourceTypeResolver;
import com.vmware.vise.data.uri.ResourceTypeResolverRegistry;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.StringUtil;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class InventoryServiceResourceTypeResolver
implements ResourceTypeResolver {
    public static final String PREFIX = "urn";
    public static final String VMODL2_URN_NAMSPACE = "vapi";
    private static final Log _logger = LogFactory.getLog(InventoryServiceResourceTypeResolver.class);
    private static final String UID_REGEX = "urn(:[^:#]++){4,}+(#[^:#]+)??";
    private static final String VMODL2_UID_REGEX = "urn:vapi:([^:]+):.+";
    private static final Pattern VMODL2_PATTERN = Pattern.compile("urn:vapi:([^:]+):.+");

    public static InventoryServiceResourceTypeResolver getResolver(ResourceTypeResolverRegistry resourceTypeResolverRegistry) {
        InventoryServiceResourceTypeResolver inventoryServiceResourceTypeResolver = new InventoryServiceResourceTypeResolver();
        resourceTypeResolverRegistry.registerSchemeResolver(PREFIX, inventoryServiceResourceTypeResolver);
        return inventoryServiceResourceTypeResolver;
    }

    @Override
    public String getServerGuid(URI uRI) {
        Pair pair;
        String string = uRI.toString();
        Matcher matcher = VMODL2_PATTERN.matcher(string);
        if (matcher.matches()) {
            return null;
        }
        if (!string.matches(UID_REGEX)) {
            _logger.warn((Object)("Uid does not match regex pattern: " + string));
            return null;
        }
        if (string.indexOf(35) != -1) {
            pair = StringUtil.removeLastWord((String)string, (char)'#');
            string = (String)pair.first;
        }
        pair = StringUtil.removeLastWord((String)string, (char)':');
        String string2 = (String)pair.second;
        return string2;
    }

    @Override
    public String getResourceType(URI uRI) {
        String string = uRI.toString();
        Matcher matcher = VMODL2_PATTERN.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            return string2;
        }
        if (!string.matches(UID_REGEX)) {
            _logger.warn((Object)("Uid does not match regex pattern: " + string));
            return null;
        }
        int n = string.indexOf(58, PREFIX.length() + 1);
        String string3 = string.substring(n + 1);
        Pair pair = StringUtil.removeLastWord((String)string3, (char)':');
        pair = StringUtil.removeLastWord((String)((String)pair.first), (char)':');
        String string4 = (String)pair.first;
        return string4;
    }
}

