/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.uri;

import com.vmware.vise.data.uri.ResourceTypeResolver;
import com.vmware.vise.data.uri.ResourceTypeResolverRegistry;
import com.vmware.vise.util.ValidationUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class UriSchemeInitializer {
    private static final Log _logger = LogFactory.getLog(UriSchemeInitializer.class);
    private final ResourceTypeResolverRegistry _typeResolverRegistry;
    private final String _uriScheme;

    public UriSchemeInitializer(ResourceTypeResolverRegistry resourceTypeResolverRegistry, String string, ResourceTypeResolver resourceTypeResolver) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{resourceTypeResolverRegistry, string, resourceTypeResolver});
        this._typeResolverRegistry = resourceTypeResolverRegistry;
        this._uriScheme = string;
        try {
            resourceTypeResolverRegistry.registerSchemeResolver(string, resourceTypeResolver);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            _logger.warn((Object)("Registration failed for URI scheme: " + string), (Throwable)unsupportedOperationException);
        }
    }

    public void close() {
        this._typeResolverRegistry.unregisterSchemeResolver(this._uriScheme);
        _logger.info((Object)("ResourceTypeResolver unregistered for URI scheme: " + this._uriScheme));
    }
}

