/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.metadata;

import com.vmware.vise.core.model.data;
import com.vmware.vise.data.common.NameValuePair;
import com.vmware.vise.data.common.XSFacet;
import com.vmware.vise.data.common.XSFacetType;
import com.vmware.vise.metadata.DataElementDescriptor;
import com.vmware.vise.metadata.Descriptor;
import com.vmware.vise.metadata.Units;
import java.util.Arrays;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlAttribute;

@data
public class PropertyDescriptor
extends DataElementDescriptor {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    @XmlAttribute
    public String[] aliases = EMPTY_STRING_ARRAY;
    @XmlAttribute
    public Boolean immutable;
    @XmlAttribute
    public String inapplicableOperators;
    @XmlAttribute
    public Boolean sortable = Boolean.TRUE;
    public NameValuePair[] mutationArguments;

    public PropertyDescriptor() {
    }

    public PropertyDescriptor(PropertyDescriptor propertyDescriptor) {
        propertyDescriptor.copyFieldsTo(this, false);
    }

    @Override
    protected void copyFieldsTo(Descriptor descriptor, boolean bl) {
        super.copyFieldsTo(descriptor, bl);
        if (descriptor instanceof PropertyDescriptor) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor;
            propertyDescriptor.aliases = this.aliases;
            propertyDescriptor.immutable = this.immutable;
            propertyDescriptor.mutationArguments = this.mutationArguments;
            propertyDescriptor.inapplicableOperators = this.inapplicableOperators;
            propertyDescriptor.sortable = this.sortable;
        }
    }

    @Override
    protected void appendFieldValuesTo(StringBuilder stringBuilder) {
        super.appendFieldValuesTo(stringBuilder);
        stringBuilder.append(", aliases=").append(Arrays.toString(this.aliases)).append(", immutable=").append(this.immutable).append(", inapplicableOperators=").append(this.inapplicableOperators).append(", sortable=").append(this.sortable).append(", mutationArguments=").append(Arrays.toString(this.mutationArguments));
    }

    public static void main(String[] stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("ala", "bala");
        hashMap.put("foo", "bar");
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor();
        propertyDescriptor.name = "name";
        propertyDescriptor.title = "title";
        propertyDescriptor.description = "desc";
        propertyDescriptor.tags = hashMap;
        propertyDescriptor.valueTypeName = "string";
        propertyDescriptor.providerName = "VM";
        propertyDescriptor.displayForm = Units.DATE;
        propertyDescriptor.unit = Units.AUTO;
        propertyDescriptor.defaultValue = "ggbg";
        propertyDescriptor.isOptional = false;
        propertyDescriptor.staticValueSpace = new XSFacet[2];
        propertyDescriptor.staticValueSpace[0] = new XSFacet();
        propertyDescriptor.staticValueSpace[0].type = XSFacetType.FRACTIONDIGITS;
        propertyDescriptor.staticValueSpace[0].value = 5;
        propertyDescriptor.staticValueSpace[1] = new XSFacet();
        propertyDescriptor.staticValueSpace[1].type = XSFacetType.MAXLENGTH;
        propertyDescriptor.staticValueSpace[1].value = 7;
        propertyDescriptor.aliases = new String[]{"al1", "ias2"};
        propertyDescriptor.immutable = false;
        propertyDescriptor.inapplicableOperators = "whizzle";
        propertyDescriptor.sortable = true;
        propertyDescriptor.mutationArguments = new NameValuePair[]{new NameValuePair("nvp", "val")};
        System.out.println(propertyDescriptor);
    }
}

