/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.metadata;

import com.vmware.vise.core.model.data;
import com.vmware.vise.metadata.Descriptor;
import com.vmware.vise.metadata.PropertyNodeDescriptor;
import com.vmware.vise.metadata.TypeDescriptor;
import com.vmware.vise.util.i18n.MessageLocalizer;

@data
public class TypeNodeDescriptor
extends TypeDescriptor {
    public PropertyNodeDescriptor[] properties;

    public TypeNodeDescriptor() {
    }

    public TypeNodeDescriptor(TypeDescriptor typeDescriptor) {
        super(typeDescriptor);
    }

    public TypeNodeDescriptor(TypeNodeDescriptor typeNodeDescriptor) {
        typeNodeDescriptor.copyFieldsTo(this, false);
    }

    public static TypeNodeDescriptor createArrayDescriptor(TypeNodeDescriptor[] typeNodeDescriptorArray) {
        TypeNodeDescriptor typeNodeDescriptor = new TypeNodeDescriptor();
        typeNodeDescriptor.name = "array";
        typeNodeDescriptor.properties = new PropertyNodeDescriptor[typeNodeDescriptorArray.length];
        for (int i = 0; i < typeNodeDescriptorArray.length; ++i) {
            PropertyNodeDescriptor propertyNodeDescriptor = new PropertyNodeDescriptor();
            propertyNodeDescriptor.name = Integer.toString(i);
            propertyNodeDescriptor.valueType = typeNodeDescriptorArray[i];
            typeNodeDescriptor.properties[i] = propertyNodeDescriptor;
        }
        return typeNodeDescriptor;
    }

    @Override
    protected void copyFieldsTo(Descriptor descriptor, boolean bl) {
        super.copyFieldsTo(descriptor, bl);
        if (descriptor instanceof TypeNodeDescriptor) {
            TypeNodeDescriptor typeNodeDescriptor = (TypeNodeDescriptor)descriptor;
            if (bl && this.properties != null) {
                int n = this.properties.length;
                typeNodeDescriptor.properties = new PropertyNodeDescriptor[n];
                for (int i = 0; i < n; ++i) {
                    PropertyNodeDescriptor propertyNodeDescriptor = this.properties[i];
                    if (propertyNodeDescriptor == null) continue;
                    typeNodeDescriptor.properties[i] = new PropertyNodeDescriptor();
                    propertyNodeDescriptor.copyFieldsTo(typeNodeDescriptor.properties[i], true);
                }
            } else {
                typeNodeDescriptor.properties = this.properties;
            }
        }
    }

    @Override
    protected void localize(MessageLocalizer messageLocalizer) {
        super.localize(messageLocalizer);
        if (messageLocalizer == null) {
            return;
        }
        if (this.properties != null) {
            for (PropertyNodeDescriptor propertyNodeDescriptor : this.properties) {
                propertyNodeDescriptor.localize(messageLocalizer);
            }
        }
    }
}

