/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.metadata.impl;

import com.vmware.vise.metadata.impl.BundleMetadata;
import com.vmware.vise.util.ExceptionUtil;
import java.io.IOException;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;

public class BundleMetadataDeserializer {
    private static final Log _logger = LogFactory.getLog(BundleMetadataDeserializer.class);
    private static final String METADATA_FILE_NAME = "resource-info.xml";

    public static BundleMetadata getBundleMetadata(Bundle bundle) {
        BundleMetadata bundleMetadata = new BundleMetadata();
        try {
            URL uRL = bundle.getEntry(METADATA_FILE_NAME);
            if (uRL == null) {
                return null;
            }
            JAXBContext jAXBContext = JAXBContextHolder.INSTANCE;
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            unmarshaller.setEventHandler((ValidationEventHandler)new LoggingJaxbValidationEventHandler(bundle));
            bundleMetadata = (BundleMetadata)unmarshaller.unmarshal(uRL.openStream());
        }
        catch (JAXBException jAXBException) {
            _logger.error((Object)jAXBException);
        }
        catch (IOException iOException) {
            _logger.error((Object)iOException);
        }
        return bundleMetadata;
    }

    static class LoggingJaxbValidationEventHandler
    implements ValidationEventHandler {
        private static final Log _logger = LogFactory.getLog(LoggingJaxbValidationEventHandler.class);
        private final Bundle _bundle;

        public LoggingJaxbValidationEventHandler(Bundle bundle) {
            if (bundle == null) {
                throw new IllegalArgumentException("The bundle shouldn't be null");
            }
            this._bundle = bundle;
        }

        public boolean handleEvent(ValidationEvent validationEvent) {
            int n = validationEvent.getSeverity();
            String string = this.buildMessage(validationEvent);
            if (n == 0) {
                _logger.warn((Object)string);
            } else {
                _logger.error((Object)string);
            }
            return true;
        }

        private String buildMessage(ValidationEvent validationEvent) {
            StringBuilder stringBuilder = new StringBuilder(200);
            ValidationEventLocator validationEventLocator = validationEvent.getLocator();
            if (validationEventLocator.getLineNumber() >= 0) {
                stringBuilder.append("Line ").append(validationEventLocator.getLineNumber());
            }
            if (validationEventLocator.getColumnNumber() >= 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("Column ").append(validationEventLocator.getColumnNumber());
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(": ");
            }
            stringBuilder.append("Problem while parsing the metadata in bundle ").append(this._bundle.getSymbolicName());
            URL uRL = validationEventLocator.getURL();
            if (uRL != null) {
                stringBuilder.append(" from URL ").append(uRL);
            }
            stringBuilder.append(": ").append(validationEvent.getMessage());
            Throwable throwable = validationEvent.getLinkedException();
            if (throwable != null) {
                String string = ExceptionUtil.getStackTrace((Throwable)throwable);
                stringBuilder.append("\nLinked exception: ").append(string);
            }
            return stringBuilder.toString();
        }
    }

    private static class JAXBContextHolder {
        public static final JAXBContext INSTANCE;

        private JAXBContextHolder() {
        }

        static {
            try {
                INSTANCE = JAXBContext.newInstance((Class[])new Class[]{BundleMetadata.class});
            }
            catch (JAXBException jAXBException) {
                throw new ExceptionInInitializerError(jAXBException);
            }
        }
    }
}

