/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.metadata.impl;

import com.vmware.vise.metadata.ResourceUtilMessageLocalizer;
import com.vmware.vise.metadata.TypeDescriptor;
import com.vmware.vise.metadata.impl.BundleMetadata;
import com.vmware.vise.metadata.impl.MetadataServiceRegistryInternal;
import com.vmware.vise.metadata.impl.TypeDescriptorEx;
import com.vmware.vise.util.i18n.MessageLocalizer;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BundleMetadataRegistrar {
    private static final Log _logger = LogFactory.getLog(BundleMetadataRegistrar.class);
    public static MetadataServiceRegistryInternal metadataRegistry;
    private final String _resourceInfoFilename;
    private final String _resourceInfoMessagesFilename;

    public BundleMetadataRegistrar(String string) {
        this(string, null);
    }

    public BundleMetadataRegistrar(String string, String string2) {
        this._resourceInfoFilename = string;
        this._resourceInfoMessagesFilename = string2;
        this.registerMetadata();
    }

    private void registerMetadata() {
        BundleMetadata bundleMetadata = this.getBundleMetadata();
        if (bundleMetadata == null) {
            return;
        }
        _logger.info((Object)("Metadata Service is registering the metadata found in file '" + this._resourceInfoFilename + "'"));
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ResourceUtilMessageLocalizer resourceUtilMessageLocalizer = new ResourceUtilMessageLocalizer(classLoader, this._resourceInfoMessagesFilename);
        if (bundleMetadata.typeInfo != null) {
            this.processTypeInfo(bundleMetadata.typeInfo);
            metadataRegistry.registerTypeMetadata(bundleMetadata.typeInfo, (MessageLocalizer)resourceUtilMessageLocalizer);
        }
        if (bundleMetadata.propertyInfo != null) {
            metadataRegistry.registerPropertyMetadata(bundleMetadata.propertyInfo, resourceUtilMessageLocalizer);
        }
    }

    private void processTypeInfo(TypeDescriptorEx[] typeDescriptorExArray) {
        for (TypeDescriptorEx typeDescriptorEx : typeDescriptorExArray) {
            TypeDescriptor typeDescriptor = typeDescriptorEx.getTypeDescriptor();
            if (typeDescriptor.tags == null) {
                typeDescriptor.tags = new HashMap();
            }
            typeDescriptor.tags.put("userSearchable", "false");
        }
    }

    private BundleMetadata getBundleMetadata() {
        BundleMetadata bundleMetadata = new BundleMetadata();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            InputStream inputStream = classLoader.getResourceAsStream(this._resourceInfoFilename);
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Found metadata stream for: " + this._resourceInfoFilename));
            }
            JAXBContext jAXBContext = JAXBContextHolder.INSTANCE;
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            bundleMetadata = (BundleMetadata)unmarshaller.unmarshal(inputStream);
        }
        catch (JAXBException jAXBException) {
            _logger.error((Object)("Error while reading the resource metadata." + (Object)((Object)jAXBException)));
        }
        return bundleMetadata;
    }

    private static class JAXBContextHolder {
        public static final JAXBContext INSTANCE;

        private JAXBContextHolder() {
        }

        static {
            try {
                INSTANCE = JAXBContext.newInstance((Class[])new Class[]{BundleMetadata.class});
            }
            catch (JAXBException jAXBException) {
                throw new ExceptionInInitializerError(jAXBException);
            }
        }
    }
}

