/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.metadata.impl;

import com.vmware.vise.metadata.Descriptor;
import com.vmware.vise.metadata.MetadataServiceI18nException;
import com.vmware.vise.metadata.PropertyDescriptor;
import com.vmware.vise.metadata.RelationshipDescriptor;
import com.vmware.vise.metadata.TypeDescriptor;
import com.vmware.vise.metadata.impl.BundleMetadataDeserializer;
import com.vmware.vise.metadata.impl.BundleMetadataRegistrar;
import com.vmware.vise.metadata.impl.MetadataServiceRegistryInternal;
import com.vmware.vise.metadata.impl.TypeDescriptorEx;
import com.vmware.vise.metadata.impl.TypeOwnership;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.i18n.MessageLocalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MetadataServiceRegistryImpl
implements MetadataServiceRegistryInternal {
    private static final Log _logger = LogFactory.getLog(BundleMetadataDeserializer.class);
    private final ConcurrentMap<String, DescriptorData<TypeDescriptor, TypeOwnership>> _typeDescriptorRegister = new ConcurrentHashMap<String, DescriptorData<TypeDescriptor, TypeOwnership>>();
    private final Map<String, DescriptorData<RelationshipDescriptor, Object>> _relationshipsRegister = new HashMap<String, DescriptorData<RelationshipDescriptor, Object>>();
    private final Map<String, Map<String, DescriptorData<RelationshipDescriptor, Object>>> _relationshipsBySource = new HashMap<String, Map<String, DescriptorData<RelationshipDescriptor, Object>>>();
    private final Map<String, Map<String, DescriptorData<RelationshipDescriptor, Object>>> _relationshipsByTarget = new HashMap<String, Map<String, DescriptorData<RelationshipDescriptor, Object>>>();
    private final ConcurrentMap<String, Map<String, DescriptorData<PropertyDescriptor, Object>>> _propertyDescriptorRegister = new ConcurrentHashMap<String, Map<String, DescriptorData<PropertyDescriptor, Object>>>();
    private final ReentrantReadWriteLock _propertyDescriptorLock = new ReentrantReadWriteLock();
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final TypeDescriptor[] EMPTY_TYPE_DESCRIPTORS = new TypeDescriptor[0];
    private static final RelationshipDescriptor[] EMPTY_RELATIONSHIP_DESCRIPTORS = new RelationshipDescriptor[0];
    private static final PropertyDescriptor[] EMPTY_PROPERTY_DESCRIPTORS = new PropertyDescriptor[0];

    public void init() {
        BundleMetadataRegistrar.metadataRegistry = this;
    }

    @Override
    public void registerTypeMetadata(TypeDescriptor[] typeDescriptorArray, MessageLocalizer messageLocalizer) {
        for (TypeDescriptor typeDescriptor : typeDescriptorArray) {
            if (typeDescriptor == null) continue;
            if (typeDescriptor.name == null) {
                throw new IllegalArgumentException("The array contains a " + TypeDescriptor.class.getSimpleName() + " without a name.");
            }
            this.registerTypeDescriptor(typeDescriptor, TypeOwnership.COMMON, messageLocalizer);
        }
    }

    @Override
    public void registerTypeMetadata(TypeDescriptorEx[] typeDescriptorExArray, MessageLocalizer messageLocalizer) {
        for (TypeDescriptorEx typeDescriptorEx : typeDescriptorExArray) {
            if (typeDescriptorEx == null) continue;
            TypeDescriptor typeDescriptor = typeDescriptorEx.getTypeDescriptor();
            if (typeDescriptor.name == null) {
                throw new IllegalArgumentException("The array contains a " + TypeDescriptor.class.getSimpleName() + " without a name.");
            }
            TypeOwnership typeOwnership = typeDescriptorEx.getOwnership();
            this.registerTypeDescriptor(typeDescriptor, typeOwnership, messageLocalizer);
        }
    }

    private void registerTypeDescriptor(TypeDescriptor typeDescriptor, TypeOwnership typeOwnership, MessageLocalizer messageLocalizer) {
        String string = typeDescriptor.name;
        DescriptorData<TypeDescriptor, TypeOwnership> descriptorData = new DescriptorData<TypeDescriptor, TypeOwnership>(typeDescriptor, typeOwnership, messageLocalizer);
        DescriptorData<TypeDescriptor, TypeOwnership> descriptorData2 = this._typeDescriptorRegister.putIfAbsent(string, descriptorData);
        if (descriptorData2 != null) {
            _logger.warn((Object)("Did not register type descriptor with name='" + string + "' because another type descriptor by that name is already registered"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerRelationshipMetadata(RelationshipDescriptor[] relationshipDescriptorArray, MessageLocalizer messageLocalizer) {
        for (RelationshipDescriptor relationshipDescriptor : relationshipDescriptorArray) {
            String string = relationshipDescriptor.name;
            Map<String, DescriptorData<RelationshipDescriptor, Object>> map = this._relationshipsRegister;
            synchronized (map) {
                if (!this._relationshipsRegister.containsKey(string)) {
                    DescriptorData descriptorData = new DescriptorData(relationshipDescriptor, messageLocalizer);
                    this._relationshipsRegister.put(string, descriptorData);
                    Map<String, DescriptorData<RelationshipDescriptor, Object>> map2 = this._relationshipsBySource.get(relationshipDescriptor.sourceType);
                    if (map2 == null) {
                        map2 = new HashMap<String, DescriptorData<RelationshipDescriptor, Object>>();
                        this._relationshipsBySource.put(relationshipDescriptor.sourceType, map2);
                    }
                    map2.put(relationshipDescriptor.name, descriptorData);
                    Map<String, DescriptorData<RelationshipDescriptor, Object>> map3 = this._relationshipsByTarget.get(relationshipDescriptor.targetType);
                    if (map3 == null) {
                        map3 = new HashMap<String, DescriptorData<RelationshipDescriptor, Object>>();
                        this._relationshipsByTarget.put(relationshipDescriptor.targetType, map3);
                    }
                    map3.put(relationshipDescriptor.name, descriptorData);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerPropertyMetadata(PropertyDescriptor[] propertyDescriptorArray, MessageLocalizer messageLocalizer) {
        for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
            Object object;
            String string = propertyDescriptor.providerName;
            LinkedHashMap linkedHashMap = (LinkedHashMap)this._propertyDescriptorRegister.get(string);
            if (linkedHashMap == null && (object = (Map)this._propertyDescriptorRegister.putIfAbsent(string, linkedHashMap = new LinkedHashMap())) != null) {
                linkedHashMap = object;
            }
            object = new DescriptorData(propertyDescriptor, messageLocalizer);
            this._propertyDescriptorLock.readLock().lock();
            if (!linkedHashMap.containsKey(propertyDescriptor.name)) {
                this._propertyDescriptorLock.readLock().unlock();
                this._propertyDescriptorLock.writeLock().lock();
                try {
                    if (linkedHashMap.containsKey(propertyDescriptor.name)) continue;
                    linkedHashMap.put(propertyDescriptor.name, object);
                    continue;
                }
                finally {
                    this._propertyDescriptorLock.writeLock().unlock();
                }
            }
            this._propertyDescriptorLock.readLock().unlock();
        }
    }

    @Override
    public TypeDescriptor[] lookUpTypeDescriptors(String string) {
        if (string == null || string.isEmpty()) {
            List<TypeDescriptor> list;
            try {
                list = this.getAllValuesWithI18N(this._typeDescriptorRegister);
            }
            catch (MetadataServiceI18nException metadataServiceI18nException) {
                TypeDescriptor typeDescriptor = (TypeDescriptor)metadataServiceI18nException.getDescriptor();
                throw new MetadataServiceI18nException("Failed to localize " + TypeDescriptor.class.getSimpleName() + " for type " + string + ": " + metadataServiceI18nException.getMessage(), typeDescriptor);
            }
            int n = list.size();
            if (n == 0) {
                return EMPTY_TYPE_DESCRIPTORS;
            }
            return list.toArray(new TypeDescriptor[n]);
        }
        DescriptorData descriptorData = (DescriptorData)this._typeDescriptorRegister.get(string);
        if (descriptorData != null) {
            TypeDescriptor typeDescriptor = (TypeDescriptor)descriptorData.getDescriptor();
            MessageLocalizer messageLocalizer = descriptorData.getMessageLocalizer();
            TypeDescriptor typeDescriptor2 = (TypeDescriptor)typeDescriptor.buildLocalizedCopy(messageLocalizer);
            return new TypeDescriptor[]{typeDescriptor2};
        }
        return EMPTY_TYPE_DESCRIPTORS;
    }

    @Override
    public boolean isTypeExplicit(String string) {
        DescriptorData descriptorData = (DescriptorData)this._typeDescriptorRegister.get(string);
        if (descriptorData == null) {
            return false;
        }
        TypeOwnership typeOwnership = (TypeOwnership)((Object)descriptorData.getAdditionalData());
        boolean bl = typeOwnership == TypeOwnership.EXPLICIT;
        return bl;
    }

    @Override
    public String[] getSupertypes(String string) {
        String[] stringArray;
        if (StringUtil.isNullOrEmpty((String)string) || "Object".equals(string)) {
            return EMPTY_STRINGS;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        String string2 = string;
        while (!StringUtil.isNullOrEmpty((String)string2) && !"Object".equals(string2) && (stringArray = (DescriptorData)this._typeDescriptorRegister.get(string2)) != null) {
            TypeDescriptor typeDescriptor = (TypeDescriptor)stringArray.getDescriptor();
            String string3 = typeDescriptor.supertype;
            if (linkedList.contains(string3) || string.equals(string3)) {
                throw new IllegalStateException("There is a cycle in the type hierarchy of type: " + string);
            }
            if (!StringUtil.isNullOrEmpty((String)string3)) {
                linkedList.add(string3);
            }
            string2 = string3;
        }
        linkedList.add("Object");
        stringArray = linkedList.toArray(EMPTY_STRINGS);
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RelationshipDescriptor[] lookUpRelationshipDescriptors(String string, String string2) {
        RelationshipDescriptor[] relationshipDescriptorArray;
        if (StringUtil.isNullOrEmpty((String)string) && StringUtil.isNullOrEmpty((String)string2)) {
            ArrayList<DescriptorData<RelationshipDescriptor, Object>> arrayList;
            Map<String, DescriptorData<RelationshipDescriptor, Object>> map = this._relationshipsRegister;
            synchronized (map) {
                arrayList = new ArrayList<DescriptorData<RelationshipDescriptor, Object>>(this._relationshipsRegister.values());
            }
            return this.localizeRelationshipDescriptors(arrayList);
        }
        boolean bl = !StringUtil.isNullOrEmpty((String)string);
        boolean bl2 = !StringUtil.isNullOrEmpty((String)string2);
        List list = Collections.emptyList();
        List<DescriptorData<RelationshipDescriptor, Object>> list2 = Collections.emptyList();
        List<DescriptorData<RelationshipDescriptor, Object>> list3 = this._relationshipsRegister;
        synchronized (list3) {
            if (bl && (relationshipDescriptorArray = this._relationshipsBySource.get(string)) != null) {
                list = new ArrayList<DescriptorData<RelationshipDescriptor, Object>>(relationshipDescriptorArray.values());
            }
            if (bl2 && (relationshipDescriptorArray = this._relationshipsByTarget.get(string2)) != null) {
                list2 = new ArrayList<DescriptorData<RelationshipDescriptor, Object>>(relationshipDescriptorArray.values());
            }
        }
        if (!bl2) {
            list3 = list;
        } else if (!bl) {
            list3 = list2;
        } else {
            list.retainAll(list2);
            list3 = list;
        }
        relationshipDescriptorArray = this.localizeRelationshipDescriptors(list3);
        return relationshipDescriptorArray;
    }

    private RelationshipDescriptor[] localizeRelationshipDescriptors(Collection<DescriptorData<RelationshipDescriptor, Object>> collection) {
        if (collection == null || collection.isEmpty()) {
            return EMPTY_RELATIONSHIP_DESCRIPTORS;
        }
        LinkedList<RelationshipDescriptor> linkedList = new LinkedList<RelationshipDescriptor>();
        for (DescriptorData<RelationshipDescriptor, Object> descriptorData : collection) {
            RelationshipDescriptor relationshipDescriptor = descriptorData.getDescriptor();
            MessageLocalizer messageLocalizer = descriptorData.getMessageLocalizer();
            RelationshipDescriptor relationshipDescriptor2 = (RelationshipDescriptor)relationshipDescriptor.buildLocalizedCopy(messageLocalizer);
            linkedList.add(relationshipDescriptor2);
        }
        return linkedList.toArray(new RelationshipDescriptor[linkedList.size()]);
    }

    @Override
    public PropertyDescriptor[] lookUpPropertyDescriptors(String string) {
        List<PropertyDescriptor> list;
        if (StringUtil.isNullOrEmpty((String)string)) {
            list = this.getAllValuesWithI18NFromAllNestedRegisters(this._propertyDescriptorRegister);
        } else {
            Map map = (Map)this._propertyDescriptorRegister.get(string);
            if (map != null) {
                try {
                    list = this.getAllValuesWithI18N(map);
                }
                catch (MetadataServiceI18nException metadataServiceI18nException) {
                    PropertyDescriptor propertyDescriptor = (PropertyDescriptor)metadataServiceI18nException.getDescriptor();
                    throw new MetadataServiceI18nException("Failed to localize " + PropertyDescriptor.class.getSimpleName() + " for type " + string + " and property name '" + propertyDescriptor.name + "': " + metadataServiceI18nException.getMessage(), propertyDescriptor);
                }
            } else {
                return EMPTY_PROPERTY_DESCRIPTORS;
            }
        }
        int n = list.size();
        if (n == 0) {
            return EMPTY_PROPERTY_DESCRIPTORS;
        }
        return list.toArray(new PropertyDescriptor[n]);
    }

    @Override
    public PropertyDescriptor lookUpPropertyDescriptor(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        Map map = (Map)this._propertyDescriptorRegister.get(string);
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return (PropertyDescriptor)this.getValueWithI18N(map, string2);
        }
        catch (MetadataServiceI18nException metadataServiceI18nException) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)metadataServiceI18nException.getDescriptor();
            throw new MetadataServiceI18nException("Failed to localize " + PropertyDescriptor.class.getSimpleName() + " for type " + string + " and property name '" + propertyDescriptor.name + "': " + metadataServiceI18nException.getMessage(), propertyDescriptor);
        }
    }

    private <T extends Descriptor, S> List<T> getAllValuesWithI18NFromAllNestedRegisters(Map<String, ? extends Map<String, DescriptorData<T, S>>> map) {
        if (map == null || map.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList arrayList = new ArrayList(map.size());
        for (Map<String, DescriptorData<T, S>> map2 : map.values()) {
            this.getAllValuesWithI18N(map2, arrayList);
        }
        return arrayList;
    }

    private <T extends Descriptor, S> List<T> getAllValuesWithI18N(Map<String, DescriptorData<T, S>> map) {
        if (map == null || map.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList arrayList = new ArrayList(map.size());
        this.getAllValuesWithI18N(map, arrayList);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Descriptor, S> void getAllValuesWithI18N(Map<String, DescriptorData<T, S>> map, List<T> list) {
        this._propertyDescriptorLock.readLock().lock();
        try {
            for (DescriptorData<T, S> descriptorData : map.values()) {
                T t = descriptorData.getDescriptor();
                MessageLocalizer messageLocalizer = descriptorData.getMessageLocalizer();
                Descriptor descriptor = ((Descriptor)t).buildLocalizedCopy(messageLocalizer);
                list.add(descriptor);
            }
        }
        finally {
            this._propertyDescriptorLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Descriptor, S> T getValueWithI18N(Map<String, DescriptorData<T, S>> map, String string) {
        assert (map != null);
        assert (string != null);
        this._propertyDescriptorLock.readLock().lock();
        try {
            Descriptor descriptor;
            DescriptorData<T, S> descriptorData = map.get(string);
            if (descriptorData == null) {
                T t = null;
                return t;
            }
            T t = descriptorData.getDescriptor();
            MessageLocalizer messageLocalizer = descriptorData.getMessageLocalizer();
            Descriptor descriptor2 = descriptor = ((Descriptor)t).buildLocalizedCopy(messageLocalizer);
            return (T)descriptor2;
        }
        finally {
            this._propertyDescriptorLock.readLock().unlock();
        }
    }

    private static class DescriptorData<T extends Descriptor, A> {
        private final T _desc;
        private final A _additionalData;
        private final MessageLocalizer _msgLoc;
        private volatile int _cachedHashCode;

        DescriptorData(T t, MessageLocalizer messageLocalizer) {
            this(t, null, messageLocalizer);
        }

        DescriptorData(T t, A a, MessageLocalizer messageLocalizer) {
            if (t == null) {
                throw new IllegalArgumentException("The descriptor shouldn't be null");
            }
            this._desc = t;
            this._additionalData = a;
            this._msgLoc = messageLocalizer;
        }

        T getDescriptor() {
            return this._desc;
        }

        A getAdditionalData() {
            return this._additionalData;
        }

        MessageLocalizer getMessageLocalizer() {
            return this._msgLoc;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof DescriptorData) {
                DescriptorData descriptorData = (DescriptorData)object;
                return this._desc.equals(descriptorData._desc) && (this._msgLoc == null ? descriptorData._msgLoc == null : this._msgLoc.equals(descriptorData._msgLoc));
            }
            return false;
        }

        public int hashCode() {
            int n = this._cachedHashCode;
            if (n == 0) {
                n = 17;
                n = 31 * n + this._desc.hashCode();
                this._cachedHashCode = n = 31 * n + (this._msgLoc != null ? this._msgLoc.hashCode() : 0);
            }
            return n;
        }
    }
}

