/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.logbundle;

import com.vmware.cis.services.common.sso.SsoOverRestHelper;
import com.vmware.cis.services.common.sso.SsoOverRestRequest;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.http.Request;
import com.vmware.vise.util.http.HttpClient;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.vim.commons.ssl.SSLBuilder;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.security.sso.SsoUtil;
import com.vmware.vsphere.client.logbundle.UrlZipEntry;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.Map;
import org.apache.commons.httpclient.HttpException;

public class SsoOverRestZipEntry
extends UrlZipEntry {
    private static final int HEADER_CHUNK_SIZE = 1024;
    private final KeyStore _ks;
    private final SSLConfigurationProvider _sslConfigurationProvider;

    public SsoOverRestZipEntry(URI uRI, KeyStore keyStore, SSLConfigurationProvider sSLConfigurationProvider) {
        super(uRI);
        this._ks = keyStore;
        this._sslConfigurationProvider = sSLConfigurationProvider;
    }

    @Override
    protected InputStream connect(String string) throws IOException, HttpException, Exception {
        SamlToken samlToken = AuthSessionUtil.getSsoToken();
        PrivateKey privateKey = SsoUtil.getSolutionUser().getPrivateKey();
        SsoOverRestRequest ssoOverRestRequest = new SsoOverRestRequest(Request.Method.GET, this.url.toURL(), null);
        Map map = SsoOverRestHelper.calcAuthHeader((com.vmware.cis.common.sso.SsoOverRestRequest)ssoOverRestRequest, (PrivateKey)privateKey, (SamlToken)samlToken, (int)1024);
        HttpClient httpClient = new SSLBuilder().sslConfigurationProvider(this._sslConfigurationProvider).addTrustStore(this._ks).socketReadTimeout(Integer.valueOf(0)).buildHttpClientIgnoreErrors();
        return httpClient.executeMethodResponseAsStream(this.url.toURL().toString(), null, map);
    }
}

