/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.logbundle;

import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vsphere.client.logbundle.FileZipEntry;
import com.vmware.vsphere.client.logbundle.HttpZipEntry;
import com.vmware.vsphere.client.logbundle.LogBundleDownloadSpec;
import com.vmware.vsphere.client.logbundle.ScaPublishedLogBundleDownloadSpec;
import com.vmware.vsphere.client.logbundle.SsoOverRestZipEntry;
import com.vmware.vsphere.client.logbundle.exception.ReadIOException;
import com.vmware.vsphere.client.logbundle.exception.WriteIOException;
import com.vmware.vsphere.client.logbundle.helper.DownloadingLogsTask;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.KeyStore;
import java.util.zip.ZipOutputStream;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class UrlZipEntry {
    private static final Log _logger = LogFactory.getLog(UrlZipEntry.class);
    private static final int MAX_BYTES_FOR_READ = 65536;
    private static final String FILE_SCHEME = "file";
    private static final String HTTP_SCHEME = "http";
    private static final String HTTPS_SCHEME = "https";
    private static final String VM_PARAM_SEARCH_PATTERN = "&vm=";
    private static final double MINIMUM_TASK_UPDATE_THRESHOLD = 3.0;
    private static final int INITAL_PROGRESS_UPDATE_PERCENTS = 2;
    private InputStream inputStream = null;
    protected URI url;
    protected long contentLength;

    public static UrlZipEntry getInstance(LogBundleDownloadSpec logBundleDownloadSpec, KeyStore keyStore, SSLConfigurationProvider sSLConfigurationProvider) {
        String string = logBundleDownloadSpec.bundleUrl;
        String string2 = null;
        int n = string.indexOf(VM_PARAM_SEARCH_PATTERN);
        if (n >= 0) {
            string2 = string.substring(n + VM_PARAM_SEARCH_PATTERN.length());
            string = string.substring(0, n);
        }
        URI uRI = URI.create(string);
        if (logBundleDownloadSpec instanceof ScaPublishedLogBundleDownloadSpec) {
            return new SsoOverRestZipEntry(uRI, keyStore, sSLConfigurationProvider);
        }
        String string3 = uRI.getScheme();
        if (FILE_SCHEME.equals(string3 = string3.toLowerCase())) {
            return new FileZipEntry(uRI);
        }
        if (HTTP_SCHEME.equals(string3) || HTTPS_SCHEME.equals(string3)) {
            HttpZipEntry httpZipEntry = new HttpZipEntry(uRI, logBundleDownloadSpec, keyStore, sSLConfigurationProvider);
            if (string2 != null) {
                httpZipEntry.setVmPath(string2);
            }
            httpZipEntry.setEncryptPassword(logBundleDownloadSpec.encryptPassword);
            return httpZipEntry;
        }
        throw new IllegalArgumentException("Unsupported URI scheme: " + string3);
    }

    public UrlZipEntry(URI uRI) {
        this.url = uRI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ZipOutputStream zipOutputStream, String string, DownloadingLogsTask downloadingLogsTask, int n) throws IOException, HttpException, Exception {
        try {
            this.inputStream = this.connect(string);
            byte[] byArray = new byte[65536];
            int n2 = 0;
            int n3 = 0;
            if (downloadingLogsTask != null) {
                downloadingLogsTask.getProgress();
            }
            double d = 0.0;
            boolean bl = false;
            while (true) {
                try {
                    n2 = this.inputStream.read(byArray, 0, 65536);
                }
                catch (IOException iOException) {
                    throw new ReadIOException(iOException);
                }
                if (n2 < 0) break;
                try {
                    zipOutputStream.write(byArray, 0, n2);
                }
                catch (IOException iOException) {
                    throw new WriteIOException(iOException);
                }
                if (downloadingLogsTask == null) continue;
                if ((long)n2 <= this.contentLength) {
                    if (!((d += (double)n2 / (double)this.contentLength * (double)n) > 3.0)) continue;
                    downloadingLogsTask.updateProgress((int)d);
                    d = 0.0;
                    continue;
                }
                if (bl) continue;
                bl = true;
                downloadingLogsTask.updateProgress(2);
            }
            if (downloadingLogsTask != null && n3 + n > downloadingLogsTask.getProgress()) {
                downloadingLogsTask.setProgress(n3 + n);
            }
        }
        finally {
            this.cleanup();
        }
    }

    protected void cleanup() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (IOException iOException) {
            _logger.warn((Object)("Cannot close the stream to url " + this.url), (Throwable)iOException);
        }
    }

    protected abstract InputStream connect(String var1) throws IOException, HttpException, Exception;
}

