/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.logbundle.helper;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.monitor.ClientTaskInfo;
import com.vmware.vise.core.model.monitor.TaskState;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.logbundle.LogBundleDownloadSpec;
import com.vmware.vsphere.client.logbundle.SelectedLogsSpec;
import com.vmware.vsphere.client.task.TaskRegistry;
import com.vmware.vsphere.client.task.impl.TaskUtil;
import java.util.Calendar;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadingLogsTask {
    private static final Log _logger = LogFactory.getLog(DownloadingLogsTask.class);
    private static final String ROOT_FOLDER_ENTITY_TYPE = "rootFolder";
    private static final String NAME_PROPERTY = "name";
    private static final String DOWNLOADING_LOGS_CLIENT_TASK_TYPE = "DownloadingLogsTask";
    private static final String DOWNLOADING_LOGS_CLIENT_TASK_VALUE_PREFIX = "dlt-";
    private static final char FILE_ID_VALUE_DELIMITER = '_';
    private static final String DOWNLOADING_LOGS_TASK_DESCRIPTION_KEY = "downloading.logs.task.description";
    private static final AtomicInteger DOWNLOADING_LOGS_CLIENT_TASK_COUNTER = new AtomicInteger(1);
    private ClientTaskInfo _clientTask;
    private final TaskRegistry _taskRegistry;

    public static ManagedObjectReference findTaskTarget(SelectedLogsSpec selectedLogsSpec, Collection<LogBundleDownloadSpec> collection) {
        if (selectedLogsSpec != null) {
            if (!selectedLogsSpec.vCenterLogsIncluded && !ArrayUtil.isNullOrEmpty((Object[])selectedLogsSpec.selectedHosts) && selectedLogsSpec.selectedHosts.length == 1) {
                return selectedLogsSpec.selectedHosts[0];
            }
            return selectedLogsSpec.targetObjectReference;
        }
        for (LogBundleDownloadSpec logBundleDownloadSpec : collection) {
            if (logBundleDownloadSpec.vcReference == null) continue;
            return logBundleDownloadSpec.vcReference;
        }
        for (LogBundleDownloadSpec logBundleDownloadSpec : collection) {
            if (logBundleDownloadSpec.serviceUuid == null) continue;
            return ManagedObjectUtil.getRootFolder((String)logBundleDownloadSpec.serviceUuid);
        }
        return null;
    }

    public DownloadingLogsTask(String string, ManagedObjectReference managedObjectReference, int n, QueryExecutor queryExecutor, TaskRegistry taskRegistry) {
        if (managedObjectReference == null) {
            throw new IllegalArgumentException("taskTarget must not be null.");
        }
        this._taskRegistry = taskRegistry;
        String string2 = (String)SessionUtil.getData((String)"USER_NAME", (String)string);
        this._clientTask = new ClientTaskInfo();
        this._clientTask.initiator = string2;
        this._clientTask.entity = managedObjectReference;
        this._clientTask.entityType = ManagedObjectUtil.isRootFolder((ManagedObjectReference)managedObjectReference) ? ROOT_FOLDER_ENTITY_TYPE : managedObjectReference.getType();
        this._clientTask.cancelable = true;
        this._clientTask.startTime = Calendar.getInstance().getTime();
        this._clientTask.description = TaskUtil.getLocalizedString((String)DOWNLOADING_LOGS_TASK_DESCRIPTION_KEY);
        this._clientTask.state = TaskState.RUNNING;
        this._clientTask.taskRef = this.generateTaskReference(n, managedObjectReference.getServerGuid());
        try {
            String string3;
            this._clientTask.entityName = string3 = (String)queryExecutor.getProperty((Object)managedObjectReference, NAME_PROPERTY);
        }
        catch (Exception exception) {
            _logger.error((Object)"Cannot get entity name.", (Throwable)exception);
        }
        this._clientTask = this._taskRegistry.addTask(this._clientTask);
    }

    public int getProgress() {
        return this._clientTask.progress;
    }

    public void updateProgress(int n) {
        this._clientTask.progress += n;
        this._taskRegistry.updateTask(this._clientTask);
    }

    public void setProgress(int n) {
        this._clientTask.progress = n;
        this._taskRegistry.updateTask(this._clientTask);
    }

    public TaskState getState() {
        this._clientTask = this._taskRegistry.getTask(this._clientTask.key);
        return this._clientTask.state;
    }

    public void updateState(TaskState taskState, Exception exception) {
        this._clientTask.state = taskState;
        if (exception != null) {
            this._clientTask.error = exception;
        }
        if (TaskState.SUCCESS.equals((Object)taskState)) {
            this._clientTask.completionTime = Calendar.getInstance().getTime();
        }
        this._taskRegistry.updateTask(this._clientTask);
    }

    public String getKey() {
        return this._clientTask.key;
    }

    public ClientTaskInfo getClientTaskInfo() {
        return this._clientTask;
    }

    private ManagedObjectReference generateTaskReference(int n, String string) {
        String string2 = DOWNLOADING_LOGS_CLIENT_TASK_VALUE_PREFIX + DOWNLOADING_LOGS_CLIENT_TASK_COUNTER.getAndIncrement() + '_' + n;
        return new ManagedObjectReference(DOWNLOADING_LOGS_CLIENT_TASK_TYPE, string2, string);
    }
}

