/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.admin.impl;

import com.vmware.vapi.admin.InterposerSyncProvider;
import com.vmware.vapi.admin.InterposerTypes;
import com.vmware.vapi.admin.interposer.impl.Invoker;
import com.vmware.vapi.admin.interposer.impl.PostInterposerHandler;
import com.vmware.vapi.admin.interposer.impl.PreInterposerHandler;
import com.vmware.vapi.admin.interposer.impl.VetoInterposerHandler;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.ApiProviderStubImpl;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.DecoratorApiProvider;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.InterfaceIdentifier;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.std.LocalizableMessage;
import com.vmware.vapi.std.errors.InvalidArgument;
import com.vmware.vapi.std.errors.NotFound;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterposerImpl
extends DecoratorApiProvider
implements InterposerSyncProvider {
    private static final Logger logger = LoggerFactory.getLogger(InterposerImpl.class);
    private static final String INTERPOSER_NOT_FOUND = "No Interposer with id %s was found";
    private Map<String, InterposerDefinition> interposers = new ConcurrentHashMap<String, InterposerDefinition>();
    private Set<MethodIdentifier> interposerMethodIdentifiers;
    private Map<InterposerTypes.InterposerType, List<MethodDefinition>> interposersByType = new ConcurrentHashMap<InterposerTypes.InterposerType, List<MethodDefinition>>();

    public InterposerImpl(ApiProvider decoratedProvider) {
        super(decoratedProvider);
        this.interposersByType.put(InterposerTypes.InterposerType.PRE, new ArrayList());
        this.interposersByType.put(InterposerTypes.InterposerType.VETO, new ArrayList());
        this.interposersByType.put(InterposerTypes.InterposerType.POST, new ArrayList());
        this.interposerMethodIdentifiers = new CopyOnWriteArraySet<MethodIdentifier>();
    }

    @Override
    public String add(InterposerTypes.InterposerInfo spec, InvocationContext invocationContext) {
        return this.addInterposer(spec, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addInterposer(InterposerTypes.InterposerInfo spec, ApiProvider provider) {
        String methodIdentifier;
        MethodIdentifier mi;
        InterposerTypes.InterposerType ipType = spec.getType();
        if (null == ipType) {
            throw new InvalidArgument();
        }
        if (InterposerTypes.InterposerType.POST != ipType && InterposerTypes.InterposerType.PRE != ipType && InterposerTypes.InterposerType.VETO != ipType) {
            throw new InvalidArgument();
        }
        ApiProvider interposerProvider = provider != null ? provider : this.decoratedProvider;
        ApiProviderStubImpl providerStub = new ApiProviderStubImpl(interposerProvider);
        MethodDefinition md = providerStub.getMethod(mi = new MethodIdentifier(methodIdentifier = String.format("%s.%s", spec.getServiceName(), spec.getOperationName())));
        if (md == null) {
            logger.error("No method defintion found for " + methodIdentifier);
            throw new NotFound();
        }
        String id = UUID.randomUUID().toString();
        InterposerImpl interposerImpl = this;
        synchronized (interposerImpl) {
            this.interposers.put(id, new InterposerDefinition(md, spec, interposerProvider));
            this.interposersByType.get((Object)ipType).add(md);
            this.interposerMethodIdentifiers.add(mi);
        }
        logger.debug(String.format("Interposer with id %s added for method identifier %s", id, methodIdentifier));
        return id;
    }

    @Override
    public List<String> list(InvocationContext invocationContext) {
        return new ArrayList<String>(this.interposers.keySet());
    }

    @Override
    public InterposerTypes.InterposerInfo get(String interposerId, InvocationContext invocationContext) {
        InterposerDefinition id = this.interposers.get(interposerId);
        if (id != null) {
            return id.getInterposerInfo();
        }
        ArrayList<LocalizableMessage> msgs = new ArrayList<LocalizableMessage>();
        LocalizableMessage msg = new LocalizableMessage();
        msg.setDefaultMessage(String.format(INTERPOSER_NOT_FOUND, interposerId));
        msgs.add(msg);
        throw new NotFound(msgs, null);
    }

    @Override
    public synchronized void remove(String interposerId, InvocationContext invocationContext) {
        if (!this.interposers.containsKey(interposerId)) {
            logger.error("No Interposer found with id " + interposerId);
            throw new NotFound();
        }
        logger.debug("Removing interposer with identifier " + interposerId);
        InterposerDefinition id = this.interposers.remove(interposerId);
        InterposerTypes.InterposerType ipType = id.getInterposerInfo().getType();
        MethodDefinition md = id.getMethodDefinition();
        this.interposersByType.get((Object)ipType).remove(md);
        this.interposerMethodIdentifiers.remove(md.getIdentifier());
    }

    private boolean executeInterposer(InterposerTypes.InterposerInfo interposerInfo, String interfaceName) {
        boolean execute = false;
        List<String> packages = interposerInfo.getPackages();
        if (packages != null && packages.size() != 0) {
            for (String packageName : packages) {
                if (!interfaceName.startsWith(packageName + ".")) continue;
                execute = true;
                break;
            }
        } else {
            execute = true;
        }
        return execute;
    }

    public void invoke(String serviceId, String operationId, DataValue input, ExecutionContext ctx, AsyncHandle<MethodResult> asyncHandle) {
        MethodIdentifier method = new MethodIdentifier(new InterfaceIdentifier(serviceId), operationId);
        if (this.interposerMethodIdentifiers.contains(method)) {
            this.decoratedProvider.invoke(serviceId, operationId, input, ctx, asyncHandle);
            return;
        }
        InterfaceIdentifier ifaceId = method.getInterfaceIdentifier();
        String ifaceName = ifaceId.getName();
        ArrayList<InterposerDefinition> vetoInterposers = new ArrayList<InterposerDefinition>();
        ArrayList<InterposerDefinition> preInterposers = new ArrayList<InterposerDefinition>();
        ArrayList<InterposerDefinition> postInterposers = new ArrayList<InterposerDefinition>();
        for (String interposerId : this.interposers.keySet()) {
            InterposerTypes.InterposerInfo ii;
            InterposerDefinition id = this.interposers.get(interposerId);
            if (id == null || !this.executeInterposer(ii = id.getInterposerInfo(), ifaceName)) continue;
            if (ii.getType() == InterposerTypes.InterposerType.VETO) {
                vetoInterposers.add(id);
                continue;
            }
            if (ii.getType() == InterposerTypes.InterposerType.PRE) {
                preInterposers.add(id);
                continue;
            }
            if (ii.getType() != InterposerTypes.InterposerType.POST) continue;
            postInterposers.add(id);
        }
        PostInterposerHandler post = new PostInterposerHandler(postInterposers, method, ctx, input, asyncHandle);
        Invoker invoke = new Invoker(this.decoratedProvider, ctx, method, input, post);
        PreInterposerHandler pre = new PreInterposerHandler(preInterposers, method, ctx, input, invoke);
        VetoInterposerHandler veto = new VetoInterposerHandler(vetoInterposers, method, ctx, input, pre, asyncHandle);
        veto.execute();
    }

    public static final class InterposerDefinition {
        private final MethodDefinition methodDefinition;
        private final InterposerTypes.InterposerInfo interposerInfo;
        private final ApiProvider provider;

        public InterposerDefinition(MethodDefinition methodDefinition, InterposerTypes.InterposerInfo interposerInfo, ApiProvider provider) {
            Validate.notNull((Object)methodDefinition);
            Validate.notNull((Object)interposerInfo);
            Validate.notNull((Object)provider);
            this.methodDefinition = methodDefinition;
            this.interposerInfo = interposerInfo;
            this.provider = provider;
        }

        public MethodDefinition getMethodDefinition() {
            return this.methodDefinition;
        }

        public InterposerTypes.InterposerInfo getInterposerInfo() {
            return this.interposerInfo;
        }

        public ApiProvider getProvider() {
            return this.provider;
        }
    }
}

