/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.admin.interposer.impl;

import com.vmware.vapi.admin.impl.InterposerImpl;
import com.vmware.vapi.admin.interposer.impl.Utils;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InterposerHandler {
    static Logger logger = LoggerFactory.getLogger(InterposerHandler.class);
    protected final List<InterposerImpl.InterposerDefinition> interposers;
    protected final MethodIdentifier interposedMethod;
    protected final ExecutionContext context;
    protected final DataValue input;
    protected AsyncHandle<MethodResult> callback;

    public InterposerHandler(List<InterposerImpl.InterposerDefinition> interposers, MethodIdentifier method, ExecutionContext context, DataValue input, AsyncHandle<MethodResult> callBack) {
        this.interposers = interposers;
        this.interposedMethod = method;
        this.context = context;
        this.input = input;
        this.callback = callBack;
    }

    void executeNextInterposer(Iterator<InterposerImpl.InterposerDefinition> iter, AsyncHandle<MethodResult> handler) {
        if (iter.hasNext()) {
            InterposerImpl.InterposerDefinition def = iter.next();
            MethodDefinition md = def.getMethodDefinition();
            ApiProvider provider = def.getProvider();
            provider.invoke(md.getIdentifier().getInterfaceIdentifier().getName(), md.getIdentifier().getName(), Utils.getInterposerInput(this.interposedMethod, md, this.input), this.context, handler);
            this.callback = handler;
        }
    }

    public abstract void execute();
}

