/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.util.async;

import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeBoundOperationHandle
extends AsyncHandle<MethodResult> {
    private static final Logger logger = LoggerFactory.getLogger(TimeBoundOperationHandle.class);
    private final Object lock = new Object();
    private final AsyncHandle<MethodResult> decorated;
    private boolean completed;
    private ScheduledFuture<?> timeoutFuture;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeBoundOperationHandle(AsyncHandle<MethodResult> decorated, ScheduledExecutorService executor, long delayMs) {
        Validate.notNull(decorated);
        Validate.notNull((Object)executor);
        Validate.isTrue((delayMs > 0L ? 1 : 0) != 0);
        this.decorated = decorated;
        this.completed = false;
        ScheduledFuture<?> f = executor.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    TimeBoundOperationHandle.this.onTimeout();
                }
                catch (RuntimeException ex) {
                    logger.warn("Unexpected exception in timeout handler", (Throwable)ex);
                }
            }
        }, delayMs, TimeUnit.MILLISECONDS);
        Object object = this.lock;
        synchronized (object) {
            this.timeoutFuture = f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTimeout() {
        Object object = this.lock;
        synchronized (object) {
            if (this.completed) {
                return;
            }
            this.completed = true;
            this.decorated.setError((RuntimeException)new TimedOutException());
        }
    }

    private void complete() {
        this.completed = true;
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProgress(DataValue progress) {
        Object object = this.lock;
        synchronized (object) {
            if (this.completed) {
                return;
            }
            this.decorated.updateProgress(progress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(MethodResult result) {
        Object object = this.lock;
        synchronized (object) {
            if (this.completed) {
                return;
            }
            this.complete();
            this.decorated.setResult((Object)result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setError(RuntimeException error) {
        Object object = this.lock;
        synchronized (object) {
            if (this.completed) {
                return;
            }
            this.complete();
            this.decorated.setError(error);
        }
    }

    public static final class TimedOutException
    extends RuntimeException {
        private static final long serialVersionUID = 7881586637279609299L;
    }
}

