/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.interposition;

import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.DecoratorApiProvider;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.internal.interposition.PostInterposition;
import com.vmware.vapi.internal.interposition.VetoInterposition;
import com.vmware.vapi.interposition.InterpositionConfig;
import com.vmware.vapi.interposition.InterpositionConfigFactory;
import com.vmware.vapi.interposition.OperationInvocationInfo;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.lang.Validate;

public final class Interposition
extends DecoratorApiProvider {
    private final InterpositionConfigFactory interpositionConfigFactory;
    private final ScheduledExecutorService scheduledExecutor;

    public Interposition(ApiProvider decoratedProvider, InterpositionConfigFactory interpositionConfigFactory, ScheduledExecutorService scheduledExecutor) {
        super(decoratedProvider);
        Validate.notNull((Object)interpositionConfigFactory);
        this.interpositionConfigFactory = interpositionConfigFactory;
        this.scheduledExecutor = scheduledExecutor;
    }

    public void invoke(String serviceId, String operationId, DataValue input, ExecutionContext ctx, AsyncHandle<MethodResult> asyncHandle) {
        OperationInvocationInfo operationInfo = new OperationInvocationInfo(serviceId, operationId, ctx, input);
        InterpositionConfig interpositionConfig = this.interpositionConfigFactory.getInterpositionConfig(operationInfo);
        ApiProvider operationProvider = this.decoratedProvider;
        operationProvider = new PostInterposition(operationProvider, interpositionConfig.getPostInterposers());
        operationProvider = new VetoInterposition(operationProvider, interpositionConfig.getVetoInterposers(), this.scheduledExecutor);
        operationProvider.invoke(serviceId, operationId, input, ctx, asyncHandle);
    }
}

