/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.std.introspection;

import com.vmware.vapi.bindings.server.AsyncContext;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.internal.bindings.server.impl.AsyncContextImpl;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import com.vmware.vapi.std.introspection.ServiceDefinitions;
import com.vmware.vapi.std.introspection.ServiceProvider;
import com.vmware.vapi.std.introspection.ServiceTypes;
import java.util.Arrays;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class ServiceApiInterface
extends ApiInterfaceSkeleton {
    private ServiceProvider impl;

    public ServiceApiInterface() {
        this((Class<? extends ServiceProvider>)null);
    }

    public ServiceApiInterface(Class<? extends ServiceProvider> implClass) {
        this((ServiceProvider)ServiceApiInterface.createImplInstance(implClass, (String)"com.vmware.vapi.std.introspection.impl.ServiceImpl", ServiceProvider.class));
    }

    public ServiceApiInterface(ServiceProvider impl) {
        super("com.vmware.vapi.std.introspection.service");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(ServiceApiInterface.this.getIdentifier(), "get", ServiceDefinitions.__getInput, ServiceDefinitions.__getOutput, ServiceApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, ServiceDefinitions.__getInput, ServiceApiInterface.this.getTypeConverter());
            String id = (String)extr.valueForField("id");
            ServiceApiInterface.this.impl.get(id, (AsyncContext<ServiceTypes.Info>)new AsyncContextImpl(ServiceApiInterface.this.getTypeConverter(), ServiceDefinitions.__getOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(ServiceApiInterface.this.getIdentifier(), "list", ServiceDefinitions.__listInput, ServiceDefinitions.__listOutput, ServiceApiInterface.this.getTypeConverter(), null);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            new StructValueExtractor(inStruct, ServiceDefinitions.__listInput, ServiceApiInterface.this.getTypeConverter());
            ServiceApiInterface.this.impl.list((AsyncContext<Set<String>>)new AsyncContextImpl(ServiceApiInterface.this.getTypeConverter(), ServiceDefinitions.__listOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }
}

