/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.impl;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.EnvironmentBrowser;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.host.FileSystemMountInfo;
import com.vmware.vim.binding.vim.host.MountInfo;
import com.vmware.vim.binding.vim.vm.ConfigTarget;
import com.vmware.vim.binding.vim.vm.DatastoreInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.vm.model.provisioning.DatastoreQueryBinding;
import com.vmware.vsphere.client.vm.model.provisioning.StorageLocatorDatastoreItem;
import com.vmware.vsphere.client.vm.model.provisioning.StorageLocatorItemsData;
import com.vmware.vsphere.client.vm.model.provisioning.StorageLocatorStoragePodItem;
import com.vmware.vsphere.client.vm.model.provisioning.StoragePodQueryBinding;
import com.vmware.vsphere.client.vm.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class H5VmProvisioningStorageProvider
implements PropertyProviderBean {
    private static final String OWNER_PROPERTY = "owner";
    private static final String PARENT_PROPERTY = "parent";
    private static final String VMFS_TYPE = "VMFS";
    private static final String VVOL_TYPE = "VVOL";
    private static final String NFS41_TYPE = "NFS41";
    private static final String NFS3_TYPE = "NFS";
    private static final String VSAN_TYPE = "vsan";
    private final QueryBindingService _queryBindingService;
    private final QueryExecutor _queryExecutor;

    public H5VmProvisioningStorageProvider(QueryBindingServiceFactory queryBindingServiceFactory, QueryExecutor queryExecutor) {
        this._queryBindingService = queryBindingServiceFactory.getQueryBindingService();
        this._queryExecutor = queryExecutor;
    }

    @ModelMetadata(type={"HostSystem", "ClusterComputeResource", "VirtualApp", "ResourcePool"}, propertyNamespace="storageLocator", property="storageLocatorItemsData")
    public StorageLocatorItemsData getStorageLocatorItemsData(ManagedObjectReference moRef, ManagedObjectReference hostRef) throws Exception {
        StorageLocatorItemsData result = new StorageLocatorItemsData();
        EnvironmentBrowser environmentBrowser = this.getEnvironmentBrowser(moRef);
        Map<ManagedObjectReference, DatastoreInfo> datastoreInfos = this.getDatastoreInfoForEnvironmentBrowser(environmentBrowser, hostRef);
        if (datastoreInfos.isEmpty()) {
            result.storagePodItems = new StorageLocatorStoragePodItem[0];
            result.datastoreItems = new StorageLocatorDatastoreItem[0];
            return result;
        }
        Collection dsProperties = this._queryBindingService.prepare(DatastoreQueryBinding.class).fetch(datastoreInfos.keySet());
        ArrayList<StorageLocatorDatastoreItem> datastoreItems = new ArrayList<StorageLocatorDatastoreItem>();
        ArrayList<StorageLocatorStoragePodItem> storagePodItems = new ArrayList<StorageLocatorStoragePodItem>();
        HashSet<ManagedObjectReference> storagePodRefs = new HashSet<ManagedObjectReference>();
        for (DatastoreQueryBinding datastoreQueryBinding : dsProperties) {
            ManagedObjectReference dsRef = (ManagedObjectReference)datastoreQueryBinding.provider;
            DatastoreInfo dsInfo = datastoreInfos.get(dsRef);
            if (dsInfo == null) continue;
            StorageLocatorDatastoreItem datastoreItem = this.newDatastoreItem(dsInfo, datastoreQueryBinding);
            datastoreItems.add(datastoreItem);
            if (datastoreItem.parentStoragePod == null || storagePodRefs.contains(datastoreItem.parentStoragePod)) continue;
            StorageLocatorStoragePodItem podItem = this.newStoragePodItem(datastoreQueryBinding.parentPod);
            storagePodItems.add(podItem);
            storagePodRefs.add(datastoreItem.parentStoragePod);
        }
        result.datastoreItems = datastoreItems.toArray(new StorageLocatorDatastoreItem[datastoreItems.size()]);
        result.storagePodItems = storagePodItems.toArray(new StorageLocatorStoragePodItem[storagePodItems.size()]);
        return result;
    }

    private StorageLocatorDatastoreItem newDatastoreItem(DatastoreInfo dsInfo, DatastoreQueryBinding datastoreQueryBinding) {
        StorageLocatorDatastoreItem datastoreItem = new StorageLocatorDatastoreItem();
        datastoreItem.name = dsInfo.datastore.name;
        datastoreItem.storageRef = dsInfo.datastore.datastore;
        datastoreItem.capacity = dsInfo.datastore.capacity;
        datastoreItem.freeSpace = dsInfo.datastore.freeSpace;
        datastoreItem.provisionedSpace = dsInfo.datastore.capacity - dsInfo.datastore.freeSpace;
        if (dsInfo.datastore.uncommitted != null) {
            datastoreItem.provisionedSpace += dsInfo.datastore.uncommitted.longValue();
        }
        if (datastoreQueryBinding.parentPod != null) {
            datastoreItem.parentStoragePod = (ManagedObjectReference)datastoreQueryBinding.parentPod.provider;
        }
        datastoreItem.type = dsInfo.datastore.type;
        datastoreItem.formattedType = this.formatDatastoreType(dsInfo.datastore.type, datastoreQueryBinding.vmfsMajorVersion);
        datastoreItem.multipleHostAccess = Boolean.TRUE.equals(dsInfo.datastore.multipleHostAccess);
        datastoreItem.hardwareAcceleration = Util.getLocalizedString("hwAcceleration.unknown");
        if (FileSystemMountInfo.VStorageSupportStatus.vStorageSupported.toString().equals(dsInfo.vStorageSupport)) {
            datastoreItem.vStorageSupported = true;
            datastoreItem.hardwareAcceleration = Util.getLocalizedString("hwAcceleration.supported");
        } else if (FileSystemMountInfo.VStorageSupportStatus.vStorageUnsupported.toString().equals(dsInfo.vStorageSupport)) {
            datastoreItem.hardwareAcceleration = Util.getLocalizedString("hwAcceleration.notSupported");
        }
        datastoreItem.thinProvisioningSupported = dsInfo.capability.isPerFileThinProvisioningSupported();
        return datastoreItem;
    }

    private String formatDatastoreType(String dsType, Integer vmfsMajorVersion) {
        if (VMFS_TYPE.equalsIgnoreCase(dsType)) {
            if (vmfsMajorVersion != null) {
                return Util.getLocalizedString("dsType.vmfsWithVersion", vmfsMajorVersion.toString());
            }
            return Util.getLocalizedString("dsType.vmfs");
        }
        if (NFS3_TYPE.equalsIgnoreCase(dsType)) {
            return Util.getLocalizedString("dsType.nfs3");
        }
        if (NFS41_TYPE.equalsIgnoreCase(dsType)) {
            return Util.getLocalizedString("dsType.nfs41");
        }
        if (VSAN_TYPE.equalsIgnoreCase(dsType)) {
            return Util.getLocalizedString("dsType.vsan");
        }
        if (VVOL_TYPE.equalsIgnoreCase(dsType)) {
            return Util.getLocalizedString("dsType.vvol");
        }
        return dsType;
    }

    private StorageLocatorStoragePodItem newStoragePodItem(StoragePodQueryBinding storagePodInfo) {
        StorageLocatorStoragePodItem podItem = new StorageLocatorStoragePodItem();
        podItem.storageRef = (ManagedObjectReference)storagePodInfo.provider;
        podItem.name = storagePodInfo.summary.name;
        podItem.capacity = storagePodInfo.summary.capacity;
        podItem.freeSpace = storagePodInfo.summary.freeSpace;
        podItem.provisionedSpace = storagePodInfo.summary.capacity - storagePodInfo.summary.freeSpace;
        podItem.drsEnabled = Boolean.TRUE.equals(storagePodInfo.drsEnabled);
        return podItem;
    }

    private Map<ManagedObjectReference, DatastoreInfo> getDatastoreInfoForEnvironmentBrowser(EnvironmentBrowser envBrowser, ManagedObjectReference hostRef) {
        HashMap<ManagedObjectReference, DatastoreInfo> result = new HashMap<ManagedObjectReference, DatastoreInfo>();
        if (envBrowser == null) {
            return result;
        }
        ConfigTarget configTarget = envBrowser.queryConfigTarget(hostRef);
        if (configTarget == null || configTarget.datastore == null || configTarget.datastore.length == 0) {
            return result;
        }
        for (DatastoreInfo dsInfo : configTarget.datastore) {
            if (!MountInfo.AccessMode.readWrite.toString().equals(dsInfo.mode) || !dsInfo.datastore.accessible || !Datastore.Summary.MaintenanceModeState.normal.toString().equals(dsInfo.datastore.maintenanceMode)) continue;
            result.put(dsInfo.datastore.datastore, dsInfo);
        }
        return result;
    }

    private EnvironmentBrowser getEnvironmentBrowser(ManagedObjectReference moRef) throws Exception {
        ManagedObjectReference environmentBrowserRef = null;
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)moRef, ResourcePool.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)moRef, VirtualApp.class)) {
            environmentBrowserRef = this.getEnvironmentBrowserForComputeResource((ManagedObjectReference)this._queryExecutor.getProperty((Object)moRef, OWNER_PROPERTY));
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)moRef, HostSystem.class)) {
            environmentBrowserRef = this.getEnvironmentBrowserForComputeResource((ManagedObjectReference)this._queryExecutor.getProperty((Object)moRef, PARENT_PROPERTY));
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)moRef, ClusterComputeResource.class)) {
            environmentBrowserRef = this.getEnvironmentBrowserForComputeResource(moRef);
        }
        if (environmentBrowserRef == null) {
            return null;
        }
        return (EnvironmentBrowser)ManagedObjectUtil.getManagedObject((ManagedObjectReference)environmentBrowserRef);
    }

    private ManagedObjectReference getEnvironmentBrowserForComputeResource(ManagedObjectReference computeResourceMor) throws Exception {
        if (computeResourceMor != null) {
            ComputeResource computeResource = (ComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)computeResourceMor);
            return computeResource.getEnvironmentBrowser();
        }
        return null;
    }
}

