/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.impl;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.model.DerivedProperty;
import com.vmware.cis.data.model.PredicateProperty;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.PropertyParam;
import com.vmware.cis.data.model.QueryModel;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vim.binding.vim.encryption.CryptoKeyId;
import com.vmware.vim.binding.vim.vm.RuntimeInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.Arrays;

@QueryModel(value="VirtualMachine")
public class VmExtendedDataModel {
    @Property(value="VirtualMachine/runtime/consolidationNeeded")
    Boolean consolidationNeeded;
    @Property(value="VirtualMachine/config/version")
    String hwVersion;
    @Property(value="VirtualMachine/guest/toolsVersionStatus2")
    String toolsVersionStatus;
    @Property(value="VirtualMachine/config/template")
    Boolean template;
    @Property(value="VirtualMachine/config/ftInfo/role")
    String ftRole;
    @Property(value="VirtualMachine/runtime/powerState")
    String powerState;
    @Property(value="VirtualMachine/runtime/faultToleranceState")
    String ftState;
    @Property(value="VirtualMachine/runtime/question")
    String question;
    @Property(value="VirtualMachine/config/annotation")
    String annotation;
    @Property(value="VirtualMachine/config/guestFullName")
    String guestOS;
    @Property(value="VirtualMachine/guest/ipAddress")
    String ip;
    @Property(value="VirtualMachine/runtime/host")
    String host;
    @Property(value="VirtualMachine/parentVApp")
    String vapp;
    @Property(value="VirtualMachine/network")
    String allNetwork;
    @Property(value="VirtualMachine/parent")
    String parentFolder;
    @Property(value="VirtualMachine/summary/storage/committed")
    Long usedSpace;
    @Property(value="VirtualMachine/config/files/vmPathName")
    String vmPathName;
    @Property(value="VirtualMachine/runtime/connectionState")
    String connectionState;
    @Property(value="VirtualMachine/config/ftInfo/primaryVM")
    String primaryVM;
    @Property(value="VirtualMachine/config/ftInfo/secondaries")
    String secondaries;
    @Property(value="VirtualMachine/summary/quickStats/overallCpuUsage")
    Long hostCpuUsage;
    @Property(value="VirtualMachine/summary/quickStats/hostMemoryUsage")
    Long hostMemoryUsage;
    @Relationship(value={"VirtualMachine/runtime/host"})
    @Property(value="HostSystem/name")
    String hostName;
    @Relationship(value={"VirtualMachine/runtime/host", "HostSystem/parent"})
    @Property(value="ClusterComputeResource/name")
    String vmClusterName;
    @Relationship(value={"VirtualMachine/network"})
    @Property(value="DistributedVirtualPortgroup/@modelKey")
    ManagedObjectReference[] dvPortGroup;
    @Relationship(value={"VirtualMachine/network"})
    @Property(value="Network/@modelKey")
    ManagedObjectReference[] standardnetwork;
    @Relationship(value={"VirtualMachine/datastore", "Datastore/parent"})
    @Property(value="StoragePod/@modelKey")
    ManagedObjectReference[] storagePod;
    @Relationship(value={"VirtualMachine/network"})
    @Property(value="OpaqueNetwork/@modelKey")
    ManagedObjectReference[] opaquenetwork;
    @Relationship(value={"ScheduledTask/info/taskObject~"})
    @Property(value="ScheduledTask/@modelKey")
    ManagedObjectReference[] scheduledTask;
    @Relationship(value={"VirtualMachine/network"})
    @Property(value="HostNetwork/@modelKey")
    ManagedObjectReference[] hostNetwork;

    @PredicateProperty
    public static Filter getIsSecondaryVM() {
        PropertyPredicate isSecondary = new PropertyPredicate("VirtualMachine/config/ftInfo/role", PropertyPredicate.ComparisonOperator.GREATER, (Object)1);
        PropertyPredicate notTemplate = new PropertyPredicate("VirtualMachine/config/template", PropertyPredicate.ComparisonOperator.EQUAL, (Object)false);
        return new Filter(Arrays.asList(isSecondary, notTemplate));
    }

    @PredicateProperty
    public static PropertyPredicate getHasSnapshot() {
        return new PropertyPredicate("VirtualMachine/snapshot", PropertyPredicate.ComparisonOperator.UNSET, (Object)false);
    }

    @DerivedProperty
    public static String getHaProtected(@PropertyParam(value="VirtualMachine/runtime/dasVmProtection") RuntimeInfo.DasProtectionState dasProtectionState) {
        if (dasProtectionState == null) {
            return "na";
        }
        return String.valueOf(dasProtectionState.dasProtected);
    }

    @DerivedProperty
    public static String getHaProtectedLabel(@PropertyParam(value="VirtualMachine/runtime/dasVmProtection") RuntimeInfo.DasProtectionState dasProtectionState) {
        return VmExtendedDataModel.getHaProtected(dasProtectionState);
    }

    @DerivedProperty
    public static Boolean getIsEncryptedVm(@PropertyParam(value="VirtualMachine/config/keyId") CryptoKeyId keyId) {
        return keyId != null;
    }
}

