/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.migration.impl;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.cluster.PlacementResult;
import com.vmware.vim.binding.vim.cluster.PlacementSpec;
import com.vmware.vim.binding.vim.cluster.RuleInfo;
import com.vmware.vim.binding.vim.vm.ConfigInfo;
import com.vmware.vim.binding.vim.vm.ConfigSpec;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualDeviceSpec;
import com.vmware.vim.binding.vim.vm.device.VirtualDisk;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vim.binding.vim.vm.device.VirtualNVDIMM;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.common.ServiceLocatorFactory;
import com.vmware.vsphere.client.vm.check.CheckType;
import com.vmware.vsphere.client.vm.config.impl.ConfigSpecBuilder;
import com.vmware.vsphere.client.vm.migration.LocationSpec;
import com.vmware.vsphere.client.vm.migration.LocationSpecPair;
import com.vmware.vsphere.client.vm.migration.VmPlacementSpec;
import com.vmware.vsphere.client.vm.util.Util;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XdrsPlacementRecommendationsValidator
implements MutationProvider {
    private static final Log LOGGER = LogFactory.getLog(XdrsPlacementRecommendationsValidator.class);
    private static final String VM_CONFIG_PROPERTY = "config";
    private static final String VM_CLUSTER_RELATION = "cluster";
    private final DataService _dataService;
    private final ServiceLocatorFactory _serviceLocatorFactory;

    public XdrsPlacementRecommendationsValidator(DataService dataService, ServiceLocatorFactory serviceLocatorFactory) {
        this._dataService = dataService;
        this._serviceLocatorFactory = serviceLocatorFactory;
    }

    public ValidationResult validate(ManagedObjectReference clusterRef, VmPlacementSpec vmPlacementSpec) {
        ValidationResult result = new ValidationResult();
        result.entity = clusterRef;
        try {
            boolean isXvcMigration = this.isXvcRelocation(vmPlacementSpec);
            PropertyValue[] vmData = this.getVmData(vmPlacementSpec.vm, isXvcMigration);
            PlacementSpec placementSpec = this.createPlacementSpec(vmPlacementSpec, vmData);
            ClusterComputeResource cluster = (ClusterComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)clusterRef);
            PlacementResult vmPlacementResult = cluster.placeVm(placementSpec);
            result.result = vmPlacementResult;
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Cannot retrieve cluster placement recommendation!", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    private final boolean isXvcRelocation(VmPlacementSpec vmPlacementSpec) {
        LocationSpecPair locationSpecPair = XdrsPlacementRecommendationsValidator.createLocationSpecPair(vmPlacementSpec);
        Util.populateVcServiceIfNeeded(locationSpecPair, this._serviceLocatorFactory);
        return vmPlacementSpec.relocateSpec.service != null;
    }

    private final PropertyValue[] getVmData(ManagedObjectReference vm, boolean isXvcRelocation) throws Exception {
        String[] vmProperties = isXvcRelocation ? new String[]{VM_CLUSTER_RELATION, VM_CONFIG_PROPERTY} : new String[]{VM_CLUSTER_RELATION};
        return QueryUtil.getProperties((DataService)this._dataService, (Object)vm, (String[])vmProperties);
    }

    private final PlacementSpec createPlacementSpec(VmPlacementSpec vmPlacementSpec, PropertyValue[] vmData) throws Exception {
        PlacementSpec placementSpec = new PlacementSpec();
        placementSpec.priority = vmPlacementSpec.priority;
        placementSpec.vm = vmPlacementSpec.vm;
        placementSpec.relocateSpec = vmPlacementSpec.relocateSpec;
        ManagedObjectReference storageRef = vmPlacementSpec.relocateSpec.datastore;
        if (storageRef != null && ManagedObjectUtil.isOfType((ManagedObjectReference)storageRef, StoragePod.class)) {
            placementSpec.storagePods = new ManagedObjectReference[]{storageRef};
            placementSpec.relocateSpec.datastore = null;
        }
        XdrsPlacementRecommendationsValidator.populateVmData(placementSpec, vmData);
        LocationSpecPair locationSpecPair = XdrsPlacementRecommendationsValidator.createLocationSpecPair(vmPlacementSpec);
        placementSpec.hosts = Util.getValidDestinationHosts(placementSpec.relocateSpec.pool, locationSpecPair, this._dataService);
        return placementSpec;
    }

    private static final LocationSpecPair createLocationSpecPair(VmPlacementSpec vmPlacementSpec) {
        LocationSpec locationSpec = new LocationSpec();
        locationSpec.relocateSpec = vmPlacementSpec.relocateSpec;
        locationSpec.priority = vmPlacementSpec.priority;
        locationSpec.testsToRun = new CheckType[]{CheckType.sourceTests, CheckType.resourcePoolTests, CheckType.hostTests, CheckType.networkTests, CheckType.datastoreTests};
        LocationSpecPair locationSpecPair = new LocationSpecPair();
        locationSpecPair.entity = vmPlacementSpec.vm;
        locationSpecPair.spec = locationSpec;
        return locationSpecPair;
    }

    private static final void populateVmData(PlacementSpec placementSpec, PropertyValue[] vmData) throws Exception {
        ClusterComputeResource sourceCluster = null;
        ConfigSpec configSpec = null;
        for (PropertyValue propVal : vmData) {
            if (propVal == null) continue;
            if (VM_CLUSTER_RELATION.equals(propVal.propertyName) && propVal.value instanceof ManagedObjectReference) {
                ManagedObjectReference sourceClusterRef = (ManagedObjectReference)propVal.value;
                sourceCluster = (ClusterComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)sourceClusterRef);
                continue;
            }
            if (!VM_CONFIG_PROPERTY.equals(propVal.propertyName) || !(propVal.value instanceof ConfigInfo)) continue;
            ConfigInfo vmConfigInfo = (ConfigInfo)propVal.value;
            configSpec = ConfigSpecBuilder.createSpec(vmConfigInfo);
            XdrsPlacementRecommendationsValidator.populateDeviceChange(configSpec, vmConfigInfo);
        }
        if (sourceCluster != null) {
            RuleInfo[] existingVmRules = null;
            try {
                existingVmRules = sourceCluster.findRulesForVm(placementSpec.vm);
            }
            catch (Exception ex) {
                LOGGER.debug((Object)"Error, while retrieving existing VM DRS rules!", (Throwable)ex);
            }
            placementSpec.rules = existingVmRules;
        }
        if (configSpec != null) {
            placementSpec.configSpec = configSpec;
        }
    }

    private static final void populateDeviceChange(ConfigSpec configSpec, ConfigInfo configInfo) {
        ArrayList<VirtualDeviceSpec> deviceSpecs = new ArrayList<VirtualDeviceSpec>();
        for (VirtualDevice vmDevice : configInfo.hardware.device) {
            if (!(vmDevice instanceof VirtualEthernetCard) && !(vmDevice instanceof VirtualNVDIMM) && !(vmDevice instanceof VirtualDisk)) continue;
            VirtualDeviceSpec vmDeviceSpec = new VirtualDeviceSpec();
            vmDeviceSpec.operation = VirtualDeviceSpec.Operation.edit;
            vmDeviceSpec.device = vmDevice;
            if (vmDevice instanceof VirtualDisk) {
                vmDeviceSpec.fileOperation = VirtualDeviceSpec.FileOperation.replace;
            }
            deviceSpecs.add(vmDeviceSpec);
        }
        configSpec.deviceChange = (VirtualDeviceSpec[])ArrayUtil.toArray(deviceSpecs, VirtualDeviceSpec.class);
    }
}

