/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.powerops.impl;

import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.action.MethodAction;
import com.vmware.vim.binding.vim.cluster.AttemptedVmInfo;
import com.vmware.vim.binding.vim.cluster.PowerOnVmResult;
import com.vmware.vim.binding.vim.scheduler.ScheduledTaskSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationEffect;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.security.LegacyAuthorizationService;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.common.util.SchedulingUtil;
import com.vmware.vsphere.client.vm.powerops.VmPowerStateSpec;
import com.vmware.vsphere.client.vm.util.Util;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmPowerOpManager {
    private static final Log _logger = LogFactory.getLog(VmPowerOpManager.class);
    private static final String PRIVILEGE_SYSTEM_READ = "System.Read";
    private DataService _dataService;
    private TaskMonitor _taskMonitor;
    private LegacyAuthorizationService _authService;

    public VmPowerOpManager(DataService dataService, TaskMonitor taskMonitor, LegacyAuthorizationService authService) {
        this._dataService = dataService;
        this._taskMonitor = taskMonitor;
        this._authService = authService;
    }

    public OperationResult[] applyPowerOp(ManagedObjectReference[] entities, VmPowerStateSpec spec) {
        try {
            Util.validatePowerStateSpec(spec);
            if (entities == null) {
                throw new IllegalArgumentException(Util.getLocalizedString("error.invalidEntityArgument"));
            }
            switch (spec.powerState) {
                case poweredOff: {
                    if (spec.powerOpType == VmPowerStateSpec.PowerOpType.hard) {
                        return VmPowerOpManager.powerOff(entities);
                    }
                    if (spec.powerOpType == VmPowerStateSpec.PowerOpType.soft) {
                        return VmPowerOpManager.shutDown(entities);
                    }
                    throw new IllegalArgumentException(Util.getLocalizedString("error.unrecognizedPowerOp"));
                }
                case poweredOn: {
                    if (spec.reset) {
                        if (spec.powerOpType == VmPowerStateSpec.PowerOpType.hard) {
                            return VmPowerOpManager.reset(entities);
                        }
                        if (spec.powerOpType == VmPowerStateSpec.PowerOpType.soft) {
                            return VmPowerOpManager.reboot(entities);
                        }
                        throw new IllegalArgumentException(Util.getLocalizedString("error.unrecognizedPowerOp"));
                    }
                    return this.powerOn(entities);
                }
                case suspended: {
                    return VmPowerOpManager.suspend(entities);
                }
            }
            throw new IllegalArgumentException(Util.getLocalizedString("error.unrecognizedPowerOp"));
        }
        catch (IllegalArgumentException ex) {
            _logger.error((Object)"Invalid parameters to applyPowerOp", (Throwable)ex);
            OperationResult result = new OperationResult();
            result.error = MixedUtil.getMethodFault((Throwable)ex);
            return new OperationResult[]{result};
        }
    }

    public ManagedObjectReference applyEntityDeferredExisting(ManagedObjectReference vm, VmPowerStateSpec spec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec, String operationId) throws Exception {
        ScheduledTaskSpec vcTaskSpec = SchedulingUtil.newVcScheduledTaskSpec((com.vmware.vise.core.model.scheduling.ScheduledTaskSpec)scheduleSpec);
        MethodAction action = SchedulingUtil.newMethodAction((String)operationId, (Object[])new Object[0]);
        vcTaskSpec.action = action;
        return SchedulingUtil.updateVcScheduledTask((com.vmware.vise.core.model.scheduling.ScheduledTaskSpec)scheduleSpec, (ScheduledTaskSpec)vcTaskSpec);
    }

    public ManagedObjectReference applyEntityDeferredNew(ManagedObjectReference vm, VmPowerStateSpec spec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec, String operationId) throws Exception {
        ScheduledTaskSpec vcTaskSpec = SchedulingUtil.newVcScheduledTaskSpec((com.vmware.vise.core.model.scheduling.ScheduledTaskSpec)scheduleSpec);
        MethodAction action = SchedulingUtil.newMethodAction((String)operationId, (Object[])new Object[0]);
        vcTaskSpec.action = action;
        return SchedulingUtil.createVcScheduledTask((DataService)this._dataService, (ManagedObjectReference)vm, (ScheduledTaskSpec)vcTaskSpec);
    }

    private static OperationResult[] powerOff(ManagedObjectReference[] entities) {
        OperationResult[] results = new OperationResult[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            OperationResult result = new OperationResult();
            result.entity = entities[i];
            results[i] = result;
            try {
                VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)entities[i]);
                result = VmPowerOpManager.powerOff(vm, result);
                continue;
            }
            catch (Exception ex) {
                result.error = MixedUtil.getMethodFault((Throwable)ex);
            }
        }
        return results;
    }

    private static OperationResult powerOff(VirtualMachine vm, OperationResult result) {
        result.effect = OperationEffect.newDelayedEffect();
        ManagedObjectReference parentVApp = vm.getParentVApp();
        if (parentVApp != null) {
            result.effect.affectedEntites = new Object[]{parentVApp};
        }
        try {
            ManagedObjectReference taskRef = vm.powerOff();
            result.task = taskRef;
        }
        catch (Exception ex) {
            _logger.error((Object)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    private static OperationResult[] shutDown(ManagedObjectReference[] entities) {
        OperationResult[] results = new OperationResult[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            OperationResult result = new OperationResult();
            result.entity = entities[i];
            result.effect = OperationEffect.newDelayedEffect();
            results[i] = result;
            try {
                VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)entities[i]);
                ManagedObjectReference parentVApp = vm.getParentVApp();
                if (parentVApp != null) {
                    result.effect.affectedEntites = new Object[]{parentVApp};
                }
                vm.shutdownGuest();
                continue;
            }
            catch (Exception ex) {
                _logger.error((Object)ex);
                result.error = MixedUtil.getMethodFault((Throwable)ex);
            }
        }
        return results;
    }

    private static OperationResult[] reboot(ManagedObjectReference[] entities) {
        OperationResult[] results = new OperationResult[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            OperationResult result = new OperationResult();
            result.entity = entities[i];
            results[i] = result;
            try {
                VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)entities[i]);
                ManagedObjectReference parentVApp = vm.getParentVApp();
                if (parentVApp != null) {
                    result.effect = new OperationEffect();
                    result.effect.affectedEntites = new Object[]{parentVApp};
                }
                vm.rebootGuest();
                continue;
            }
            catch (Exception ex) {
                _logger.error((Object)ex);
                result.error = MixedUtil.getMethodFault((Throwable)ex);
            }
        }
        return results;
    }

    private static OperationResult[] suspend(ManagedObjectReference[] entities) {
        OperationResult[] results = new OperationResult[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            OperationResult result = new OperationResult();
            result.entity = entities[i];
            results[i] = result;
            try {
                VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)entities[i]);
                result = VmPowerOpManager.suspend(vm, result);
                continue;
            }
            catch (Exception ex) {
                result.error = MixedUtil.getMethodFault((Throwable)ex);
            }
        }
        return results;
    }

    private static OperationResult suspend(VirtualMachine vm, OperationResult result) {
        result.effect = OperationEffect.newDelayedEffect();
        ManagedObjectReference parentVApp = vm.getParentVApp();
        if (parentVApp != null) {
            result.effect.affectedEntites = new Object[]{parentVApp};
        }
        try {
            ManagedObjectReference taskRef = vm.suspend();
            result.task = taskRef;
        }
        catch (Exception ex) {
            _logger.error((Object)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    private static OperationResult[] reset(ManagedObjectReference[] entities) {
        OperationResult[] results = new OperationResult[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            OperationResult result = new OperationResult();
            result.entity = entities[i];
            results[i] = result;
            try {
                VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)entities[i]);
                result = VmPowerOpManager.reset(vm, result);
                continue;
            }
            catch (Exception ex) {
                result.error = MixedUtil.getMethodFault((Throwable)ex);
            }
        }
        return results;
    }

    private static OperationResult reset(VirtualMachine vm, OperationResult result) {
        result.effect = OperationEffect.newDelayedEffect();
        ManagedObjectReference parentVApp = vm.getParentVApp();
        if (parentVApp != null) {
            result.effect.affectedEntites = new Object[]{parentVApp};
        }
        try {
            ManagedObjectReference taskRef = vm.reset();
            result.task = taskRef;
        }
        catch (Exception ex) {
            _logger.error((Object)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    private OperationResult[] powerOn(ManagedObjectReference[] entities) {
        return this.powerOnPerVc(entities);
    }

    private OperationResult[] powerOnPerVc(ManagedObjectReference[] entities) {
        Map<String, ArrayList<ManagedObjectReference>> vmsByService = Util.getVmsByService(entities);
        ArrayList<OperationResult> results = new ArrayList<OperationResult>();
        for (String vc : vmsByService.keySet()) {
            ArrayList<ManagedObjectReference> vmGroup = vmsByService.get(vc);
            results.addAll(this.powerOnViaDatacenter(vmGroup));
        }
        return results.toArray(new OperationResult[0]);
    }

    private ArrayList<OperationResult> powerOnViaDatacenter(ArrayList<ManagedObjectReference> vmGroup) {
        ArrayList<OperationResult> results = new ArrayList<OperationResult>();
        Datacenter dc = null;
        try {
            OperationResult result;
            ManagedObjectReference[] vms = vmGroup.toArray(new ManagedObjectReference[0]);
            Util.VmDc[] vmDcList = Util.getDatacenterForVmList(vms, this._dataService);
            if (vmDcList == null) {
                return results;
            }
            ArrayList<ManagedObjectReference> vmsWithDC = new ArrayList<ManagedObjectReference>();
            for (Util.VmDc vmDc : vmDcList) {
                if (vmDc.dc == null) {
                    OperationResult result2 = new OperationResult();
                    result2.entity = vmDc.vm;
                    result2.error = MixedUtil.getMethodFault((Throwable)Util.getVmNotFoundError(vmDc.vm));
                    results.add(result2);
                    continue;
                }
                if (dc == null) {
                    dc = vmDc.dc;
                }
                vmsWithDC.add(vmDc.vm);
            }
            if (dc == null) {
                return results;
            }
            vms = vmsWithDC.toArray(new ManagedObjectReference[0]);
            ManagedObjectReference taskRef = dc.powerOnVm(vms, null);
            boolean hasSystemReadPrivilege = this._authService.checkPrivileges(new ManagedObjectReference[]{dc._getRef()}, new String[]{PRIVILEGE_SYSTEM_READ});
            if (!hasSystemReadPrivilege) {
                return null;
            }
            TaskInfo dcTaskInfo = this._taskMonitor.monitorTask(taskRef);
            if (dcTaskInfo.error != null) {
                throw dcTaskInfo.error;
            }
            PowerOnVmResult dcTaskResult = (PowerOnVmResult)dcTaskInfo.result;
            OperationResult dcResult = new OperationResult();
            dcResult.entity = dc._getRef();
            dcResult.result = dcTaskResult;
            results.add(dcResult);
            if (dcTaskResult.attempted != null) {
                for (AttemptedVmInfo attemptedVmInfo : dcTaskResult.attempted) {
                    result = new OperationResult();
                    result.entity = attemptedVmInfo.vm;
                    result.task = attemptedVmInfo.task;
                    result.effect = OperationEffect.newDelayedEffect();
                    VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)attemptedVmInfo.vm);
                    ManagedObjectReference parentVApp = vm.getParentVApp();
                    if (parentVApp != null) {
                        result.effect.affectedEntites = new Object[]{parentVApp};
                    }
                    results.add(result);
                }
            }
            if (dcTaskResult.notAttempted != null) {
                for (AttemptedVmInfo attemptedVmInfo : dcTaskResult.notAttempted) {
                    result = new OperationResult();
                    result.entity = attemptedVmInfo.vm;
                    result.error = MixedUtil.getMethodFault((Throwable)attemptedVmInfo.fault);
                    results.add(result);
                }
            }
        }
        catch (Exception ex) {
            _logger.error((Object)ex);
            OperationResult result = new OperationResult();
            result.entity = dc != null ? dc._getRef() : null;
            result.error = MixedUtil.getMethodFault((Throwable)ex);
            results.add(result);
        }
        return results;
    }
}

