/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.screenshot;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.http.NonValidatingSSLSocketFactory;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.vm.screenshot.VmScreenshotSize;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmScreenshotPropertyProvider
implements PropertyProviderBean {
    public static final String PROPERTY_VM_SCREENSHOT = "vmScreenshot";
    public static final int DEFAULT_SCREENSHOT_WIDTH = 400;
    public static final int DEFAULT_SCREENSHOT_HEIGHT = 300;
    public static final int DEFAULT_HTTPS_PORT = 443;
    public static final int TIMEOUT = 10000;
    private static final Log _logger = LogFactory.getLog(VmScreenshotPropertyProvider.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @type(value="VirtualMachine,VirtualMachineSnapshot")
    public byte[] getVmScreenshot(ManagedObjectReference moRef, VmScreenshotSize size) throws IOException, HttpException {
        byte[] imageBytes = null;
        VcService service = VimSessionUtil.getService((String)moRef.getServerGuid());
        StringBuilder sb = new StringBuilder(VcServiceUtil.getServiceUrl((VcService)service));
        sb.append("/screen?id=" + moRef.getValue());
        if (size != null && size.height > 0 && size.width > 0) {
            sb.append("&h=" + size.height + "&w=" + size.width);
        }
        String strURL = sb.toString();
        HttpClient httpClient = new HttpClient();
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(10000);
        httpClient.getHttpConnectionManager().getParams().setSoTimeout(10000);
        GetMethod httpget = new GetMethod(strURL);
        httpget.getParams().setSoTimeout(10000);
        String cookie = "vmware_soap_session=" + service.getConnectionInfo().getSessionCookie();
        _logger.debug((Object)("Cookie: " + cookie));
        httpget.addRequestHeader("Cookie", cookie);
        if (strURL.startsWith("https")) {
            URL url = new URL(strURL);
            int portNum = url.getPort();
            if (portNum <= 0) {
                portNum = 443;
            }
            Protocol protocol = new Protocol("https", (ProtocolSocketFactory)new NonValidatingSSLSocketFactory(), portNum);
            Protocol.registerProtocol((String)"https", (Protocol)protocol);
            try {
                int statusCode = httpClient.executeMethod((HttpMethod)httpget);
                _logger.debug((Object)("Get screenshot method status code: " + statusCode));
                if (statusCode != 200) {
                    _logger.error((Object)("HTTP Get VM screenshot method failed: " + httpget.getStatusLine()));
                }
                imageBytes = httpget.getResponseBody();
            }
            catch (Exception e) {
                _logger.error((Object)e.getMessage());
            }
            finally {
                httpget.releaseConnection();
            }
        }
        return imageBytes;
    }
}

